/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.metric;

import com.linecorp.armeria.common.RequestContext;
import com.linecorp.armeria.common.RpcResponse;
import com.linecorp.armeria.common.logging.RequestLog;
import com.linecorp.armeria.common.logging.RequestLogAvailability;
import com.linecorp.armeria.common.metric.MeterIdPrefix;
import com.linecorp.armeria.common.metric.MeterIdPrefixFunction;
import com.linecorp.armeria.common.metric.MoreMeters;
import com.linecorp.armeria.internal.metric.MicrometerUtil;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import io.netty.util.AttributeKey;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;

public final class RequestMetricSupport {
    private static final AttributeKey<Boolean> ATTR_REQUEST_METRICS_SET = AttributeKey.valueOf(Boolean.class, (String)"REQUEST_METRICS_SET");

    public static void setup(RequestContext ctx, MeterIdPrefixFunction meterIdPrefixFunction) {
        if (ctx.hasAttr(ATTR_REQUEST_METRICS_SET)) {
            return;
        }
        ctx.attr(ATTR_REQUEST_METRICS_SET).set((Object)true);
        ctx.log().addListener(log -> RequestMetricSupport.onRequest(log, meterIdPrefixFunction), RequestLogAvailability.REQUEST_HEADERS, RequestLogAvailability.REQUEST_CONTENT);
    }

    private static void onRequest(RequestLog log, MeterIdPrefixFunction meterIdPrefixFunction) {
        RequestContext ctx = log.context();
        MeterRegistry registry = ctx.meterRegistry();
        MeterIdPrefix activeRequestsId = meterIdPrefixFunction.activeRequestPrefix(registry, log).append("activeRequests");
        ActiveRequestMetrics activeRequestMetrics = MicrometerUtil.register(registry, activeRequestsId, ActiveRequestMetrics.class, (reg, prefix) -> (ActiveRequestMetrics)reg.gauge(prefix.name(), prefix.tags(), (Object)new ActiveRequestMetrics(), LongAdder::doubleValue));
        activeRequestMetrics.increment();
        ctx.log().addListener(requestLog -> RequestMetricSupport.onResponse(requestLog, meterIdPrefixFunction, activeRequestMetrics), RequestLogAvailability.COMPLETE);
    }

    private static void onResponse(RequestLog log, MeterIdPrefixFunction meterIdPrefixFunction, ActiveRequestMetrics activeRequestMetrics) {
        RequestContext ctx = log.context();
        MeterRegistry registry = ctx.meterRegistry();
        MeterIdPrefix idPrefix = meterIdPrefixFunction.apply(registry, log);
        RequestMetrics metrics = MicrometerUtil.register(registry, idPrefix, RequestMetrics.class, DefaultRequestMetrics::new);
        if (log.requestCause() != null) {
            metrics.failure().increment();
            return;
        }
        metrics.requestDuration().record(log.requestDurationNanos(), TimeUnit.NANOSECONDS);
        metrics.requestLength().record((double)log.requestLength());
        metrics.responseDuration().record(log.responseDurationNanos(), TimeUnit.NANOSECONDS);
        metrics.responseLength().record((double)log.responseLength());
        metrics.totalDuration().record(log.totalDurationNanos(), TimeUnit.NANOSECONDS);
        if (RequestMetricSupport.isSuccess(log)) {
            metrics.success().increment();
        } else {
            metrics.failure().increment();
        }
        activeRequestMetrics.decrement();
    }

    private static boolean isSuccess(RequestLog log) {
        if (log.responseCause() != null) {
            return false;
        }
        int statusCode = log.statusCode();
        if (statusCode < 100 || statusCode >= 400) {
            return false;
        }
        Object responseContent = log.responseContent();
        if (responseContent instanceof RpcResponse) {
            return !((RpcResponse)responseContent).isCompletedExceptionally();
        }
        return true;
    }

    private RequestMetricSupport() {
    }

    private static final class DefaultRequestMetrics
    implements RequestMetrics {
        private final Counter success;
        private final Counter failure;
        private final Timer requestDuration;
        private final DistributionSummary requestLength;
        private final Timer responseDuration;
        private final DistributionSummary responseLength;
        private final Timer totalDuration;

        DefaultRequestMetrics(MeterRegistry parent, MeterIdPrefix idPrefix) {
            String requests = idPrefix.name("requests");
            this.success = parent.counter(requests, idPrefix.tags("result", "success"));
            this.failure = parent.counter(requests, idPrefix.tags("result", "failure"));
            this.requestDuration = MoreMeters.newTimer(parent, idPrefix.name("requestDuration"), idPrefix.tags());
            this.requestLength = MoreMeters.newDistributionSummary(parent, idPrefix.name("requestLength"), idPrefix.tags());
            this.responseDuration = MoreMeters.newTimer(parent, idPrefix.name("responseDuration"), idPrefix.tags());
            this.responseLength = MoreMeters.newDistributionSummary(parent, idPrefix.name("responseLength"), idPrefix.tags());
            this.totalDuration = MoreMeters.newTimer(parent, idPrefix.name("totalDuration"), idPrefix.tags());
        }

        @Override
        public Counter success() {
            return this.success;
        }

        @Override
        public Counter failure() {
            return this.failure;
        }

        @Override
        public Timer requestDuration() {
            return this.requestDuration;
        }

        @Override
        public DistributionSummary requestLength() {
            return this.requestLength;
        }

        @Override
        public Timer responseDuration() {
            return this.responseDuration;
        }

        @Override
        public DistributionSummary responseLength() {
            return this.responseLength;
        }

        @Override
        public Timer totalDuration() {
            return this.totalDuration;
        }
    }

    private static final class ActiveRequestMetrics
    extends LongAdder {
        private ActiveRequestMetrics() {
        }
    }

    private static interface RequestMetrics {
        public Counter success();

        public Counter failure();

        public Timer requestDuration();

        public DistributionSummary requestLength();

        public Timer responseDuration();

        public DistributionSummary responseLength();

        public Timer totalDuration();
    }
}

