/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.shaded.bouncycastle.asn1;

import com.linecorp.armeria.internal.shaded.bouncycastle.asn1.ASN1OutputStream;
import com.linecorp.armeria.internal.shaded.bouncycastle.asn1.ASN1Primitive;
import com.linecorp.armeria.internal.shaded.bouncycastle.util.Arrays;
import java.io.IOException;

public class ASN1Boolean
extends ASN1Primitive {
    private static final byte[] TRUE_VALUE = new byte[]{-1};
    private static final byte[] FALSE_VALUE = new byte[]{0};
    private final byte[] value;
    public static final ASN1Boolean FALSE = new ASN1Boolean(false);
    public static final ASN1Boolean TRUE = new ASN1Boolean(true);

    ASN1Boolean(byte[] byArray) {
        if (byArray.length != 1) {
            throw new IllegalArgumentException("byte value should have 1 byte in it");
        }
        this.value = byArray[0] == 0 ? FALSE_VALUE : ((byArray[0] & 0xFF) == 255 ? TRUE_VALUE : Arrays.clone(byArray));
    }

    public ASN1Boolean(boolean bl) {
        this.value = bl ? TRUE_VALUE : FALSE_VALUE;
    }

    boolean isConstructed() {
        return false;
    }

    int encodedLength() {
        return 3;
    }

    void encode(ASN1OutputStream aSN1OutputStream) throws IOException {
        aSN1OutputStream.writeEncoded(1, this.value);
    }

    protected boolean asn1Equals(ASN1Primitive aSN1Primitive) {
        if (aSN1Primitive instanceof ASN1Boolean) {
            return this.value[0] == ((ASN1Boolean)aSN1Primitive).value[0];
        }
        return false;
    }

    public int hashCode() {
        return this.value[0];
    }

    public String toString() {
        return this.value[0] != 0 ? "TRUE" : "FALSE";
    }

    static ASN1Boolean fromOctetString(byte[] byArray) {
        if (byArray.length != 1) {
            throw new IllegalArgumentException("BOOLEAN value should have 1 byte in it");
        }
        if (byArray[0] == 0) {
            return FALSE;
        }
        if ((byArray[0] & 0xFF) == 255) {
            return TRUE;
        }
        return new ASN1Boolean(byArray);
    }
}

