/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.shaded.bouncycastle.asn1;

import com.linecorp.armeria.internal.shaded.bouncycastle.asn1.ASN1OutputStream;
import com.linecorp.armeria.internal.shaded.bouncycastle.asn1.ASN1Primitive;
import com.linecorp.armeria.internal.shaded.bouncycastle.asn1.DERGeneralizedTime;
import com.linecorp.armeria.internal.shaded.bouncycastle.asn1.StreamUtil;
import com.linecorp.armeria.internal.shaded.bouncycastle.util.Arrays;
import java.io.IOException;

public class ASN1GeneralizedTime
extends ASN1Primitive {
    protected byte[] time;

    ASN1GeneralizedTime(byte[] byArray) {
        this.time = byArray;
    }

    protected boolean hasFractionalSeconds() {
        for (int i = 0; i != this.time.length; ++i) {
            if (this.time[i] != 46 || i != 14) continue;
            return true;
        }
        return false;
    }

    protected boolean hasSeconds() {
        return this.isDigit(12) && this.isDigit(13);
    }

    protected boolean hasMinutes() {
        return this.isDigit(10) && this.isDigit(11);
    }

    private boolean isDigit(int n) {
        return this.time.length > n && this.time[n] >= 48 && this.time[n] <= 57;
    }

    boolean isConstructed() {
        return false;
    }

    int encodedLength() {
        int n = this.time.length;
        return 1 + StreamUtil.calculateBodyLength(n) + n;
    }

    void encode(ASN1OutputStream aSN1OutputStream) throws IOException {
        aSN1OutputStream.writeEncoded(24, this.time);
    }

    ASN1Primitive toDERObject() {
        return new DERGeneralizedTime(this.time);
    }

    boolean asn1Equals(ASN1Primitive aSN1Primitive) {
        if (!(aSN1Primitive instanceof ASN1GeneralizedTime)) {
            return false;
        }
        return Arrays.areEqual(this.time, ((ASN1GeneralizedTime)aSN1Primitive).time);
    }

    public int hashCode() {
        return Arrays.hashCode(this.time);
    }
}

