/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.shaded.bouncycastle.asn1;

import com.linecorp.armeria.internal.shaded.bouncycastle.asn1.ASN1OutputStream;
import com.linecorp.armeria.internal.shaded.bouncycastle.asn1.ASN1Primitive;
import com.linecorp.armeria.internal.shaded.bouncycastle.asn1.StreamUtil;
import com.linecorp.armeria.internal.shaded.bouncycastle.util.Arrays;
import com.linecorp.armeria.internal.shaded.bouncycastle.util.Strings;
import java.io.IOException;

public class ASN1UTCTime
extends ASN1Primitive {
    private byte[] time;

    ASN1UTCTime(byte[] byArray) {
        this.time = byArray;
    }

    boolean isConstructed() {
        return false;
    }

    int encodedLength() {
        int n = this.time.length;
        return 1 + StreamUtil.calculateBodyLength(n) + n;
    }

    void encode(ASN1OutputStream aSN1OutputStream) throws IOException {
        aSN1OutputStream.write(23);
        int n = this.time.length;
        aSN1OutputStream.writeLength(n);
        for (int i = 0; i != n; ++i) {
            aSN1OutputStream.write(this.time[i]);
        }
    }

    boolean asn1Equals(ASN1Primitive aSN1Primitive) {
        if (!(aSN1Primitive instanceof ASN1UTCTime)) {
            return false;
        }
        return Arrays.areEqual(this.time, ((ASN1UTCTime)aSN1Primitive).time);
    }

    public int hashCode() {
        return Arrays.hashCode(this.time);
    }

    public String toString() {
        return Strings.fromByteArray(this.time);
    }
}

