/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.shaded.bouncycastle.asn1;

import com.linecorp.armeria.internal.shaded.bouncycastle.asn1.ASN1BitString;
import com.linecorp.armeria.internal.shaded.bouncycastle.asn1.ASN1Encodable;
import com.linecorp.armeria.internal.shaded.bouncycastle.asn1.ASN1OutputStream;
import com.linecorp.armeria.internal.shaded.bouncycastle.asn1.DLBitString;
import com.linecorp.armeria.internal.shaded.bouncycastle.asn1.StreamUtil;
import java.io.IOException;

public class DERBitString
extends ASN1BitString {
    public static DERBitString getInstance(Object object) {
        if (object == null || object instanceof DERBitString) {
            return (DERBitString)object;
        }
        if (object instanceof DLBitString) {
            return new DERBitString(((DLBitString)object).data, ((DLBitString)object).padBits);
        }
        if (object instanceof byte[]) {
            try {
                return (DERBitString)DERBitString.fromByteArray((byte[])object);
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("encoding error in getInstance: " + exception.toString());
            }
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + object.getClass().getName());
    }

    public DERBitString(byte[] byArray, int n) {
        super(byArray, n);
    }

    public DERBitString(byte[] byArray) {
        this(byArray, 0);
    }

    public DERBitString(ASN1Encodable aSN1Encodable) throws IOException {
        super(aSN1Encodable.toASN1Primitive().getEncoded("DER"), 0);
    }

    boolean isConstructed() {
        return false;
    }

    int encodedLength() {
        return 1 + StreamUtil.calculateBodyLength(this.data.length + 1) + this.data.length + 1;
    }

    void encode(ASN1OutputStream aSN1OutputStream) throws IOException {
        byte[] byArray = DERBitString.derForm(this.data, this.padBits);
        byte[] byArray2 = new byte[byArray.length + 1];
        byArray2[0] = (byte)this.getPadBits();
        System.arraycopy(byArray, 0, byArray2, 1, byArray2.length - 1);
        aSN1OutputStream.writeEncoded(3, byArray2);
    }
}

