/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.shaded.bouncycastle.jcajce.provider.asymmetric.ec;

import com.linecorp.armeria.internal.shaded.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.linecorp.armeria.internal.shaded.bouncycastle.asn1.DERNull;
import com.linecorp.armeria.internal.shaded.bouncycastle.asn1.x9.X962Parameters;
import com.linecorp.armeria.internal.shaded.bouncycastle.asn1.x9.X9ECParameters;
import com.linecorp.armeria.internal.shaded.bouncycastle.jcajce.provider.asymmetric.util.EC5Util;
import com.linecorp.armeria.internal.shaded.bouncycastle.jcajce.provider.asymmetric.util.ECUtil;
import com.linecorp.armeria.internal.shaded.bouncycastle.jce.spec.ECNamedCurveSpec;
import com.linecorp.armeria.internal.shaded.bouncycastle.math.ec.ECCurve;
import java.math.BigInteger;
import java.security.spec.ECParameterSpec;

class ECUtils {
    static X962Parameters getDomainParametersFromName(ECParameterSpec eCParameterSpec, boolean bl) {
        X962Parameters x962Parameters;
        if (eCParameterSpec instanceof ECNamedCurveSpec) {
            ASN1ObjectIdentifier aSN1ObjectIdentifier = ECUtil.getNamedCurveOid(((ECNamedCurveSpec)eCParameterSpec).getName());
            if (aSN1ObjectIdentifier == null) {
                aSN1ObjectIdentifier = new ASN1ObjectIdentifier(((ECNamedCurveSpec)eCParameterSpec).getName());
            }
            x962Parameters = new X962Parameters(aSN1ObjectIdentifier);
        } else if (eCParameterSpec == null) {
            x962Parameters = new X962Parameters(DERNull.INSTANCE);
        } else {
            ECCurve eCCurve = EC5Util.convertCurve(eCParameterSpec.getCurve());
            X9ECParameters x9ECParameters = new X9ECParameters(eCCurve, EC5Util.convertPoint(eCCurve, eCParameterSpec.getGenerator(), bl), eCParameterSpec.getOrder(), BigInteger.valueOf(eCParameterSpec.getCofactor()), eCParameterSpec.getCurve().getSeed());
            x962Parameters = new X962Parameters(x9ECParameters);
        }
        return x962Parameters;
    }
}

