/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.shaded.bouncycastle.math.ec.custom.sec;

import com.linecorp.armeria.internal.shaded.bouncycastle.math.ec.ECCurve;
import com.linecorp.armeria.internal.shaded.bouncycastle.math.ec.ECFieldElement;
import com.linecorp.armeria.internal.shaded.bouncycastle.math.ec.ECPoint;
import com.linecorp.armeria.internal.shaded.bouncycastle.math.ec.custom.sec.SecT193FieldElement;
import com.linecorp.armeria.internal.shaded.bouncycastle.math.ec.custom.sec.SecT193R2Point;
import com.linecorp.armeria.internal.shaded.bouncycastle.util.encoders.Hex;
import java.math.BigInteger;

public class SecT193R2Curve
extends ECCurve.AbstractF2m {
    protected SecT193R2Point infinity = new SecT193R2Point(this, null, null);

    public SecT193R2Curve() {
        super(193, 15, 0, 0);
        this.a = this.fromBigInteger(new BigInteger(1, Hex.decode("0163F35A5137C2CE3EA6ED8667190B0BC43ECD69977702709B")));
        this.b = this.fromBigInteger(new BigInteger(1, Hex.decode("00C9BB9E8927D4D64C377E2AB2856A5B16E3EFB7F61D4316AE")));
        this.order = new BigInteger(1, Hex.decode("010000000000000000000000015AAB561B005413CCD4EE99D5"));
        this.cofactor = BigInteger.valueOf(2L);
        this.coord = 6;
    }

    protected ECCurve cloneCurve() {
        return new SecT193R2Curve();
    }

    public boolean supportsCoordinateSystem(int n) {
        switch (n) {
            case 6: {
                return true;
            }
        }
        return false;
    }

    public int getFieldSize() {
        return 193;
    }

    public ECFieldElement fromBigInteger(BigInteger bigInteger) {
        return new SecT193FieldElement(bigInteger);
    }

    protected ECPoint createRawPoint(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2, boolean bl) {
        return new SecT193R2Point((ECCurve)this, eCFieldElement, eCFieldElement2, bl);
    }

    protected ECPoint createRawPoint(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2, ECFieldElement[] eCFieldElementArray, boolean bl) {
        return new SecT193R2Point(this, eCFieldElement, eCFieldElement2, eCFieldElementArray, bl);
    }

    public ECPoint getInfinity() {
        return this.infinity;
    }

    public boolean isKoblitz() {
        return false;
    }
}

