/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.shaded.bouncycastle.pqc.jcajce.provider.newhope;

import com.linecorp.armeria.internal.shaded.bouncycastle.asn1.ASN1OctetString;
import com.linecorp.armeria.internal.shaded.bouncycastle.asn1.DEROctetString;
import com.linecorp.armeria.internal.shaded.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import com.linecorp.armeria.internal.shaded.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.linecorp.armeria.internal.shaded.bouncycastle.pqc.asn1.PQCObjectIdentifiers;
import com.linecorp.armeria.internal.shaded.bouncycastle.pqc.crypto.newhope.NHPrivateKeyParameters;
import com.linecorp.armeria.internal.shaded.bouncycastle.pqc.jcajce.interfaces.NHPrivateKey;
import com.linecorp.armeria.internal.shaded.bouncycastle.util.Arrays;
import com.linecorp.armeria.internal.shaded.bouncycastle.util.Pack;
import java.io.IOException;

public class BCNHPrivateKey
implements NHPrivateKey {
    private final NHPrivateKeyParameters params;

    public BCNHPrivateKey(PrivateKeyInfo privateKeyInfo) throws IOException {
        this.params = new NHPrivateKeyParameters(BCNHPrivateKey.convert(ASN1OctetString.getInstance(privateKeyInfo.parsePrivateKey()).getOctets()));
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof BCNHPrivateKey)) {
            return false;
        }
        BCNHPrivateKey bCNHPrivateKey = (BCNHPrivateKey)object;
        return Arrays.areEqual(this.params.getSecData(), bCNHPrivateKey.params.getSecData());
    }

    public int hashCode() {
        return Arrays.hashCode(this.params.getSecData());
    }

    public final String getAlgorithm() {
        return "NH";
    }

    public byte[] getEncoded() {
        try {
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(PQCObjectIdentifiers.newHope);
            short[] sArray = this.params.getSecData();
            byte[] byArray = new byte[sArray.length * 2];
            for (int i = 0; i != sArray.length; ++i) {
                Pack.shortToLittleEndian(sArray[i], byArray, i * 2);
            }
            PrivateKeyInfo privateKeyInfo = new PrivateKeyInfo(algorithmIdentifier, new DEROctetString(byArray));
            return privateKeyInfo.getEncoded();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public String getFormat() {
        return "PKCS#8";
    }

    private static short[] convert(byte[] byArray) {
        short[] sArray = new short[byArray.length / 2];
        for (int i = 0; i != sArray.length; ++i) {
            sArray[i] = Pack.littleEndianToShort(byArray, i * 2);
        }
        return sArray;
    }
}

