/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.shaded.bouncycastle.pqc.jcajce.provider.newhope;

import com.linecorp.armeria.internal.shaded.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.linecorp.armeria.internal.shaded.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.linecorp.armeria.internal.shaded.bouncycastle.pqc.asn1.PQCObjectIdentifiers;
import com.linecorp.armeria.internal.shaded.bouncycastle.pqc.crypto.newhope.NHPublicKeyParameters;
import com.linecorp.armeria.internal.shaded.bouncycastle.pqc.jcajce.interfaces.NHPublicKey;
import com.linecorp.armeria.internal.shaded.bouncycastle.util.Arrays;
import java.io.IOException;

public class BCNHPublicKey
implements NHPublicKey {
    private final NHPublicKeyParameters params;

    public BCNHPublicKey(SubjectPublicKeyInfo subjectPublicKeyInfo) {
        this.params = new NHPublicKeyParameters(subjectPublicKeyInfo.getPublicKeyData().getBytes());
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof BCNHPublicKey)) {
            return false;
        }
        BCNHPublicKey bCNHPublicKey = (BCNHPublicKey)object;
        return Arrays.areEqual(this.params.getPubData(), bCNHPublicKey.params.getPubData());
    }

    public int hashCode() {
        return Arrays.hashCode(this.params.getPubData());
    }

    public final String getAlgorithm() {
        return "NH";
    }

    public byte[] getEncoded() {
        try {
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(PQCObjectIdentifiers.newHope);
            SubjectPublicKeyInfo subjectPublicKeyInfo = new SubjectPublicKeyInfo(algorithmIdentifier, this.params.getPubData());
            return subjectPublicKeyInfo.getEncoded();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public String getFormat() {
        return "X.509";
    }
}

