/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.shaded.caffeine.cache;

import com.linecorp.armeria.internal.shaded.caffeine.base.UnsafeAccess;
import com.linecorp.armeria.internal.shaded.caffeine.cache.Node;
import com.linecorp.armeria.internal.shaded.caffeine.cache.NodeFactory;
import com.linecorp.armeria.internal.shaded.caffeine.cache.References;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;

class FW<K, V>
extends Node<K, V>
implements NodeFactory<K, V> {
    protected static final long KEY_OFFSET = UnsafeAccess.objectFieldOffset(FW.class, "key");
    protected static final long VALUE_OFFSET = UnsafeAccess.objectFieldOffset(FW.class, "value");
    volatile References.WeakKeyReference<K> key;
    volatile References.WeakValueReference<V> value;

    FW() {
    }

    FW(K k, ReferenceQueue<K> referenceQueue, V v, ReferenceQueue<V> referenceQueue2, int n, long l) {
        this(new References.WeakKeyReference<K>(k, referenceQueue), v, referenceQueue2, n, l);
    }

    FW(Object object, V v, ReferenceQueue<V> referenceQueue, int n, long l) {
        UnsafeAccess.UNSAFE.putObject(this, KEY_OFFSET, object);
        UnsafeAccess.UNSAFE.putObject(this, VALUE_OFFSET, new References.WeakValueReference<V>(object, v, referenceQueue));
    }

    @Override
    public final K getKey() {
        return (K)((Reference)UnsafeAccess.UNSAFE.getObject(this, KEY_OFFSET)).get();
    }

    @Override
    public final Object getKeyReference() {
        return UnsafeAccess.UNSAFE.getObject(this, KEY_OFFSET);
    }

    @Override
    public final V getValue() {
        return (V)((Reference)UnsafeAccess.UNSAFE.getObject(this, VALUE_OFFSET)).get();
    }

    @Override
    public final Object getValueReference() {
        return UnsafeAccess.UNSAFE.getObject(this, VALUE_OFFSET);
    }

    @Override
    public final void setValue(V v, ReferenceQueue<V> referenceQueue) {
        ((Reference)this.getValueReference()).clear();
        UnsafeAccess.UNSAFE.putObject(this, VALUE_OFFSET, new References.WeakValueReference<V>(this.getKeyReference(), v, referenceQueue));
    }

    @Override
    public final boolean containsValue(Object object) {
        return this.getValue() == object;
    }

    @Override
    public Node<K, V> newNode(K k, ReferenceQueue<K> referenceQueue, V v, ReferenceQueue<V> referenceQueue2, int n, long l) {
        return new FW<K, V>(k, referenceQueue, v, referenceQueue2, n, l);
    }

    @Override
    public Node<K, V> newNode(Object object, V v, ReferenceQueue<V> referenceQueue, int n, long l) {
        return new FW<K, V>(object, v, referenceQueue, n, l);
    }

    @Override
    public Object newLookupKey(Object object) {
        return new References.LookupKeyReference<Object>(object);
    }

    @Override
    public Object newReferenceKey(K k, ReferenceQueue<K> referenceQueue) {
        return new References.WeakKeyReference<K>(k, referenceQueue);
    }

    @Override
    public boolean weakValues() {
        return true;
    }

    @Override
    public final boolean isAlive() {
        Object object = this.getKeyReference();
        return object != RETIRED_WEAK_KEY && object != DEAD_WEAK_KEY;
    }

    @Override
    public final boolean isRetired() {
        return this.getKeyReference() == RETIRED_WEAK_KEY;
    }

    @Override
    public final void retire() {
        ((Reference)this.getKeyReference()).clear();
        ((Reference)this.getValueReference()).clear();
        UnsafeAccess.UNSAFE.putObject(this, KEY_OFFSET, RETIRED_WEAK_KEY);
    }

    @Override
    public final boolean isDead() {
        return this.getKeyReference() == DEAD_WEAK_KEY;
    }

    @Override
    public final void die() {
        ((Reference)this.getKeyReference()).clear();
        ((Reference)this.getValueReference()).clear();
        UnsafeAccess.UNSAFE.putObject(this, KEY_OFFSET, DEAD_WEAK_KEY);
    }
}

