/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.shaded.caffeine.cache;

import com.linecorp.armeria.internal.shaded.caffeine.cache.Async;
import com.linecorp.armeria.internal.shaded.caffeine.cache.AsyncCacheLoader;
import com.linecorp.armeria.internal.shaded.caffeine.cache.AsyncLoadingCache;
import com.linecorp.armeria.internal.shaded.caffeine.cache.CacheLoader;
import com.linecorp.armeria.internal.shaded.caffeine.cache.Caffeine;
import com.linecorp.armeria.internal.shaded.caffeine.cache.LoadingCache;
import com.linecorp.armeria.internal.shaded.caffeine.cache.LocalCache;
import com.linecorp.armeria.internal.shaded.caffeine.cache.Policy;
import com.linecorp.armeria.internal.shaded.caffeine.cache.RemovalCause;
import com.linecorp.armeria.internal.shaded.caffeine.cache.WriteThroughEntry;
import com.linecorp.armeria.internal.shaded.caffeine.cache.stats.CacheStats;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

abstract class LocalAsyncLoadingCache<C extends LocalCache<K, CompletableFuture<V>>, K, V>
implements AsyncLoadingCache<K, V> {
    static final Logger logger = Logger.getLogger(LocalAsyncLoadingCache.class.getName());
    final C cache;
    final boolean canBulkLoad;
    final AsyncCacheLoader<K, V> loader;
    @Nullable
    LoadingCacheView localCacheView;

    LocalAsyncLoadingCache(C cache, AsyncCacheLoader<? super K, V> loader) {
        this.loader = loader;
        this.canBulkLoad = LocalAsyncLoadingCache.canBulkLoad(loader);
        this.cache = cache;
    }

    protected abstract Policy<K, V> policy();

    private static boolean canBulkLoad(AsyncCacheLoader<?, ?> loader) {
        try {
            Class<AsyncCacheLoader> defaultLoaderClass = AsyncCacheLoader.class;
            if (loader instanceof CacheLoader) {
                Method defaultLoadAll;
                defaultLoaderClass = CacheLoader.class;
                Method classLoadAll = loader.getClass().getMethod("loadAll", Iterable.class);
                if (!classLoadAll.equals(defaultLoadAll = CacheLoader.class.getMethod("loadAll", Iterable.class))) {
                    return true;
                }
            }
            Method classAsyncLoadAll = loader.getClass().getMethod("asyncLoadAll", Iterable.class, Executor.class);
            Method defaultAsyncLoadAll = defaultLoaderClass.getMethod("asyncLoadAll", Iterable.class, Executor.class);
            return !classAsyncLoadAll.equals(defaultAsyncLoadAll);
        }
        catch (NoSuchMethodException | SecurityException e) {
            logger.log(Level.WARNING, "Cannot determine if CacheLoader can bulk load", e);
            return false;
        }
    }

    @Override
    @Nullable
    public CompletableFuture<V> getIfPresent(@Nonnull Object key) {
        return (CompletableFuture)this.cache.getIfPresent(key, true);
    }

    @Override
    public CompletableFuture<V> get(@Nonnull K key, @Nonnull Function<? super K, ? extends V> mappingFunction) {
        Objects.requireNonNull(mappingFunction);
        return this.get(key, (? super K k1, Executor executor) -> CompletableFuture.supplyAsync(() -> mappingFunction.apply((Object)key), executor));
    }

    @Override
    public CompletableFuture<V> get(K key, BiFunction<? super K, Executor, CompletableFuture<V>> mappingFunction) {
        return this.get(key, mappingFunction, true);
    }

    CompletableFuture<V> get(K key, BiFunction<? super K, Executor, CompletableFuture<V>> mappingFunction, boolean recordStats) {
        long startTime = this.cache.statsTicker().read();
        CompletableFuture[] result = new CompletableFuture[1];
        CompletableFuture future = this.cache.computeIfAbsent(key, k -> {
            result[0] = (CompletableFuture)mappingFunction.apply((K)key, this.cache.executor());
            return Objects.requireNonNull(result[0]);
        }, recordStats, false);
        if (result[0] != null) {
            AtomicBoolean completed = new AtomicBoolean();
            result[0].whenComplete((value, error) -> {
                if (!completed.compareAndSet(false, true)) {
                    return;
                }
                long loadTime = this.cache.statsTicker().read() - startTime;
                if (value == null) {
                    if (error != null) {
                        logger.log(Level.WARNING, "Exception thrown during asynchronous load", (Throwable)error);
                    }
                    this.cache.statsCounter().recordLoadFailure(loadTime);
                    this.cache.remove(key, result[0]);
                } else {
                    this.cache.replace(key, (CompletableFuture)result[0], (CompletableFuture)result[0]);
                    this.cache.statsCounter().recordLoadSuccess(loadTime);
                }
            });
        }
        return future;
    }

    @Override
    public CompletableFuture<V> get(K key) {
        CompletableFuture<V> future = this.get(key, this.loader::asyncLoad);
        return Objects.requireNonNull(future);
    }

    @Override
    public CompletableFuture<Map<K, V>> getAll(Iterable<? extends K> keys) {
        if (this.canBulkLoad) {
            return this.getAllBulk(keys);
        }
        LinkedHashMap<Object, CompletableFuture> result = new LinkedHashMap<Object, CompletableFuture>();
        Function<Object, CompletableFuture> mappingFunction = this::get;
        for (K key : keys) {
            CompletableFuture future = result.computeIfAbsent(key, mappingFunction);
            Objects.requireNonNull(future);
        }
        return this.composeResult(result);
    }

    private CompletableFuture<Map<K, V>> getAllBulk(Iterable<? extends K> keys) {
        LinkedHashMap futures = new LinkedHashMap();
        HashMap proxies = new HashMap();
        for (K key : keys) {
            CompletableFuture proxy;
            if (futures.containsKey(key)) continue;
            CompletableFuture future = (CompletableFuture)this.cache.getIfPresent(key, false);
            if (future == null && (future = this.cache.putIfAbsent(key, proxy = new CompletableFuture())) == null) {
                future = proxy;
                proxies.put(key, proxy);
            }
            futures.put(key, future);
        }
        this.cache.statsCounter().recordMisses(proxies.size());
        this.cache.statsCounter().recordHits(futures.size() - proxies.size());
        if (proxies.isEmpty()) {
            return this.composeResult(futures);
        }
        AsyncBulkCompleter completer = new AsyncBulkCompleter(proxies);
        try {
            this.loader.asyncLoadAll(proxies.keySet(), this.cache.executor()).whenComplete((BiConsumer)completer);
            return this.composeResult(futures);
        }
        catch (Throwable t) {
            completer.accept(null, t);
            throw t;
        }
    }

    private CompletableFuture<Map<K, V>> composeResult(Map<K, CompletableFuture<V>> futures) {
        if (futures.isEmpty()) {
            return CompletableFuture.completedFuture(Collections.emptyMap());
        }
        CompletableFuture[] array = futures.values().toArray(new CompletableFuture[0]);
        return CompletableFuture.allOf(array).thenApply(ignored -> {
            LinkedHashMap result = new LinkedHashMap(futures.size());
            futures.forEach((key, future) -> {
                Object value = future.getNow(null);
                if (value != null) {
                    result.put(key, value);
                }
            });
            return Collections.unmodifiableMap(result);
        });
    }

    @Override
    public void put(K key, CompletableFuture<V> valueFuture) {
        if (valueFuture.isCompletedExceptionally() || valueFuture.isDone() && valueFuture.join() == null) {
            this.cache.statsCounter().recordLoadFailure(0L);
            this.cache.remove(key);
            return;
        }
        AtomicBoolean completed = new AtomicBoolean();
        long startTime = this.cache.statsTicker().read();
        this.cache.put(key, valueFuture);
        valueFuture.whenComplete((value, error) -> {
            if (!completed.compareAndSet(false, true)) {
                return;
            }
            long loadTime = this.cache.statsTicker().read() - startTime;
            if (value == null) {
                if (error != null) {
                    logger.log(Level.WARNING, "Exception thrown during asynchronous load", (Throwable)error);
                }
                this.cache.remove(key, valueFuture);
                this.cache.statsCounter().recordLoadFailure(loadTime);
            } else {
                this.cache.replace(key, (CompletableFuture)valueFuture, (CompletableFuture)valueFuture);
                this.cache.statsCounter().recordLoadSuccess(loadTime);
            }
        });
    }

    @Override
    public LoadingCache<K, V> synchronous() {
        return this.localCacheView == null ? (this.localCacheView = new LoadingCacheView()) : this.localCacheView;
    }

    static final class AsMapView<K, V>
    extends AbstractMap<K, V>
    implements ConcurrentMap<K, V> {
        final LocalCache<K, CompletableFuture<V>> delegate;
        @Nullable
        Collection<V> values;
        @Nullable
        Set<Map.Entry<K, V>> entries;

        AsMapView(LocalCache<K, CompletableFuture<V>> delegate) {
            this.delegate = delegate;
        }

        @Override
        public boolean isEmpty() {
            return this.delegate.isEmpty();
        }

        @Override
        public int size() {
            return this.delegate.size();
        }

        @Override
        public void clear() {
            this.delegate.clear();
        }

        @Override
        public boolean containsKey(Object key) {
            return this.delegate.containsKey(key);
        }

        @Override
        public boolean containsValue(Object value) {
            Objects.requireNonNull(value);
            for (CompletableFuture valueFuture : this.delegate.values()) {
                if (!value.equals(Async.getIfReady(valueFuture))) continue;
                return true;
            }
            return false;
        }

        @Override
        @Nullable
        public V get(Object key) {
            return Async.getIfReady((CompletableFuture)this.delegate.get(key));
        }

        @Override
        @Nullable
        public V putIfAbsent(K key, V value) {
            Objects.requireNonNull(value);
            CompletableFuture<V> valueFuture = this.delegate.putIfAbsent(key, CompletableFuture.completedFuture(value));
            return Async.getWhenSuccessful(valueFuture);
        }

        @Override
        @Nullable
        public V put(K key, V value) {
            Objects.requireNonNull(value);
            CompletableFuture<V> oldValueFuture = this.delegate.put(key, CompletableFuture.completedFuture(value));
            return Async.getWhenSuccessful(oldValueFuture);
        }

        @Override
        @Nullable
        public V remove(Object key) {
            CompletableFuture oldValueFuture = (CompletableFuture)this.delegate.remove(key);
            return Async.getWhenSuccessful(oldValueFuture);
        }

        @Override
        public boolean remove(Object key, Object value) {
            Objects.requireNonNull(key);
            if (value == null) {
                return false;
            }
            Object castedKey = key;
            boolean[] removed = new boolean[]{false};
            boolean[] done = new boolean[]{false};
            do {
                CompletableFuture future = (CompletableFuture)this.delegate.get(key);
                Object oldValue = Async.getWhenSuccessful(future);
                if (future != null && !value.equals(oldValue)) {
                    return false;
                }
                this.delegate.compute(castedKey, (k, oldValueFuture) -> {
                    if (future != oldValueFuture) {
                        return oldValueFuture;
                    }
                    done[0] = true;
                    removed[0] = value.equals(oldValue);
                    return removed[0] ? null : oldValueFuture;
                }, false, false);
            } while (!done[0]);
            return removed[0];
        }

        @Override
        @Nullable
        public V replace(K key, V value) {
            Objects.requireNonNull(value);
            CompletableFuture<V> oldValueFuture = this.delegate.replace(key, CompletableFuture.completedFuture(value));
            return Async.getWhenSuccessful(oldValueFuture);
        }

        @Override
        public boolean replace(K key, V oldValue, V newValue) {
            Objects.requireNonNull(oldValue);
            Objects.requireNonNull(newValue);
            CompletableFuture oldValueFuture = (CompletableFuture)this.delegate.get(key);
            if (oldValueFuture != null && !oldValue.equals(Async.getWhenSuccessful(oldValueFuture))) {
                return false;
            }
            K castedKey = key;
            boolean[] replaced = new boolean[]{false};
            this.delegate.compute(castedKey, (k, value) -> {
                replaced[0] = oldValue.equals(Async.getWhenSuccessful(value));
                return replaced[0] ? CompletableFuture.completedFuture(newValue) : value;
            }, false, false);
            return replaced[0];
        }

        @Override
        @Nullable
        public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
            Objects.requireNonNull(mappingFunction);
            CompletableFuture valueFuture = this.delegate.computeIfAbsent(key, k -> {
                Object newValue = mappingFunction.apply((Object)key);
                return newValue == null ? null : CompletableFuture.completedFuture(newValue);
            });
            return Async.getWhenSuccessful(valueFuture);
        }

        @Override
        @Nullable
        public V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
            CompletableFuture valueFuture;
            Objects.requireNonNull(remappingFunction);
            boolean[] computed = new boolean[]{false};
            do {
                CompletableFuture future;
                Object oldValue;
                if ((oldValue = Async.getWhenSuccessful(future = (CompletableFuture)this.delegate.get(key))) == null) {
                    return null;
                }
                valueFuture = this.delegate.computeIfPresent(key, (k, oldValueFuture) -> {
                    if (future != oldValueFuture) {
                        return oldValueFuture;
                    }
                    computed[0] = true;
                    Object newValue = remappingFunction.apply((Object)key, (Object)oldValue);
                    return newValue == null ? null : CompletableFuture.completedFuture(newValue);
                });
            } while (!computed[0] && valueFuture != null);
            return Async.getWhenSuccessful(valueFuture);
        }

        @Override
        @Nullable
        public V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
            CompletableFuture valueFuture;
            Objects.requireNonNull(remappingFunction);
            boolean[] computed = new boolean[]{false};
            do {
                CompletableFuture future = (CompletableFuture)this.delegate.get(key);
                Object oldValue = Async.getWhenSuccessful(future);
                valueFuture = this.delegate.compute(key, (k, oldValueFuture) -> {
                    if (future != oldValueFuture) {
                        return oldValueFuture;
                    }
                    computed[0] = true;
                    long startTime = this.delegate.statsTicker().read();
                    Object newValue = remappingFunction.apply((K)key, (V)oldValue);
                    long loadTime = this.delegate.statsTicker().read() - startTime;
                    if (newValue == null) {
                        this.delegate.statsCounter().recordLoadFailure(loadTime);
                        return null;
                    }
                    this.delegate.statsCounter().recordLoadSuccess(loadTime);
                    return CompletableFuture.completedFuture(newValue);
                }, false, false);
            } while (!computed[0]);
            return Async.getWhenSuccessful(valueFuture);
        }

        @Override
        @Nullable
        public V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
            CompletableFuture mergedValueFuture;
            Objects.requireNonNull(value);
            Objects.requireNonNull(remappingFunction);
            CompletableFuture<V> newValueFuture = CompletableFuture.completedFuture(value);
            boolean[] merged = new boolean[]{false};
            do {
                CompletableFuture future = (CompletableFuture)this.delegate.get(key);
                Object oldValue = Async.getWhenSuccessful(future);
                mergedValueFuture = this.delegate.merge(key, newValueFuture, (oldValueFuture, valueFuture) -> {
                    if (future != oldValueFuture) {
                        return oldValueFuture;
                    }
                    merged[0] = true;
                    if (oldValue == null) {
                        return valueFuture;
                    }
                    Object mergedValue = remappingFunction.apply((Object)oldValue, (Object)value);
                    if (mergedValue == null) {
                        return null;
                    }
                    if (mergedValue == oldValue) {
                        return oldValueFuture;
                    }
                    if (mergedValue == value) {
                        return valueFuture;
                    }
                    return CompletableFuture.completedFuture(mergedValue);
                });
            } while (!merged[0] && mergedValueFuture != newValueFuture);
            return Async.getWhenSuccessful(mergedValueFuture);
        }

        @Override
        public Set<K> keySet() {
            return this.delegate.keySet();
        }

        @Override
        public Collection<V> values() {
            return this.values == null ? (this.values = new Values()) : this.values;
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return this.entries == null ? (this.entries = new EntrySet()) : this.entries;
        }

        private final class EntrySet
        extends AbstractSet<Map.Entry<K, V>> {
            private EntrySet() {
            }

            @Override
            public boolean isEmpty() {
                return AsMapView.this.isEmpty();
            }

            @Override
            public int size() {
                return AsMapView.this.size();
            }

            @Override
            public boolean contains(Object o) {
                if (!(o instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry entry = (Map.Entry)o;
                Object value = AsMapView.this.get(entry.getKey());
                return value != null && value.equals(entry.getValue());
            }

            @Override
            public boolean remove(Object obj) {
                if (!(obj instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry entry = (Map.Entry)obj;
                return AsMapView.this.remove(entry.getKey(), entry.getValue());
            }

            @Override
            public void clear() {
                AsMapView.this.clear();
            }

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return new Iterator<Map.Entry<K, V>>(){
                    Iterator<Map.Entry<K, CompletableFuture<V>>> iterator;
                    @Nullable
                    Map.Entry<K, V> cursor;
                    @Nullable
                    K removalKey;
                    {
                        this.iterator = AsMapView.this.delegate.entrySet().iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        while (this.cursor == null && this.iterator.hasNext()) {
                            Map.Entry entry = this.iterator.next();
                            Object value = Async.getIfReady(entry.getValue());
                            if (value == null) continue;
                            this.cursor = new WriteThroughEntry(AsMapView.this, entry.getKey(), value);
                        }
                        return this.cursor != null;
                    }

                    @Override
                    public Map.Entry<K, V> next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        Object key = this.cursor.getKey();
                        Map.Entry entry = this.cursor;
                        this.removalKey = key;
                        this.cursor = null;
                        return entry;
                    }

                    @Override
                    public void remove() {
                        Caffeine.requireState(this.removalKey != null);
                        AsMapView.this.delegate.remove(this.removalKey);
                        this.removalKey = null;
                    }
                };
            }
        }

        private final class Values
        extends AbstractCollection<V> {
            private Values() {
            }

            @Override
            public boolean isEmpty() {
                return AsMapView.this.isEmpty();
            }

            @Override
            public int size() {
                return AsMapView.this.size();
            }

            @Override
            public boolean contains(Object o) {
                return AsMapView.this.containsValue(o);
            }

            @Override
            public void clear() {
                AsMapView.this.clear();
            }

            @Override
            public Iterator<V> iterator() {
                return new Iterator<V>(){
                    Iterator<Map.Entry<K, V>> iterator;
                    {
                        this.iterator = AsMapView.this.entrySet().iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.iterator.hasNext();
                    }

                    @Override
                    public V next() {
                        return this.iterator.next().getValue();
                    }

                    @Override
                    public void remove() {
                        this.iterator.remove();
                    }
                };
            }
        }
    }

    final class LoadingCacheView
    implements LoadingCache<K, V>,
    Serializable {
        private static final long serialVersionUID = 1L;
        @Nullable
        transient AsMapView<K, V> asMapView;

        LoadingCacheView() {
        }

        LocalAsyncLoadingCache<C, K, V> getOuter() {
            return LocalAsyncLoadingCache.this;
        }

        @Override
        @Nullable
        public V getIfPresent(Object key) {
            CompletableFuture future = (CompletableFuture)LocalAsyncLoadingCache.this.cache.getIfPresent(key, true);
            return Async.getIfReady(future);
        }

        @Override
        public Map<K, V> getAllPresent(Iterable<?> keys) {
            LinkedHashSet uniqueKeys = new LinkedHashSet();
            for (Object key : keys) {
                uniqueKeys.add(key);
            }
            int misses = 0;
            LinkedHashMap result = new LinkedHashMap();
            for (Object key : uniqueKeys) {
                CompletableFuture future = (CompletableFuture)LocalAsyncLoadingCache.this.cache.get(key);
                Object value = Async.getIfReady(future);
                if (value == null) {
                    ++misses;
                    continue;
                }
                result.put(key, value);
            }
            LocalAsyncLoadingCache.this.cache.statsCounter().recordMisses(misses);
            LocalAsyncLoadingCache.this.cache.statsCounter().recordHits(result.size());
            LinkedHashMap castedResult = result;
            return Collections.unmodifiableMap(castedResult);
        }

        @Override
        public V get(K key, Function<? super K, ? extends V> mappingFunction) {
            Objects.requireNonNull(mappingFunction);
            CompletableFuture future = LocalAsyncLoadingCache.this.get(key, (? super K k, Executor executor) -> CompletableFuture.supplyAsync(() -> mappingFunction.apply((Object)key), executor));
            try {
                return future.get();
            }
            catch (ExecutionException e) {
                if (e.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)e.getCause();
                }
                if (e.getCause() instanceof Error) {
                    throw (Error)e.getCause();
                }
                throw new CompletionException(e.getCause());
            }
            catch (InterruptedException e) {
                throw new CompletionException(e);
            }
        }

        @Override
        public V get(K key) {
            try {
                return LocalAsyncLoadingCache.this.get(key).get();
            }
            catch (ExecutionException e) {
                if (e.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)e.getCause();
                }
                if (e.getCause() instanceof Error) {
                    throw (Error)e.getCause();
                }
                throw new CompletionException(e.getCause());
            }
            catch (InterruptedException e) {
                throw new CompletionException(e);
            }
        }

        @Override
        public Map<K, V> getAll(Iterable<? extends K> keys) {
            try {
                return LocalAsyncLoadingCache.this.getAll(keys).get();
            }
            catch (ExecutionException e) {
                if (e.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)e.getCause();
                }
                if (e.getCause() instanceof Error) {
                    throw (Error)e.getCause();
                }
                throw new CompletionException(e.getCause());
            }
            catch (InterruptedException e) {
                throw new CompletionException(e);
            }
        }

        @Override
        public void put(K key, V value) {
            Objects.requireNonNull(value);
            LocalAsyncLoadingCache.this.cache.put(key, CompletableFuture.completedFuture(value));
        }

        @Override
        public void putAll(Map<? extends K, ? extends V> map) {
            map.forEach(this::put);
        }

        @Override
        public void invalidate(Object key) {
            LocalAsyncLoadingCache.this.cache.remove(key);
        }

        @Override
        public void invalidateAll(Iterable<?> keys) {
            LocalAsyncLoadingCache.this.cache.invalidateAll(keys);
        }

        @Override
        public void invalidateAll() {
            LocalAsyncLoadingCache.this.cache.clear();
        }

        @Override
        public long estimatedSize() {
            return LocalAsyncLoadingCache.this.cache.size();
        }

        @Override
        public CacheStats stats() {
            return LocalAsyncLoadingCache.this.cache.statsCounter().snapshot();
        }

        @Override
        public void cleanUp() {
            LocalAsyncLoadingCache.this.cache.cleanUp();
        }

        @Override
        public void refresh(K key) {
            CompletableFuture oldValueFuture;
            long[] writeTime;
            block5: {
                block4: {
                    Objects.requireNonNull(key);
                    writeTime = new long[1];
                    oldValueFuture = (CompletableFuture)LocalAsyncLoadingCache.this.cache.getIfPresentQuietly(key, writeTime);
                    if (oldValueFuture == null) break block4;
                    if (!oldValueFuture.isDone() || !oldValueFuture.isCompletedExceptionally()) break block5;
                }
                LocalAsyncLoadingCache.this.get(key, LocalAsyncLoadingCache.this.loader::asyncLoad, false);
                return;
            }
            if (!oldValueFuture.isDone()) {
                return;
            }
            oldValueFuture.thenAccept(oldValue -> {
                long now = LocalAsyncLoadingCache.this.cache.statsTicker().read();
                CompletableFuture<Object> refreshFuture = oldValue == null ? LocalAsyncLoadingCache.this.loader.asyncLoad(key, LocalAsyncLoadingCache.this.cache.executor()) : LocalAsyncLoadingCache.this.loader.asyncReload(key, oldValue, LocalAsyncLoadingCache.this.cache.executor());
                refreshFuture.whenComplete((newValue, error) -> {
                    long loadTime = LocalAsyncLoadingCache.this.cache.statsTicker().read() - now;
                    if (error != null) {
                        LocalAsyncLoadingCache.this.cache.statsCounter().recordLoadFailure(loadTime);
                        logger.log(Level.WARNING, "Exception thrown during refresh", (Throwable)error);
                        return;
                    }
                    boolean[] discard = new boolean[1];
                    LocalAsyncLoadingCache.this.cache.compute(key, (k, currentValue) -> {
                        if (currentValue == null) {
                            return newValue == null ? null : refreshFuture;
                        }
                        if (currentValue == oldValueFuture) {
                            long expectedWriteTime = writeTime[0];
                            if (LocalAsyncLoadingCache.this.cache.hasWriteTime()) {
                                LocalAsyncLoadingCache.this.cache.getIfPresentQuietly(key, writeTime);
                            }
                            if (writeTime[0] == expectedWriteTime) {
                                return newValue == null ? null : refreshFuture;
                            }
                        }
                        discard[0] = true;
                        return currentValue;
                    }, false, false);
                    if (discard[0] && LocalAsyncLoadingCache.this.cache.hasRemovalListener()) {
                        LocalAsyncLoadingCache.this.cache.notifyRemoval(key, (CompletableFuture)refreshFuture, RemovalCause.REPLACED);
                    }
                    if (newValue == null) {
                        LocalAsyncLoadingCache.this.cache.statsCounter().recordLoadFailure(loadTime);
                    } else {
                        LocalAsyncLoadingCache.this.cache.statsCounter().recordLoadSuccess(loadTime);
                    }
                });
            });
        }

        @Override
        public Policy<K, V> policy() {
            return this.getOuter().policy();
        }

        @Override
        public ConcurrentMap<K, V> asMap() {
            if (this.asMapView == null) {
                this.asMapView = new AsMapView(LocalAsyncLoadingCache.this.cache);
            }
            return this.asMapView;
        }
    }

    private final class AsyncBulkCompleter
    implements BiConsumer<Map<K, V>, Throwable> {
        private final Map<K, CompletableFuture<V>> proxies;
        private final long startTime;

        AsyncBulkCompleter(Map<K, CompletableFuture<V>> proxies) {
            this.startTime = LocalAsyncLoadingCache.this.cache.statsTicker().read();
            this.proxies = proxies;
        }

        @Override
        public void accept(@Nullable Map<K, V> result, @Nullable Throwable error) {
            long loadTime = LocalAsyncLoadingCache.this.cache.statsTicker().read() - this.startTime;
            if (result == null) {
                if (error == null) {
                    error = new CompletionException("null map", null);
                }
                for (Map.Entry entry : this.proxies.entrySet()) {
                    LocalAsyncLoadingCache.this.cache.remove(entry.getKey(), entry.getValue());
                    entry.getValue().obtrudeException(error);
                }
                LocalAsyncLoadingCache.this.cache.statsCounter().recordLoadFailure(loadTime);
                logger.log(Level.WARNING, "Exception thrown during asynchronous load", error);
            } else {
                this.fillProxies(result);
                this.addNewEntries(result);
                LocalAsyncLoadingCache.this.cache.statsCounter().recordLoadSuccess(result.size());
            }
        }

        private void fillProxies(Map<K, V> result) {
            this.proxies.forEach((key, future) -> {
                Object value = result.get(key);
                future.obtrudeValue(value);
                if (value == null) {
                    LocalAsyncLoadingCache.this.cache.remove(key, future);
                } else {
                    LocalAsyncLoadingCache.this.cache.replace((Object)key, (CompletableFuture)future, (CompletableFuture)future);
                }
            });
        }

        private void addNewEntries(Map<K, V> result) {
            if (this.proxies.size() == result.size()) {
                return;
            }
            result.forEach((key, value) -> {
                if (!this.proxies.containsKey(key)) {
                    LocalAsyncLoadingCache.this.cache.put((Object)key, CompletableFuture.completedFuture(value));
                }
            });
        }
    }
}

