/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.shaded.caffeine.cache;

import com.linecorp.armeria.internal.shaded.caffeine.base.UnsafeAccess;
import com.linecorp.armeria.internal.shaded.caffeine.cache.Node;
import com.linecorp.armeria.internal.shaded.caffeine.cache.PSA;
import java.lang.ref.ReferenceQueue;

class PSAW<K, V>
extends PSA<K, V> {
    protected static final long WRITE_TIME_OFFSET = UnsafeAccess.objectFieldOffset(PSAW.class, "writeTime");
    volatile long writeTime;
    Node<K, V> previousInWriteOrder;
    Node<K, V> nextInWriteOrder;

    PSAW() {
    }

    PSAW(K k, ReferenceQueue<K> referenceQueue, V v, ReferenceQueue<V> referenceQueue2, int n, long l) {
        super(k, referenceQueue, v, referenceQueue2, n, l);
        UnsafeAccess.UNSAFE.putLong(this, WRITE_TIME_OFFSET, l);
    }

    PSAW(Object object, V v, ReferenceQueue<V> referenceQueue, int n, long l) {
        super(object, v, referenceQueue, n, l);
        UnsafeAccess.UNSAFE.putLong(this, WRITE_TIME_OFFSET, l);
    }

    @Override
    public Node<K, V> getPreviousInVariableOrder() {
        return this.previousInWriteOrder;
    }

    @Override
    public void setPreviousInVariableOrder(Node<K, V> node) {
        this.previousInWriteOrder = node;
    }

    @Override
    public Node<K, V> getNextInVariableOrder() {
        return this.nextInWriteOrder;
    }

    @Override
    public void setNextInVariableOrder(Node<K, V> node) {
        this.nextInWriteOrder = node;
    }

    @Override
    public long getVariableTime() {
        return this.writeTime;
    }

    @Override
    public void setVariableTime(long l) {
        this.writeTime = l;
    }

    @Override
    public final long getWriteTime() {
        return UnsafeAccess.UNSAFE.getLong(this, WRITE_TIME_OFFSET);
    }

    @Override
    public final void setWriteTime(long l) {
        UnsafeAccess.UNSAFE.putLong(this, WRITE_TIME_OFFSET, l);
    }

    @Override
    public final Node<K, V> getPreviousInWriteOrder() {
        return this.previousInWriteOrder;
    }

    @Override
    public final void setPreviousInWriteOrder(Node<K, V> node) {
        this.previousInWriteOrder = node;
    }

    @Override
    public final Node<K, V> getNextInWriteOrder() {
        return this.nextInWriteOrder;
    }

    @Override
    public final void setNextInWriteOrder(Node<K, V> node) {
        this.nextInWriteOrder = node;
    }

    @Override
    public Node<K, V> newNode(K k, ReferenceQueue<K> referenceQueue, V v, ReferenceQueue<V> referenceQueue2, int n, long l) {
        return new PSAW<K, V>(k, referenceQueue, v, referenceQueue2, n, l);
    }

    @Override
    public Node<K, V> newNode(Object object, V v, ReferenceQueue<V> referenceQueue, int n, long l) {
        return new PSAW<K, V>(object, v, referenceQueue, n, l);
    }
}

