/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.shaded.fastutil.bytes;

import com.linecorp.armeria.internal.shaded.fastutil.SafeMath;
import com.linecorp.armeria.internal.shaded.fastutil.bytes.ByteIterable;
import com.linecorp.armeria.internal.shaded.fastutil.bytes.ByteIterator;
import java.util.Collection;
import java.util.Objects;
import java.util.function.IntPredicate;
import java.util.function.Predicate;

public interface ByteCollection
extends ByteIterable,
Collection<Byte> {
    @Override
    public ByteIterator iterator();

    @Override
    public boolean add(byte var1);

    public boolean contains(byte var1);

    public boolean rem(byte var1);

    @Override
    @Deprecated
    default public boolean add(Byte key) {
        return this.add((byte)key);
    }

    @Override
    @Deprecated
    default public boolean contains(Object key) {
        if (key == null) {
            return false;
        }
        return this.contains((Byte)key);
    }

    @Override
    @Deprecated
    default public boolean remove(Object key) {
        if (key == null) {
            return false;
        }
        return this.rem((Byte)key);
    }

    @Override
    @Deprecated
    default public boolean removeIf(Predicate<? super Byte> filter) {
        return this.removeIf((int key) -> filter.test(SafeMath.safeIntToByte(key)));
    }

    default public boolean removeIf(IntPredicate filter) {
        Objects.requireNonNull(filter);
        boolean removed = false;
        ByteIterator each = this.iterator();
        while (each.hasNext()) {
            if (!filter.test(each.nextByte())) continue;
            each.remove();
            removed = true;
        }
        return removed;
    }
}

