/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.shaded.fastutil.floats;

import com.linecorp.armeria.internal.shaded.fastutil.SafeMath;
import com.linecorp.armeria.internal.shaded.fastutil.floats.FloatIterable;
import com.linecorp.armeria.internal.shaded.fastutil.floats.FloatIterator;
import java.util.Collection;
import java.util.Objects;
import java.util.function.DoublePredicate;
import java.util.function.Predicate;

public interface FloatCollection
extends FloatIterable,
Collection<Float> {
    @Override
    public FloatIterator iterator();

    @Override
    public boolean add(float var1);

    public boolean contains(float var1);

    public boolean rem(float var1);

    @Override
    @Deprecated
    default public boolean add(Float key) {
        return this.add(key.floatValue());
    }

    @Override
    @Deprecated
    default public boolean contains(Object key) {
        if (key == null) {
            return false;
        }
        return this.contains(((Float)key).floatValue());
    }

    @Override
    @Deprecated
    default public boolean remove(Object key) {
        if (key == null) {
            return false;
        }
        return this.rem(((Float)key).floatValue());
    }

    @Override
    @Deprecated
    default public boolean removeIf(Predicate<? super Float> filter) {
        return this.removeIf((double key) -> filter.test(Float.valueOf(SafeMath.safeDoubleToFloat(key))));
    }

    default public boolean removeIf(DoublePredicate filter) {
        Objects.requireNonNull(filter);
        boolean removed = false;
        FloatIterator each = this.iterator();
        while (each.hasNext()) {
            if (!filter.test(each.nextFloat())) continue;
            each.remove();
            removed = true;
        }
        return removed;
    }
}

