/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.shaded.fastutil.objects;

import com.linecorp.armeria.internal.shaded.fastutil.Hash;
import java.io.Serializable;
import java.lang.reflect.Array;

public final class ObjectArrays {
    public static final Object[] EMPTY_ARRAY = new Object[0];
    public static final Object[] DEFAULT_EMPTY_ARRAY = new Object[0];
    public static final Hash.Strategy HASH_STRATEGY = new ArrayHashStrategy();

    private static <K> K[] newArray(K[] prototype, int length) {
        Class<?> klass = prototype.getClass();
        if (klass == Object[].class) {
            return length == 0 ? EMPTY_ARRAY : new Object[length];
        }
        return (Object[])Array.newInstance(klass.getComponentType(), length);
    }

    public static <K> K[] forceCapacity(K[] array, int length, int preserve) {
        K[] t = ObjectArrays.newArray(array, length);
        System.arraycopy(array, 0, t, 0, preserve);
        return t;
    }

    private static final class ArrayHashStrategy<K>
    implements Hash.Strategy<K[]>,
    Serializable {
        private ArrayHashStrategy() {
        }
    }
}

