/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.shaded.fastutil.shorts;

import com.linecorp.armeria.internal.shaded.fastutil.SafeMath;
import com.linecorp.armeria.internal.shaded.fastutil.shorts.ShortIterable;
import com.linecorp.armeria.internal.shaded.fastutil.shorts.ShortIterator;
import java.util.Collection;
import java.util.Objects;
import java.util.function.IntPredicate;
import java.util.function.Predicate;

public interface ShortCollection
extends ShortIterable,
Collection<Short> {
    @Override
    public ShortIterator iterator();

    @Override
    public boolean add(short var1);

    public boolean contains(short var1);

    public boolean rem(short var1);

    @Override
    @Deprecated
    default public boolean add(Short key) {
        return this.add((short)key);
    }

    @Override
    @Deprecated
    default public boolean contains(Object key) {
        if (key == null) {
            return false;
        }
        return this.contains((Short)key);
    }

    @Override
    @Deprecated
    default public boolean remove(Object key) {
        if (key == null) {
            return false;
        }
        return this.rem((Short)key);
    }

    @Override
    @Deprecated
    default public boolean removeIf(Predicate<? super Short> filter) {
        return this.removeIf((int key) -> filter.test(SafeMath.safeIntToShort(key)));
    }

    default public boolean removeIf(IntPredicate filter) {
        Objects.requireNonNull(filter);
        boolean removed = false;
        ShortIterator each = this.iterator();
        while (each.hasNext()) {
            if (!filter.test(each.nextShort())) continue;
            each.remove();
            removed = true;
        }
        return removed;
    }
}

