/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.shaded.guava.base;

import com.linecorp.armeria.internal.shaded.guava.base.Optional;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import org.checkerframework.checker.nullness.qual.Nullable;

final class Absent<T>
extends Optional<T> {
    static final Absent<Object> INSTANCE = new Absent();

    static <T> Optional<T> withType() {
        return INSTANCE;
    }

    private Absent() {
    }

    @Override
    public boolean isPresent() {
        return false;
    }

    @Override
    public T get() {
        throw new IllegalStateException("Optional.get() cannot be called on an absent value");
    }

    @Override
    public T or(T defaultValue) {
        return Preconditions.checkNotNull(defaultValue, "use Optional.orNull() instead of Optional.or(null)");
    }

    @Override
    public @Nullable T orNull() {
        return null;
    }

    @Override
    public boolean equals(@Nullable Object object) {
        return object == this;
    }

    public int hashCode() {
        return 2040732332;
    }

    public String toString() {
        return "Optional.absent()";
    }
}

