/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.shaded.guava.collect;

import com.google.j2objc.annotations.Weak;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableMap;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableSet;
import com.linecorp.armeria.internal.shaded.guava.collect.IndexedImmutableSet;
import com.linecorp.armeria.internal.shaded.guava.collect.UnmodifiableIterator;
import java.util.Map;
import java.util.Spliterator;
import java.util.function.Consumer;
import org.checkerframework.checker.nullness.qual.Nullable;

final class ImmutableMapKeySet<K, V>
extends IndexedImmutableSet<K> {
    @Weak
    private final ImmutableMap<K, V> map;

    ImmutableMapKeySet(ImmutableMap<K, V> map) {
        this.map = map;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public UnmodifiableIterator<K> iterator() {
        return this.map.keyIterator();
    }

    @Override
    public Spliterator<K> spliterator() {
        return this.map.keySpliterator();
    }

    @Override
    public boolean contains(@Nullable Object object) {
        return this.map.containsKey(object);
    }

    @Override
    K get(int index) {
        return ((Map.Entry)((ImmutableSet)this.map.entrySet()).asList().get(index)).getKey();
    }

    @Override
    public void forEach(Consumer<? super K> action) {
        Preconditions.checkNotNull(action);
        this.map.forEach((? super K k, ? super V v) -> action.accept((Object)k));
    }

    @Override
    boolean isPartialView() {
        return true;
    }
}

