/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.shaded.guava.primitives;

import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import com.linecorp.armeria.internal.shaded.guava.primitives.Longs;
import com.linecorp.armeria.internal.shaded.guava.primitives.UnsignedLongs;
import java.io.Serializable;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class UnsignedLong
extends Number
implements Serializable,
Comparable<UnsignedLong> {
    public static final UnsignedLong ZERO = new UnsignedLong(0L);
    public static final UnsignedLong ONE = new UnsignedLong(1L);
    public static final UnsignedLong MAX_VALUE = new UnsignedLong(-1L);
    private final long value;

    private UnsignedLong(long value) {
        this.value = value;
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        float fValue = this.value & Long.MAX_VALUE;
        if (this.value < 0L) {
            fValue += 9.223372E18f;
        }
        return fValue;
    }

    @Override
    public double doubleValue() {
        double dValue = this.value & Long.MAX_VALUE;
        if (this.value < 0L) {
            dValue += 9.223372036854776E18;
        }
        return dValue;
    }

    @Override
    public int compareTo(UnsignedLong o) {
        Preconditions.checkNotNull(o);
        return UnsignedLongs.compare(this.value, o.value);
    }

    public int hashCode() {
        return Longs.hashCode(this.value);
    }

    public boolean equals(@Nullable Object obj) {
        if (obj instanceof UnsignedLong) {
            UnsignedLong other = (UnsignedLong)obj;
            return this.value == other.value;
        }
        return false;
    }

    public String toString() {
        return UnsignedLongs.toString(this.value);
    }
}

