/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.shaded.jctools.queues;

import com.linecorp.armeria.internal.shaded.jctools.queues.BaseLinkedQueue;
import com.linecorp.armeria.internal.shaded.jctools.queues.LinkedQueueNode;
import com.linecorp.armeria.internal.shaded.jctools.queues.MessagePassingQueue;
import com.linecorp.armeria.internal.shaded.jctools.queues.MpscLinkedQueue7;
import com.linecorp.armeria.internal.shaded.jctools.queues.MpscLinkedQueue8;
import com.linecorp.armeria.internal.shaded.jctools.util.UnsafeAccess;

public abstract class MpscLinkedQueue<E>
extends BaseLinkedQueue<E> {
    public static <E> MpscLinkedQueue<E> newMpscLinkedQueue() {
        if (UnsafeAccess.SUPPORTS_GET_AND_SET) {
            return new MpscLinkedQueue8();
        }
        return new MpscLinkedQueue7();
    }

    protected MpscLinkedQueue() {
        LinkedQueueNode node = this.newNode();
        this.spConsumerNode(node);
        this.xchgProducerNode(node);
    }

    @Override
    public final boolean offer(E e) {
        if (null == e) {
            throw new NullPointerException();
        }
        LinkedQueueNode<E> nextNode = this.newNode(e);
        LinkedQueueNode<E> prevProducerNode = this.xchgProducerNode(nextNode);
        prevProducerNode.soNext(nextNode);
        return true;
    }

    @Override
    public final E poll() {
        LinkedQueueNode currConsumerNode = this.lpConsumerNode();
        LinkedQueueNode nextNode = currConsumerNode.lvNext();
        if (nextNode != null) {
            return this.getSingleConsumerNodeValue(currConsumerNode, nextNode);
        }
        if (currConsumerNode != this.lvProducerNode()) {
            nextNode = this.spinWaitForNextNode(currConsumerNode);
            return this.getSingleConsumerNodeValue(currConsumerNode, nextNode);
        }
        return null;
    }

    @Override
    public final E peek() {
        LinkedQueueNode currConsumerNode = this.lpConsumerNode();
        LinkedQueueNode nextNode = currConsumerNode.lvNext();
        if (nextNode != null) {
            return nextNode.lpValue();
        }
        if (currConsumerNode != this.lvProducerNode()) {
            nextNode = this.spinWaitForNextNode(currConsumerNode);
            return nextNode.lpValue();
        }
        return null;
    }

    @Override
    public final boolean remove(Object o) {
        LinkedQueueNode originalConsumerNode;
        if (null == o) {
            return false;
        }
        LinkedQueueNode prevConsumerNode = originalConsumerNode = this.lpConsumerNode();
        LinkedQueueNode currConsumerNode = this.getNextConsumerNode(originalConsumerNode);
        while (currConsumerNode != null) {
            if (o.equals(currConsumerNode.lpValue())) {
                LinkedQueueNode nextNode = this.getNextConsumerNode(currConsumerNode);
                if (nextNode != null) {
                    prevConsumerNode.soNext(nextNode);
                } else {
                    prevConsumerNode.soNext(null);
                    if (!this.casProducerNode(currConsumerNode, prevConsumerNode)) {
                        nextNode = this.spinWaitForNextNode(currConsumerNode);
                        prevConsumerNode.soNext(nextNode);
                    }
                }
                currConsumerNode.soNext(null);
                currConsumerNode.spValue(null);
                return true;
            }
            prevConsumerNode = currConsumerNode;
            currConsumerNode = this.getNextConsumerNode(currConsumerNode);
        }
        return false;
    }

    @Override
    public int fill(MessagePassingQueue.Supplier<E> s) {
        long result = 0L;
        do {
            this.fill(s, 4096);
        } while ((result += 4096L) <= 0x7FFFEFFFL);
        return (int)result;
    }

    @Override
    public int fill(MessagePassingQueue.Supplier<E> s, int limit) {
        LinkedQueueNode<E> tail;
        if (limit == 0) {
            return 0;
        }
        LinkedQueueNode<E> head = tail = this.newNode(s.get());
        for (int i = 1; i < limit; ++i) {
            LinkedQueueNode<E> temp = this.newNode(s.get());
            tail.soNext(temp);
            tail = temp;
        }
        LinkedQueueNode<E> oldPNode = this.xchgProducerNode(tail);
        oldPNode.soNext(head);
        return limit;
    }

    @Override
    public void fill(MessagePassingQueue.Supplier<E> s, MessagePassingQueue.WaitStrategy wait, MessagePassingQueue.ExitCondition exit) {
        while (exit.keepRunning()) {
            this.fill(s, 4096);
        }
    }

    protected abstract LinkedQueueNode<E> xchgProducerNode(LinkedQueueNode<E> var1);

    private LinkedQueueNode<E> getNextConsumerNode(LinkedQueueNode<E> currConsumerNode) {
        LinkedQueueNode<E> nextNode = currConsumerNode.lvNext();
        if (nextNode == null && currConsumerNode != this.lvProducerNode()) {
            nextNode = this.spinWaitForNextNode(currConsumerNode);
        }
        return nextNode;
    }

    private LinkedQueueNode<E> spinWaitForNextNode(LinkedQueueNode<E> currNode) {
        LinkedQueueNode<E> nextNode;
        while ((nextNode = currNode.lvNext()) == null) {
        }
        return nextNode;
    }
}

