/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.shaded.jctools.queues.atomic;

import com.linecorp.armeria.internal.shaded.jctools.queues.MessagePassingQueue;
import com.linecorp.armeria.internal.shaded.jctools.queues.atomic.SpmcAtomicArrayQueueL3Pad;
import com.linecorp.armeria.internal.shaded.jctools.util.PortableJvmInfo;
import java.util.concurrent.atomic.AtomicReferenceArray;

public class SpmcAtomicArrayQueue<E>
extends SpmcAtomicArrayQueueL3Pad<E> {
    public SpmcAtomicArrayQueue(int capacity) {
        super(capacity);
    }

    @Override
    public boolean offer(E e) {
        if (null == e) {
            throw new NullPointerException();
        }
        AtomicReferenceArray buffer = this.buffer;
        int mask = this.mask;
        long currProducerIndex = this.lvProducerIndex();
        int offset = this.calcElementOffset(currProducerIndex, mask);
        if (null != SpmcAtomicArrayQueue.lvElement(buffer, offset)) {
            long size = currProducerIndex - this.lvConsumerIndex();
            if (size > (long)mask) {
                return false;
            }
            while (null != SpmcAtomicArrayQueue.lvElement(buffer, offset)) {
            }
        }
        SpmcAtomicArrayQueue.spElement(buffer, offset, e);
        this.soProducerIndex(currProducerIndex + 1L);
        return true;
    }

    @Override
    public E poll() {
        long currentConsumerIndex;
        long currProducerIndexCache = this.lvProducerIndexCache();
        do {
            if ((currentConsumerIndex = this.lvConsumerIndex()) < currProducerIndexCache) continue;
            long currProducerIndex = this.lvProducerIndex();
            if (currentConsumerIndex >= currProducerIndex) {
                return null;
            }
            currProducerIndexCache = currProducerIndex;
            this.svProducerIndexCache(currProducerIndex);
        } while (!this.casConsumerIndex(currentConsumerIndex, currentConsumerIndex + 1L));
        return this.removeElement(this.buffer, currentConsumerIndex, this.mask);
    }

    private E removeElement(AtomicReferenceArray<E> buffer, long index, int mask) {
        int offset = this.calcElementOffset(index, mask);
        E e = SpmcAtomicArrayQueue.lpElement(buffer, offset);
        SpmcAtomicArrayQueue.soElement(buffer, offset, null);
        return e;
    }

    @Override
    public E peek() {
        long currentConsumerIndex;
        Object e;
        int mask = this.mask;
        long currProducerIndexCache = this.lvProducerIndexCache();
        do {
            if ((currentConsumerIndex = this.lvConsumerIndex()) < currProducerIndexCache) continue;
            long currProducerIndex = this.lvProducerIndex();
            if (currentConsumerIndex >= currProducerIndex) {
                return null;
            }
            this.svProducerIndexCache(currProducerIndex);
        } while (null == (e = SpmcAtomicArrayQueue.lvElement(this.buffer, this.calcElementOffset(currentConsumerIndex, mask))));
        return e;
    }

    @Override
    public boolean relaxedOffer(E e) {
        if (null == e) {
            throw new NullPointerException("Null is not a valid element");
        }
        AtomicReferenceArray buffer = this.buffer;
        int mask = this.mask;
        long producerIndex = this.lvProducerIndex();
        int offset = this.calcElementOffset(producerIndex, mask);
        if (null != SpmcAtomicArrayQueue.lvElement(buffer, offset)) {
            return false;
        }
        SpmcAtomicArrayQueue.spElement(buffer, offset, e);
        this.soProducerIndex(producerIndex + 1L);
        return true;
    }

    @Override
    public E relaxedPoll() {
        return this.poll();
    }

    @Override
    public E relaxedPeek() {
        AtomicReferenceArray buffer = this.buffer;
        int mask = this.mask;
        long consumerIndex = this.lvConsumerIndex();
        return SpmcAtomicArrayQueue.lvElement(buffer, this.calcElementOffset(consumerIndex, mask));
    }

    @Override
    public int drain(MessagePassingQueue.Consumer<E> c) {
        int sum;
        int drained;
        int capacity = this.capacity();
        for (sum = 0; sum < capacity; sum += drained) {
            drained = 0;
            drained = this.drain(c, PortableJvmInfo.RECOMENDED_POLL_BATCH);
            if (drained == 0) break;
        }
        return sum;
    }

    @Override
    public int fill(MessagePassingQueue.Supplier<E> s) {
        return this.fill(s, this.capacity());
    }

    @Override
    public int drain(MessagePassingQueue.Consumer<E> c, int limit) {
        int remaining;
        long currentConsumerIndex;
        AtomicReferenceArray buffer = this.buffer;
        int mask = this.mask;
        long currProducerIndexCache = this.lvProducerIndexCache();
        int adjustedLimit = 0;
        do {
            if ((currentConsumerIndex = this.lvConsumerIndex()) < currProducerIndexCache) continue;
            long currProducerIndex = this.lvProducerIndex();
            if (currentConsumerIndex >= currProducerIndex) {
                return 0;
            }
            currProducerIndexCache = currProducerIndex;
            this.svProducerIndexCache(currProducerIndex);
        } while (!this.casConsumerIndex(currentConsumerIndex, currentConsumerIndex + (long)(adjustedLimit = Math.min(remaining = (int)(currProducerIndexCache - currentConsumerIndex), limit))));
        for (int i = 0; i < adjustedLimit; ++i) {
            c.accept(this.removeElement(buffer, currentConsumerIndex + (long)i, mask));
        }
        return adjustedLimit;
    }

    @Override
    public int fill(MessagePassingQueue.Supplier<E> s, int limit) {
        AtomicReferenceArray buffer = this.buffer;
        int mask = this.mask;
        long producerIndex = this.producerIndex;
        for (int i = 0; i < limit; ++i) {
            int offset = this.calcElementOffset(producerIndex, mask);
            if (null != SpmcAtomicArrayQueue.lvElement(buffer, offset)) {
                return i;
            }
            SpmcAtomicArrayQueue.soElement(buffer, offset, s.get());
            this.soProducerIndex(++producerIndex);
        }
        return limit;
    }

    @Override
    public void drain(MessagePassingQueue.Consumer<E> c, MessagePassingQueue.WaitStrategy w, MessagePassingQueue.ExitCondition exit) {
        int idleCounter = 0;
        while (exit.keepRunning()) {
            if (this.drain(c, PortableJvmInfo.RECOMENDED_POLL_BATCH) == 0) {
                idleCounter = w.idle(idleCounter);
                continue;
            }
            idleCounter = 0;
        }
    }

    @Override
    public void fill(MessagePassingQueue.Supplier<E> s, MessagePassingQueue.WaitStrategy w, MessagePassingQueue.ExitCondition e) {
        AtomicReferenceArray buffer = this.buffer;
        int mask = this.mask;
        long producerIndex = this.producerIndex;
        int counter = 0;
        while (e.keepRunning()) {
            for (int i = 0; i < 4096; ++i) {
                int offset = this.calcElementOffset(producerIndex, mask);
                if (null != SpmcAtomicArrayQueue.lvElement(buffer, offset)) {
                    counter = w.idle(counter);
                    continue;
                }
                counter = 0;
                SpmcAtomicArrayQueue.soElement(buffer, offset, s.get());
                this.soProducerIndex(++producerIndex);
            }
        }
    }
}

