/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.shaded.jctools.queues.atomic;

import com.linecorp.armeria.internal.shaded.jctools.queues.MessagePassingQueue;
import com.linecorp.armeria.internal.shaded.jctools.queues.atomic.BaseSpscLinkedAtomicArrayQueue;
import com.linecorp.armeria.internal.shaded.jctools.queues.atomic.LinkedAtomicArrayQueueUtil;
import com.linecorp.armeria.internal.shaded.jctools.util.Pow2;
import java.util.concurrent.atomic.AtomicReferenceArray;

public class SpscUnboundedAtomicArrayQueue<E>
extends BaseSpscLinkedAtomicArrayQueue<E> {
    public SpscUnboundedAtomicArrayQueue(int chunkSize) {
        AtomicReferenceArray buffer;
        int chunkCapacity = Math.max(Pow2.roundToPowerOfTwo(chunkSize), 16);
        long mask = chunkCapacity - 1;
        this.producerBuffer = buffer = LinkedAtomicArrayQueueUtil.allocate(chunkCapacity + 1);
        this.producerMask = mask;
        this.consumerBuffer = buffer;
        this.consumerMask = mask;
        this.producerBufferLimit = mask - 1L;
    }

    @Override
    final boolean offerColdPath(AtomicReferenceArray<E> buffer, long mask, long pIndex, int offset, E v, MessagePassingQueue.Supplier<? extends E> s) {
        long lookAheadStep = (mask + 1L) / 4L;
        long pBufferLimit = pIndex + lookAheadStep;
        if (null == LinkedAtomicArrayQueueUtil.lvElement(buffer, LinkedAtomicArrayQueueUtil.calcElementOffset(pBufferLimit, mask))) {
            this.producerBufferLimit = pBufferLimit - 1L;
            this.writeToQueue(buffer, v == null ? s.get() : v, pIndex, offset);
        } else if (null == LinkedAtomicArrayQueueUtil.lvElement(buffer, LinkedAtomicArrayQueueUtil.calcElementOffset(pIndex + 1L, mask))) {
            this.writeToQueue(buffer, v == null ? s.get() : v, pIndex, offset);
        } else {
            AtomicReferenceArray newBuffer;
            this.producerBuffer = newBuffer = LinkedAtomicArrayQueueUtil.allocate((int)(mask + 2L));
            this.producerBufferLimit = pIndex + mask - 1L;
            this.linkOldToNew(pIndex, buffer, offset, newBuffer, offset, v == null ? s.get() : v);
        }
        return true;
    }

    @Override
    public int capacity() {
        return -1;
    }
}

