/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.shaded.reflections;

import com.linecorp.armeria.internal.shaded.guava.base.Joiner;
import com.linecorp.armeria.internal.shaded.guava.base.Predicate;
import com.linecorp.armeria.internal.shaded.guava.collect.HashMultimap;
import com.linecorp.armeria.internal.shaded.guava.collect.Iterables;
import com.linecorp.armeria.internal.shaded.guava.collect.Lists;
import com.linecorp.armeria.internal.shaded.guava.collect.Multimap;
import com.linecorp.armeria.internal.shaded.guava.collect.Sets;
import com.linecorp.armeria.internal.shaded.reflections.Configuration;
import com.linecorp.armeria.internal.shaded.reflections.ReflectionUtils;
import com.linecorp.armeria.internal.shaded.reflections.ReflectionsException;
import com.linecorp.armeria.internal.shaded.reflections.Store;
import com.linecorp.armeria.internal.shaded.reflections.scanners.ResourcesScanner;
import com.linecorp.armeria.internal.shaded.reflections.scanners.Scanner;
import com.linecorp.armeria.internal.shaded.reflections.scanners.SubTypesScanner;
import com.linecorp.armeria.internal.shaded.reflections.util.ConfigurationBuilder;
import com.linecorp.armeria.internal.shaded.reflections.util.Utils;
import com.linecorp.armeria.internal.shaded.reflections.vfs.Vfs;
import java.net.URL;
import java.util.ArrayList;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import javax.annotation.Nullable;
import org.slf4j.Logger;

public class Reflections {
    @Nullable
    public static Logger log = Utils.findLogger(Reflections.class);
    protected final transient Configuration configuration;
    protected Store store;

    public Reflections(Configuration configuration) {
        this.configuration = configuration;
        this.store = new Store(configuration);
        if (configuration.getScanners() != null && !configuration.getScanners().isEmpty()) {
            for (Scanner scanner : configuration.getScanners()) {
                scanner.setConfiguration(configuration);
                scanner.setStore(this.store.getOrCreate(scanner.getClass().getSimpleName()));
            }
            this.scan();
            if (configuration.shouldExpandSuperTypes()) {
                this.expandSuperTypes();
            }
        }
    }

    protected Reflections() {
        this.configuration = new ConfigurationBuilder();
        this.store = new Store(this.configuration);
    }

    /*
     * WARNING - void declaration
     */
    protected void scan() {
        if (this.configuration.getUrls() == null || this.configuration.getUrls().isEmpty()) {
            if (log != null) {
                log.warn("given scan urls are empty. set urls in the configuration");
            }
            return;
        }
        if (log != null && log.isDebugEnabled()) {
            log.debug("going to scan these urls:\n" + Joiner.on("\n").join(this.configuration.getUrls()));
        }
        long time = System.currentTimeMillis();
        int scannedUrls = 0;
        ExecutorService executorService = this.configuration.getExecutorService();
        ArrayList<Future<?>> futures = Lists.newArrayList();
        for (final URL uRL : this.configuration.getUrls()) {
            try {
                if (executorService != null) {
                    futures.add(executorService.submit(new Runnable(){

                        @Override
                        public void run() {
                            if (log != null && log.isDebugEnabled()) {
                                log.debug("[" + Thread.currentThread().toString() + "] scanning " + uRL);
                            }
                            Reflections.this.scan(uRL);
                        }
                    }));
                } else {
                    this.scan(uRL);
                }
                ++scannedUrls;
            }
            catch (ReflectionsException e) {
                if (log == null || !log.isWarnEnabled()) continue;
                log.warn("could not create Vfs.Dir from url. ignoring the exception and continuing", (Throwable)e);
            }
        }
        if (executorService != null) {
            for (Future future : futures) {
                try {
                    future.get();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        time = System.currentTimeMillis() - time;
        if (executorService != null) {
            executorService.shutdown();
        }
        if (log != null) {
            void var7_11;
            int keys = 0;
            boolean bl = false;
            for (String index : this.store.keySet()) {
                keys += this.store.get(index).keySet().size();
                var7_11 += this.store.get(index).size();
            }
            log.info(String.format("Reflections took %d ms to scan %d urls, producing %d keys and %d values %s", time, scannedUrls, keys, (int)var7_11, executorService != null && executorService instanceof ThreadPoolExecutor ? String.format("[using %d cores]", ((ThreadPoolExecutor)executorService).getMaximumPoolSize()) : ""));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void scan(URL url) {
        try (Vfs.Dir dir = Vfs.fromURL(url);){
            for (Vfs.File file : dir.getFiles()) {
                Predicate<String> inputsFilter = this.configuration.getInputsFilter();
                String path = file.getRelativePath();
                String fqn = path.replace('/', '.');
                if (inputsFilter != null && !inputsFilter.apply(path) && !inputsFilter.apply(fqn)) continue;
                Object classObject = null;
                for (Scanner scanner : this.configuration.getScanners()) {
                    try {
                        if (!scanner.acceptsInput(path) && !scanner.acceptResult(fqn)) continue;
                        classObject = scanner.scan(file, classObject);
                    }
                    catch (Exception e) {
                        if (log == null || !log.isDebugEnabled()) continue;
                        log.debug("could not scan file " + file.getRelativePath() + " in url " + url.toExternalForm() + " with scanner " + scanner.getClass().getSimpleName(), (Throwable)e);
                    }
                }
            }
        }
    }

    public void expandSuperTypes() {
        if (this.store.keySet().contains(Reflections.index(SubTypesScanner.class))) {
            Multimap<String, String> mmap = this.store.get(Reflections.index(SubTypesScanner.class));
            Sets.SetView<String> keys = Sets.difference(mmap.keySet(), Sets.newHashSet(mmap.values()));
            HashMultimap<String, String> expand = HashMultimap.create();
            for (String key : keys) {
                Class<?> type = ReflectionUtils.forName(key, new ClassLoader[0]);
                if (type == null) continue;
                this.expandSupertypes(expand, key, type);
            }
            mmap.putAll(expand);
        }
    }

    private void expandSupertypes(Multimap<String, String> mmap, String key, Class<?> type) {
        for (Class<?> supertype : ReflectionUtils.getSuperTypes(type)) {
            if (!mmap.put(supertype.getName(), key)) continue;
            if (log != null) {
                log.debug("expanded subtype {} -> {}", (Object)supertype.getName(), (Object)key);
            }
            this.expandSupertypes(mmap, supertype.getName(), supertype);
        }
    }

    public Set<String> getResources(Predicate<String> namePredicate) {
        Iterable<String> resources = Iterables.filter(this.store.get(Reflections.index(ResourcesScanner.class)).keySet(), namePredicate);
        return Sets.newHashSet(this.store.get(Reflections.index(ResourcesScanner.class), resources));
    }

    private static String index(Class<? extends Scanner> scannerClass) {
        return scannerClass.getSimpleName();
    }
}

