/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server;

import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpResponseWriter;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.SerializationFormat;
import com.linecorp.armeria.common.logging.RequestLogBuilder;
import com.linecorp.armeria.server.HttpService;
import com.linecorp.armeria.server.ServiceRequestContext;

public abstract class AbstractHttpService
implements HttpService {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpResponse serve(ServiceRequestContext ctx, HttpRequest req) throws Exception {
        try {
            switch (req.method()) {
                case OPTIONS: {
                    HttpResponse httpResponse = this.doOptions(ctx, req);
                    return httpResponse;
                }
                case GET: {
                    HttpResponse httpResponse = this.doGet(ctx, req);
                    return httpResponse;
                }
                case HEAD: {
                    HttpResponse httpResponse = this.doHead(ctx, req);
                    return httpResponse;
                }
                case POST: {
                    HttpResponse httpResponse = this.doPost(ctx, req);
                    return httpResponse;
                }
                case PUT: {
                    HttpResponse httpResponse = this.doPut(ctx, req);
                    return httpResponse;
                }
                case PATCH: {
                    HttpResponse httpResponse = this.doPatch(ctx, req);
                    return httpResponse;
                }
                case DELETE: {
                    HttpResponse httpResponse = this.doDelete(ctx, req);
                    return httpResponse;
                }
                case TRACE: {
                    HttpResponse httpResponse = this.doTrace(ctx, req);
                    return httpResponse;
                }
            }
            HttpResponse httpResponse = HttpResponse.of(HttpStatus.METHOD_NOT_ALLOWED);
            return httpResponse;
        }
        finally {
            RequestLogBuilder logBuilder = ctx.logBuilder();
            if (!logBuilder.isRequestContentDeferred()) {
                logBuilder.requestContent(null, null);
            }
            logBuilder.serializationFormat(SerializationFormat.NONE);
        }
    }

    protected HttpResponse doOptions(ServiceRequestContext ctx, HttpRequest req) throws Exception {
        HttpResponseWriter res = HttpResponse.streaming();
        this.doOptions(ctx, req, res);
        return res;
    }

    @Deprecated
    protected void doOptions(ServiceRequestContext ctx, HttpRequest req, HttpResponseWriter res) throws Exception {
        res.respond(HttpStatus.METHOD_NOT_ALLOWED);
    }

    protected HttpResponse doGet(ServiceRequestContext ctx, HttpRequest req) throws Exception {
        HttpResponseWriter res = HttpResponse.streaming();
        this.doGet(ctx, req, res);
        return res;
    }

    @Deprecated
    protected void doGet(ServiceRequestContext ctx, HttpRequest req, HttpResponseWriter res) throws Exception {
        res.respond(HttpStatus.METHOD_NOT_ALLOWED);
    }

    protected HttpResponse doHead(ServiceRequestContext ctx, HttpRequest req) throws Exception {
        HttpResponseWriter res = HttpResponse.streaming();
        this.doHead(ctx, req, res);
        return res;
    }

    @Deprecated
    protected void doHead(ServiceRequestContext ctx, HttpRequest req, HttpResponseWriter res) throws Exception {
        res.respond(HttpStatus.METHOD_NOT_ALLOWED);
    }

    protected HttpResponse doPost(ServiceRequestContext ctx, HttpRequest req) throws Exception {
        HttpResponseWriter res = HttpResponse.streaming();
        this.doPost(ctx, req, res);
        return res;
    }

    @Deprecated
    protected void doPost(ServiceRequestContext ctx, HttpRequest req, HttpResponseWriter res) throws Exception {
        res.respond(HttpStatus.METHOD_NOT_ALLOWED);
    }

    protected HttpResponse doPut(ServiceRequestContext ctx, HttpRequest req) throws Exception {
        HttpResponseWriter res = HttpResponse.streaming();
        this.doPut(ctx, req, res);
        return res;
    }

    @Deprecated
    protected void doPut(ServiceRequestContext ctx, HttpRequest req, HttpResponseWriter res) throws Exception {
        res.respond(HttpStatus.METHOD_NOT_ALLOWED);
    }

    protected HttpResponse doPatch(ServiceRequestContext ctx, HttpRequest req) throws Exception {
        HttpResponseWriter res = HttpResponse.streaming();
        this.doPatch(ctx, req, res);
        return res;
    }

    @Deprecated
    protected void doPatch(ServiceRequestContext ctx, HttpRequest req, HttpResponseWriter res) throws Exception {
        res.respond(HttpStatus.METHOD_NOT_ALLOWED);
    }

    protected HttpResponse doDelete(ServiceRequestContext ctx, HttpRequest req) throws Exception {
        HttpResponseWriter res = HttpResponse.streaming();
        this.doDelete(ctx, req, res);
        return res;
    }

    @Deprecated
    protected void doDelete(ServiceRequestContext ctx, HttpRequest req, HttpResponseWriter res) throws Exception {
        res.respond(HttpStatus.METHOD_NOT_ALLOWED);
    }

    protected HttpResponse doTrace(ServiceRequestContext ctx, HttpRequest req) throws Exception {
        HttpResponseWriter res = HttpResponse.streaming();
        this.doTrace(ctx, req, res);
        return res;
    }

    @Deprecated
    protected void doTrace(ServiceRequestContext ctx, HttpRequest req, HttpResponseWriter res) throws Exception {
        res.respond(HttpStatus.METHOD_NOT_ALLOWED);
    }
}

