/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server;

import com.linecorp.armeria.server.PathMapping;
import com.linecorp.armeria.server.PathMappingContext;
import com.linecorp.armeria.server.PathMappingResult;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

public abstract class AbstractPathMapping
implements PathMapping {
    @Override
    public final PathMappingResult apply(PathMappingContext mappingCtx) {
        AbstractPathMapping.ensureAbsolutePath(mappingCtx.path(), "path");
        return this.doApply(mappingCtx);
    }

    protected static String ensureAbsolutePath(String path, String paramName) {
        Objects.requireNonNull(path, paramName);
        if (path.isEmpty() || path.charAt(0) != '/') {
            throw new IllegalArgumentException(paramName + ": " + path + " (expected: an absolute path)");
        }
        return path;
    }

    protected abstract PathMappingResult doApply(PathMappingContext var1);

    @Override
    public String loggerName() {
        return "__UNKNOWN__";
    }

    static String loggerName(@Nullable String pathish) {
        if (pathish == null) {
            return "__UNKNOWN__";
        }
        String normalized = pathish;
        if ("/".equals(normalized)) {
            return "__ROOT__";
        }
        if (normalized.startsWith("/")) {
            normalized = normalized.substring(1);
        }
        int end = normalized.endsWith("/") ? normalized.length() - 1 : normalized.length();
        StringBuilder buf = new StringBuilder(end);
        boolean start = true;
        for (int i = 0; i < end; ++i) {
            char ch = normalized.charAt(i);
            if (ch != '/') {
                if (start) {
                    start = false;
                    if (Character.isJavaIdentifierStart(ch)) {
                        buf.append(ch);
                        continue;
                    }
                    buf.append('_');
                    if (!Character.isJavaIdentifierPart(ch)) continue;
                    buf.append(ch);
                    continue;
                }
                if (Character.isJavaIdentifierPart(ch)) {
                    buf.append(ch);
                    continue;
                }
                buf.append('_');
                continue;
            }
            start = true;
            buf.append('.');
        }
        return buf.toString();
    }

    @Override
    public String meterTag() {
        return "__UNKNOWN_PATH__";
    }

    @Override
    public Optional<String> exactPath() {
        return Optional.empty();
    }

    @Override
    public Optional<String> prefix() {
        return Optional.empty();
    }
}

