/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server;

import com.linecorp.armeria.common.Flags;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.common.MediaTypeSet;
import com.linecorp.armeria.common.SessionProtocol;
import com.linecorp.armeria.internal.crypto.BouncyCastleKeyFactoryProvider;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.server.AnnotatedHttpServiceFactory;
import com.linecorp.armeria.server.HttpHeaderPathMapping;
import com.linecorp.armeria.server.PathMapping;
import com.linecorp.armeria.server.Service;
import com.linecorp.armeria.server.ServiceConfig;
import com.linecorp.armeria.server.ServiceWithPathMappings;
import com.linecorp.armeria.server.VirtualHost;
import io.netty.handler.codec.http2.Http2SecurityUtil;
import io.netty.handler.ssl.ApplicationProtocolConfig;
import io.netty.handler.ssl.CipherSuiteFilter;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslProvider;
import io.netty.handler.ssl.SupportedCipherSuiteFilter;
import io.netty.handler.ssl.util.SelfSignedCertificate;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.net.ssl.SSLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractVirtualHostBuilder<B extends AbstractVirtualHostBuilder> {
    private static final Logger logger = LoggerFactory.getLogger(AbstractVirtualHostBuilder.class);
    private static final ApplicationProtocolConfig HTTPS_ALPN_CFG = new ApplicationProtocolConfig(ApplicationProtocolConfig.Protocol.ALPN, ApplicationProtocolConfig.SelectorFailureBehavior.NO_ADVERTISE, ApplicationProtocolConfig.SelectedListenerFailureBehavior.ACCEPT, new String[]{"h2", "http/1.1"});
    private static final String LOCAL_HOSTNAME;
    private final String defaultHostname;
    private final String hostnamePattern;
    private final List<ServiceConfig> services = new ArrayList<ServiceConfig>();
    @Nullable
    private SslContext sslContext;
    @Nullable
    private Function<Service<HttpRequest, HttpResponse>, Service<HttpRequest, HttpResponse>> decorator;

    AbstractVirtualHostBuilder() {
        this(LOCAL_HOSTNAME, "*");
    }

    AbstractVirtualHostBuilder(String hostnamePattern) {
        hostnamePattern = VirtualHost.normalizeHostnamePattern(hostnamePattern);
        this.defaultHostname = "*".equals(hostnamePattern) ? LOCAL_HOSTNAME : (hostnamePattern.startsWith("*.") ? hostnamePattern.substring(2) : hostnamePattern);
        this.hostnamePattern = hostnamePattern;
    }

    AbstractVirtualHostBuilder(String defaultHostname, String hostnamePattern) {
        Objects.requireNonNull(defaultHostname, "defaultHostname");
        defaultHostname = VirtualHost.normalizeDefaultHostname(defaultHostname);
        hostnamePattern = VirtualHost.normalizeHostnamePattern(hostnamePattern);
        VirtualHost.ensureHostnamePatternMatchesDefaultHostname(hostnamePattern, defaultHostname);
        this.defaultHostname = defaultHostname;
        this.hostnamePattern = hostnamePattern;
    }

    public B tls(SslContext sslContext) {
        this.sslContext = VirtualHost.validateSslContext(Objects.requireNonNull(sslContext, "sslContext"));
        return this.self();
    }

    public B tls(File keyCertChainFile, File keyFile) throws SSLException {
        this.tls(keyCertChainFile, keyFile, null);
        return this.self();
    }

    public B tls(File keyCertChainFile, File keyFile, @Nullable String keyPassword) throws SSLException {
        SslContext sslCtx;
        if (!keyCertChainFile.exists()) {
            throw new SSLException("non-existent certificate chain file: " + keyCertChainFile);
        }
        if (!keyCertChainFile.canRead()) {
            throw new SSLException("cannot read certificate chain file: " + keyCertChainFile);
        }
        if (!keyFile.exists()) {
            throw new SSLException("non-existent key file: " + keyFile);
        }
        if (!keyFile.canRead()) {
            throw new SSLException("cannot read key file: " + keyFile);
        }
        try {
            sslCtx = BouncyCastleKeyFactoryProvider.call(() -> {
                SslContextBuilder builder = SslContextBuilder.forServer((File)keyCertChainFile, (File)keyFile, (String)keyPassword);
                builder.sslProvider(Flags.useOpenSsl() ? SslProvider.OPENSSL : SslProvider.JDK);
                builder.ciphers((Iterable)Http2SecurityUtil.CIPHERS, (CipherSuiteFilter)SupportedCipherSuiteFilter.INSTANCE);
                builder.applicationProtocolConfig(HTTPS_ALPN_CFG);
                return builder.build();
            });
        }
        catch (RuntimeException | SSLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SSLException("failed to configure TLS: " + e, e);
        }
        this.tls(sslCtx);
        return this.self();
    }

    public B tlsSelfSigned() throws SSLException, CertificateException {
        SelfSignedCertificate ssc = new SelfSignedCertificate(this.defaultHostname);
        return this.tls(ssc.certificate(), ssc.privateKey());
    }

    @Deprecated
    public B sslContext(SslContext sslContext) {
        return this.tls(sslContext);
    }

    @Deprecated
    public B sslContext(SessionProtocol protocol, File keyCertChainFile, File keyFile) throws SSLException {
        this.sslContext(protocol, keyCertChainFile, keyFile, null);
        return this.self();
    }

    @Deprecated
    public B sslContext(SessionProtocol protocol, File keyCertChainFile, File keyFile, @Nullable String keyPassword) throws SSLException {
        if (Objects.requireNonNull(protocol, "protocol") != SessionProtocol.HTTPS) {
            throw new IllegalArgumentException("unsupported protocol: " + (Object)((Object)protocol));
        }
        return this.tls(keyCertChainFile, keyFile, keyPassword);
    }

    @Deprecated
    public B serviceAt(String pathPattern, Service<HttpRequest, HttpResponse> service) {
        return this.service(pathPattern, service);
    }

    public B serviceUnder(String pathPrefix, Service<HttpRequest, HttpResponse> service) {
        this.service(PathMapping.ofPrefix(pathPrefix), service);
        return this.self();
    }

    public B service(String pathPattern, Service<HttpRequest, HttpResponse> service) {
        this.service(PathMapping.of(pathPattern), service);
        return this.self();
    }

    public B service(PathMapping pathMapping, Service<HttpRequest, HttpResponse> service) {
        this.services.add(new ServiceConfig(pathMapping, service, null));
        return this.self();
    }

    @Deprecated
    public B service(PathMapping pathMapping, Service<HttpRequest, HttpResponse> service, String loggerName) {
        this.services.add(new ServiceConfig(pathMapping, service, loggerName));
        return this.self();
    }

    public <T extends ServiceWithPathMappings<HttpRequest, HttpResponse>> B service(T serviceWithPathMappings) {
        return this.service(serviceWithPathMappings, Function.identity());
    }

    public <T extends ServiceWithPathMappings<HttpRequest, HttpResponse>, R extends Service<HttpRequest, HttpResponse>> B service(T serviceWithPathMappings, Function<? super T, R> decorator) {
        Objects.requireNonNull(serviceWithPathMappings, "serviceWithPathMappings");
        Objects.requireNonNull(serviceWithPathMappings.pathMappings(), "serviceWithPathMappings.pathMappings()");
        Objects.requireNonNull(decorator, "decorator");
        Service decorated = (Service)decorator.apply(serviceWithPathMappings);
        serviceWithPathMappings.pathMappings().forEach(pathMapping -> this.service((PathMapping)pathMapping, (Service<HttpRequest, HttpResponse>)decorated));
        return this.self();
    }

    public B annotatedService(Object service) {
        return this.annotatedService("/", service, Function.identity(), ImmutableList.of());
    }

    public B annotatedService(Object service, Object ... exceptionHandlersAndConverters) {
        return this.annotatedService("/", service, Function.identity(), ImmutableList.copyOf(Objects.requireNonNull(exceptionHandlersAndConverters, "exceptionHandlersAndConverters")));
    }

    public B annotatedService(Object service, Function<Service<HttpRequest, HttpResponse>, ? extends Service<HttpRequest, HttpResponse>> decorator, Object ... exceptionHandlersAndConverters) {
        return this.annotatedService("/", service, decorator, Objects.requireNonNull(exceptionHandlersAndConverters, "exceptionHandlersAndConverters"));
    }

    public B annotatedService(String pathPrefix, Object service) {
        return this.annotatedService(pathPrefix, service, Function.identity(), ImmutableList.of());
    }

    public B annotatedService(String pathPrefix, Object service, Object ... exceptionHandlersAndConverters) {
        return this.annotatedService(pathPrefix, service, Function.identity(), ImmutableList.copyOf(Objects.requireNonNull(exceptionHandlersAndConverters, "exceptionHandlersAndConverters")));
    }

    public B annotatedService(String pathPrefix, Object service, Function<Service<HttpRequest, HttpResponse>, ? extends Service<HttpRequest, HttpResponse>> decorator, Object ... exceptionHandlersAndConverters) {
        return this.annotatedService(pathPrefix, service, decorator, ImmutableList.copyOf(Objects.requireNonNull(exceptionHandlersAndConverters, "exceptionHandlersAndConverters")));
    }

    public B annotatedService(String pathPrefix, Object service, Function<Service<HttpRequest, HttpResponse>, ? extends Service<HttpRequest, HttpResponse>> decorator, Iterable<?> exceptionHandlersAndConverters) {
        Objects.requireNonNull(pathPrefix, "pathPrefix");
        Objects.requireNonNull(service, "service");
        Objects.requireNonNull(decorator, "decorator");
        Objects.requireNonNull(exceptionHandlersAndConverters, "exceptionHandlersAndConverters");
        List<AnnotatedHttpServiceFactory.AnnotatedHttpServiceElement> elements = AnnotatedHttpServiceFactory.find(pathPrefix, service, exceptionHandlersAndConverters);
        elements.forEach(e -> this.service(e.pathMapping(), (Service<HttpRequest, HttpResponse>)((Service)decorator.apply(e.decorator().apply(e.service())))));
        return this.self();
    }

    public <T extends Service<HttpRequest, HttpResponse>, R extends Service<HttpRequest, HttpResponse>> B decorator(Function<T, R> decorator) {
        Objects.requireNonNull(decorator, "decorator");
        Function<T, R> castDecorator = decorator;
        this.decorator = this.decorator != null ? this.decorator.andThen(castDecorator) : castDecorator;
        return this.self();
    }

    final B self() {
        return (B)this;
    }

    protected VirtualHost build() {
        ArrayList<MediaType> producibleTypes = new ArrayList<MediaType>();
        this.services.forEach(e -> {
            PathMapping mapping = e.pathMapping();
            if (mapping instanceof HttpHeaderPathMapping) {
                producibleTypes.addAll(((HttpHeaderPathMapping)mapping).produceTypes());
            }
        });
        VirtualHost virtualHost = new VirtualHost(this.defaultHostname, this.hostnamePattern, this.sslContext, this.services, new MediaTypeSet(producibleTypes));
        return this.decorator != null ? virtualHost.decorate(this.decorator) : virtualHost;
    }

    public String toString() {
        return VirtualHost.toString(this.getClass(), this.defaultHostname, this.hostnamePattern, this.sslContext, this.services);
    }

    static {
        Process process = null;
        String hostname = null;
        try {
            process = Runtime.getRuntime().exec("hostname");
            String line = new BufferedReader(new InputStreamReader(process.getInputStream())).readLine();
            if (line == null) {
                logger.debug("The 'hostname' command returned nothing; using InetAddress.getLocalHost() instead");
            } else {
                hostname = VirtualHost.normalizeDefaultHostname(line.trim());
                logger.info("Hostname: {} (from 'hostname' command)", (Object)hostname);
            }
        }
        catch (Exception e) {
            logger.debug("Failed to get the hostname using the 'hostname' command; using InetAddress.getLocalHost() instead", (Throwable)e);
        }
        finally {
            if (process != null) {
                process.destroy();
            }
        }
        if (hostname == null) {
            try {
                hostname = VirtualHost.normalizeDefaultHostname(InetAddress.getLocalHost().getHostName());
                logger.info("Hostname: {} (from InetAddress.getLocalHost())", (Object)hostname);
            }
            catch (Exception e) {
                hostname = "localhost";
                logger.warn("Failed to get the hostname using InetAddress.getLocalHost(); using 'localhost' instead", (Throwable)e);
            }
        }
        LOCAL_HOSTNAME = hostname;
    }
}

