/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server;

import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import com.linecorp.armeria.internal.shaded.guava.base.Predicate;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableSortedSet;
import com.linecorp.armeria.internal.shaded.guava.collect.MapMaker;
import com.linecorp.armeria.internal.shaded.reflections.ReflectionUtils;
import com.linecorp.armeria.server.AnnotatedValueResolver;
import com.linecorp.armeria.server.annotation.RequestConverter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class AnnotatedBeanFactory {
    private static final Logger logger = LoggerFactory.getLogger(AnnotatedBeanFactory.class);
    private static final Function<AnnotatedValueResolver.ResolverContext, ?> unsupportedBeanFactory = resolverContext -> null;
    private static final ConcurrentMap<BeanFactoryId, Function<AnnotatedValueResolver.ResolverContext, ?>> factories = new MapMaker().makeMap();

    static synchronized BeanFactoryId register(Class<?> clazz, Set<String> pathParams, List<AnnotatedValueResolver.RequestObjectResolver> objectResolvers) {
        BeanFactoryId beanFactoryId = new BeanFactoryId(clazz, pathParams);
        if (!factories.containsKey(beanFactoryId)) {
            factories.put(beanFactoryId, MoreObjects.firstNonNull(AnnotatedBeanFactory.createFactory(beanFactoryId, objectResolvers), unsupportedBeanFactory));
        }
        return beanFactoryId;
    }

    static Optional<Function<AnnotatedValueResolver.ResolverContext, ?>> find(@Nullable BeanFactoryId beanFactoryId) {
        if (beanFactoryId == null) {
            return Optional.empty();
        }
        Function factory = (Function)factories.get(beanFactoryId);
        return factory != null && factory != unsupportedBeanFactory ? Optional.of(factory) : Optional.empty();
    }

    @Nullable
    private static <T> Function<AnnotatedValueResolver.ResolverContext, T> createFactory(BeanFactoryId beanFactoryId, List<AnnotatedValueResolver.RequestObjectResolver> objectResolvers) {
        Objects.requireNonNull(beanFactoryId, "beanFactoryId");
        Objects.requireNonNull(objectResolvers, "objectResolvers");
        int modifiers = beanFactoryId.type.getModifiers();
        if (Modifier.isAbstract(modifiers) || Modifier.isInterface(modifiers)) {
            return null;
        }
        List<AnnotatedValueResolver.RequestObjectResolver> resolvers = AnnotatedValueResolver.addToFirstIfExists(objectResolvers, (RequestConverter[])beanFactoryId.type.getAnnotationsByType(RequestConverter.class));
        Map.Entry constructor = AnnotatedBeanFactory.findConstructor(beanFactoryId, resolvers);
        if (constructor == null) {
            return null;
        }
        List<Map.Entry<Field, AnnotatedValueResolver>> fields = AnnotatedBeanFactory.findFields(beanFactoryId, resolvers);
        List<Map.Entry<Method, List<AnnotatedValueResolver>>> methods = AnnotatedBeanFactory.findMethods(beanFactoryId, resolvers);
        if (constructor.getValue().isEmpty() && fields.isEmpty() && methods.isEmpty()) {
            return null;
        }
        constructor.getKey().setAccessible(true);
        fields.forEach(field -> ((Field)field.getKey()).setAccessible(true));
        methods.forEach(method -> ((Method)method.getKey()).setAccessible(true));
        logger.debug("Registered a bean factory: {}", (Object)beanFactoryId);
        return resolverContext -> {
            try {
                Object[] constructorArgs = AnnotatedValueResolver.toArguments((List)constructor.getValue(), resolverContext);
                Object instance = ((Constructor)constructor.getKey()).newInstance(constructorArgs);
                for (Map.Entry field : fields) {
                    Object fieldArg = ((AnnotatedValueResolver)field.getValue()).resolve((AnnotatedValueResolver.ResolverContext)resolverContext);
                    ((Field)field.getKey()).set(instance, fieldArg);
                }
                for (Map.Entry method : methods) {
                    Object[] methodArgs = AnnotatedValueResolver.toArguments((List)method.getValue(), resolverContext);
                    ((Method)method.getKey()).invoke(instance, methodArgs);
                }
                return instance;
            }
            catch (Throwable cause) {
                throw new IllegalArgumentException("cannot instantiate a new object: " + beanFactoryId, cause);
            }
        };
    }

    @Nullable
    private static <T> Map.Entry<Constructor<T>, List<AnnotatedValueResolver>> findConstructor(BeanFactoryId beanFactoryId, List<AnnotatedValueResolver.RequestObjectResolver> objectResolvers) {
        AbstractMap.SimpleImmutableEntry<Constructor, List<Object>> candidate = null;
        Set<Constructor> constructors = ReflectionUtils.getConstructors(beanFactoryId.type, new Predicate[0]);
        for (Constructor constructor : constructors) {
            if (constructor.getParameterCount() == 0 && candidate == null) {
                candidate = new AbstractMap.SimpleImmutableEntry(constructor, ImmutableList.of());
                continue;
            }
            try {
                RequestConverter[] converters = (RequestConverter[])constructor.getAnnotationsByType(RequestConverter.class);
                List<AnnotatedValueResolver> resolvers = AnnotatedValueResolver.ofBeanConstructorOrMethod(constructor, beanFactoryId.pathParams, AnnotatedValueResolver.addToFirstIfExists(objectResolvers, converters));
                if (resolvers.isEmpty()) continue;
                if (candidate == null || ((List)candidate.getValue()).isEmpty()) {
                    candidate = new AbstractMap.SimpleImmutableEntry<Constructor, List<AnnotatedValueResolver>>(constructor, resolvers);
                    continue;
                }
                throw new IllegalArgumentException("too many annotated constructors in " + beanFactoryId.type.getSimpleName() + " (expected: 0 or 1)");
            }
            catch (AnnotatedValueResolver.NoAnnotatedParameterException noAnnotatedParameterException) {
            }
        }
        return candidate;
    }

    private static List<Map.Entry<Field, AnnotatedValueResolver>> findFields(BeanFactoryId beanFactoryId, List<AnnotatedValueResolver.RequestObjectResolver> objectResolvers) {
        ArrayList<Map.Entry<Field, AnnotatedValueResolver>> ret = new ArrayList<Map.Entry<Field, AnnotatedValueResolver>>();
        Set<Field> fields = ReflectionUtils.getAllFields(beanFactoryId.type, new Predicate[0]);
        for (Field field : fields) {
            RequestConverter[] converters = (RequestConverter[])field.getAnnotationsByType(RequestConverter.class);
            AnnotatedValueResolver.ofBeanField(field, beanFactoryId.pathParams, AnnotatedValueResolver.addToFirstIfExists(objectResolvers, converters)).ifPresent(resolver -> ret.add(new AbstractMap.SimpleImmutableEntry<Field, AnnotatedValueResolver>(field, (AnnotatedValueResolver)resolver)));
        }
        return ret;
    }

    private static List<Map.Entry<Method, List<AnnotatedValueResolver>>> findMethods(BeanFactoryId beanFactoryId, List<AnnotatedValueResolver.RequestObjectResolver> objectResolvers) {
        ArrayList<Map.Entry<Method, List<AnnotatedValueResolver>>> ret = new ArrayList<Map.Entry<Method, List<AnnotatedValueResolver>>>();
        Set<Method> methods = ReflectionUtils.getAllMethods(beanFactoryId.type, new Predicate[0]);
        for (Method method : methods) {
            RequestConverter[] converters = (RequestConverter[])method.getAnnotationsByType(RequestConverter.class);
            try {
                List<AnnotatedValueResolver> resolvers = AnnotatedValueResolver.ofBeanConstructorOrMethod(method, beanFactoryId.pathParams, AnnotatedValueResolver.addToFirstIfExists(objectResolvers, converters));
                if (resolvers.isEmpty()) continue;
                ret.add(new AbstractMap.SimpleImmutableEntry<Method, List<AnnotatedValueResolver>>(method, resolvers));
            }
            catch (AnnotatedValueResolver.NoAnnotatedParameterException noAnnotatedParameterException) {}
        }
        return ret;
    }

    private AnnotatedBeanFactory() {
    }

    static final class BeanFactoryId {
        private final Class<?> type;
        private final Set<String> pathParams;

        private BeanFactoryId(Class<?> type, Set<String> pathParams) {
            this.type = type;
            this.pathParams = ImmutableSortedSet.copyOf(pathParams);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || o.getClass() != this.getClass()) {
                return false;
            }
            BeanFactoryId that = (BeanFactoryId)o;
            return this.type == that.type && this.pathParams.equals(that.pathParams);
        }

        public int hashCode() {
            return Objects.hash(this.type, this.pathParams);
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("type", this.type.getName()).add("pathParams", this.pathParams).toString();
        }
    }
}

