/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server;

import com.linecorp.armeria.common.AggregatedHttpMessage;
import com.linecorp.armeria.common.FilteredHttpResponse;
import com.linecorp.armeria.common.Flags;
import com.linecorp.armeria.common.HttpObject;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.RequestContext;
import com.linecorp.armeria.common.util.Exceptions;
import com.linecorp.armeria.common.util.SafeCloseable;
import com.linecorp.armeria.internal.FallthroughException;
import com.linecorp.armeria.internal.PublisherToHttpResponseConverter;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.server.AnnotatedValueResolver;
import com.linecorp.armeria.server.HttpResponseException;
import com.linecorp.armeria.server.HttpService;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.annotation.ExceptionHandlerFunction;
import com.linecorp.armeria.server.annotation.ExceptionVerbosity;
import com.linecorp.armeria.server.annotation.ResponseConverterFunction;
import com.linecorp.armeria.server.annotation.ResponseConverterFunctionProvider;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class AnnotatedHttpService
implements HttpService {
    private static final Logger logger = LoggerFactory.getLogger(AnnotatedHttpService.class);
    static final ServiceLoader<ResponseConverterFunctionProvider> responseConverterFunctionProviders = ServiceLoader.load(ResponseConverterFunctionProvider.class, AnnotatedHttpService.class.getClassLoader());
    private final Object object;
    private final Method method;
    private final List<AnnotatedValueResolver> resolvers;
    private final AnnotatedValueResolver.AggregationStrategy aggregationStrategy;
    private final List<ExceptionHandlerFunction> exceptionHandlers;
    private final List<ResponseConverterFunction> responseConverters;
    @Nullable
    private final ResponseConverterFunction providedResponseConverter;
    private final ResponseType responseType;

    AnnotatedHttpService(Object object, Method method, List<AnnotatedValueResolver> resolvers, List<ExceptionHandlerFunction> exceptionHandlers, List<ResponseConverterFunction> responseConverters) {
        this.object = Objects.requireNonNull(object, "object");
        this.method = Objects.requireNonNull(method, "method");
        this.resolvers = Objects.requireNonNull(resolvers, "resolvers");
        this.exceptionHandlers = ImmutableList.copyOf((Collection)Objects.requireNonNull(exceptionHandlers, "exceptionHandlers"));
        this.responseConverters = ImmutableList.copyOf((Collection)Objects.requireNonNull(responseConverters, "responseConverters"));
        this.aggregationStrategy = AnnotatedValueResolver.AggregationStrategy.from(resolvers);
        this.providedResponseConverter = this.fromProvider(method);
        Class<?> returnType = method.getReturnType();
        this.responseType = this.providedResponseConverter != null ? ResponseType.HANDLED_BY_SPI : (HttpResponse.class.isAssignableFrom(returnType) ? ResponseType.HTTP_RESPONSE : (CompletionStage.class.isAssignableFrom(returnType) ? ResponseType.COMPLETION_STAGE : ResponseType.OTHER_OBJECTS));
        this.method.setAccessible(true);
    }

    @Nullable
    private ResponseConverterFunction fromProvider(Method method) {
        ParameterizedType p;
        Type returnType = method.getGenericReturnType();
        if (returnType instanceof ParameterizedType && Publisher.class.isAssignableFrom(AnnotatedHttpService.toClass((p = (ParameterizedType)returnType).getRawType())) && Publisher.class.isAssignableFrom(AnnotatedHttpService.toClass(p.getActualTypeArguments()[0]))) {
            throw new IllegalStateException("Invalid return type of method '" + method.getName() + "'. Cannot support '" + p.getActualTypeArguments()[0].getTypeName() + "' as a generic type of " + Publisher.class.getSimpleName());
        }
        for (ResponseConverterFunctionProvider provider : responseConverterFunctionProviders) {
            ResponseConverterFunction func = provider.createResponseConverterFunction(returnType, this::convertResponse, this::convertException);
            if (func == null) continue;
            return func;
        }
        return null;
    }

    private static Class<?> toClass(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return (Class)((ParameterizedType)type).getRawType();
        }
        return Void.class;
    }

    @Override
    public HttpResponse serve(ServiceRequestContext ctx, HttpRequest req) throws Exception {
        return HttpResponse.from(this.serve0(ctx, req));
    }

    public CompletionStage<HttpResponse> serve0(ServiceRequestContext ctx, HttpRequest req) {
        CompletableFuture<AggregatedHttpMessage> f = AnnotatedValueResolver.AggregationStrategy.aggregationRequired(this.aggregationStrategy, req) ? req.aggregate() : CompletableFuture.completedFuture(null);
        switch (this.responseType) {
            case HANDLED_BY_SPI: {
                return f.thenApply(msg -> {
                    try {
                        Object obj = this.invoke(ctx, req, (AggregatedHttpMessage)msg);
                        if (obj instanceof HttpResponse) {
                            return (HttpResponse)obj;
                        }
                        assert (this.providedResponseConverter != null);
                        return new ExceptionFilteredHttpResponse(ctx, req, this.providedResponseConverter.convertResponse(ctx, obj));
                    }
                    catch (Throwable cause) {
                        return this.convertException(ctx, req, cause);
                    }
                });
            }
            case HTTP_RESPONSE: {
                return f.thenApply(msg -> new ExceptionFilteredHttpResponse(ctx, req, (HttpResponse)this.invoke(ctx, req, (AggregatedHttpMessage)msg)));
            }
            case COMPLETION_STAGE: {
                return ((CompletableFuture)f.thenCompose(msg -> AnnotatedHttpService.toCompletionStage(this.invoke(ctx, req, (AggregatedHttpMessage)msg)))).handle((result, cause) -> cause == null ? this.convertResponse(ctx, req, result) : this.convertException(ctx, req, (Throwable)cause));
            }
        }
        return f.thenApplyAsync(msg -> this.convertResponse(ctx, req, this.invoke(ctx, req, (AggregatedHttpMessage)msg)), (Executor)ctx.blockingTaskExecutor());
    }

    private Object invoke(ServiceRequestContext ctx, HttpRequest req, @Nullable AggregatedHttpMessage message) {
        Object object;
        block8: {
            SafeCloseable ignored = ctx.push(false);
            Throwable throwable = null;
            try {
                AnnotatedValueResolver.ResolverContext resolverContext = new AnnotatedValueResolver.ResolverContext(ctx, req, message);
                Object[] arguments = AnnotatedValueResolver.toArguments(this.resolvers, resolverContext);
                object = this.method.invoke(this.object, arguments);
                if (ignored == null) break block8;
            }
            catch (Throwable throwable2) {
                try {
                    try {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (ignored != null) {
                            AnnotatedHttpService.$closeResource(throwable, ignored);
                        }
                        throw throwable3;
                    }
                }
                catch (Throwable cause) {
                    return this.convertException(ctx, req, cause);
                }
            }
            AnnotatedHttpService.$closeResource(throwable, ignored);
        }
        return object;
    }

    private HttpResponse convertResponse(ServiceRequestContext ctx, HttpRequest req, @Nullable Object result) {
        if (result instanceof HttpResponse) {
            return (HttpResponse)result;
        }
        if (result instanceof AggregatedHttpMessage) {
            return HttpResponse.of((AggregatedHttpMessage)result);
        }
        if (result instanceof Publisher) {
            CompletableFuture<HttpResponse> future = new CompletableFuture<HttpResponse>();
            Publisher publisher = (Publisher)result;
            publisher.subscribe((Subscriber)new PublisherToHttpResponseConverter(ctx, req, future, this::convertResponse, this::convertException));
            return HttpResponse.from(future);
        }
        return this.convertResponse(ctx, result);
    }

    /*
     * Exception decompiling
     */
    private HttpResponse convertResponse(ServiceRequestContext ctx, @Nullable Object result) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private HttpResponse convertException(RequestContext ctx, HttpRequest req, Throwable cause) {
        Throwable peeledCause = Exceptions.peel(cause);
        if (Flags.annotatedServiceExceptionVerbosity() == ExceptionVerbosity.ALL && logger.isWarnEnabled()) {
            logger.warn("{} Exception raised by method '{}' in '{}':", new Object[]{ctx, this.method.getName(), this.object.getClass().getSimpleName(), peeledCause});
        }
        for (ExceptionHandlerFunction func : this.exceptionHandlers) {
            try {
                HttpResponse response = func.handleException(ctx, req, peeledCause);
                if (response != null) {
                    return response;
                }
                break;
            }
            catch (FallthroughException response) {
            }
            catch (Exception e) {
                logger.warn("{} Unexpected exception from an exception handler {}:", new Object[]{ctx, func.getClass().getName(), e});
            }
        }
        return HttpResponse.of(HttpStatus.INTERNAL_SERVER_ERROR);
    }

    private static CompletionStage<?> toCompletionStage(Object obj) {
        if (obj instanceof CompletionStage) {
            return (CompletionStage)obj;
        }
        return CompletableFuture.completedFuture(obj);
    }

    private static /* synthetic */ /* end resource */ void $closeResource(Throwable x0, AutoCloseable x1) {
        if (x0 != null) {
            try {
                x1.close();
            }
            catch (Throwable throwable) {
                x0.addSuppressed(throwable);
            }
        } else {
            x1.close();
        }
    }

    private static enum ResponseType {
        HANDLED_BY_SPI,
        HTTP_RESPONSE,
        COMPLETION_STAGE,
        OTHER_OBJECTS;

    }

    private class ExceptionFilteredHttpResponse
    extends FilteredHttpResponse {
        private final ServiceRequestContext ctx;
        private final HttpRequest req;

        ExceptionFilteredHttpResponse(ServiceRequestContext ctx, HttpRequest req, HttpResponse delegate) {
            super(delegate);
            this.ctx = ctx;
            this.req = req;
        }

        @Override
        protected HttpObject filter(HttpObject obj) {
            return obj;
        }

        @Override
        protected Throwable beforeError(Subscriber<? super HttpObject> subscriber, Throwable cause) {
            return HttpResponseException.of(AnnotatedHttpService.this.convertException(this.ctx, this.req, cause));
        }
    }
}

