/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server;

import com.linecorp.armeria.common.HttpMethod;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.internal.ArmeriaHttpUtil;
import com.linecorp.armeria.internal.DefaultValues;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableMap;
import com.linecorp.armeria.internal.shaded.guava.collect.Sets;
import com.linecorp.armeria.server.AbstractPathMapping;
import com.linecorp.armeria.server.AnnotatedHttpService;
import com.linecorp.armeria.server.AnnotatedValueResolver;
import com.linecorp.armeria.server.DecoratingServiceFunction;
import com.linecorp.armeria.server.DefaultExceptionHandler;
import com.linecorp.armeria.server.ExactPathMapping;
import com.linecorp.armeria.server.FunctionalDecoratingService;
import com.linecorp.armeria.server.GlobPathMapping;
import com.linecorp.armeria.server.HttpHeaderPathMapping;
import com.linecorp.armeria.server.PathMapping;
import com.linecorp.armeria.server.PathMappingContext;
import com.linecorp.armeria.server.PathMappingResult;
import com.linecorp.armeria.server.PrefixPathMapping;
import com.linecorp.armeria.server.RegexPathMapping;
import com.linecorp.armeria.server.Service;
import com.linecorp.armeria.server.annotation.ByteArrayResponseConverterFunction;
import com.linecorp.armeria.server.annotation.ConsumeType;
import com.linecorp.armeria.server.annotation.ConsumeTypes;
import com.linecorp.armeria.server.annotation.Consumes;
import com.linecorp.armeria.server.annotation.ConsumesGroup;
import com.linecorp.armeria.server.annotation.Decorator;
import com.linecorp.armeria.server.annotation.DecoratorFactory;
import com.linecorp.armeria.server.annotation.DecoratorFactoryFunction;
import com.linecorp.armeria.server.annotation.Decorators;
import com.linecorp.armeria.server.annotation.Delete;
import com.linecorp.armeria.server.annotation.ExceptionHandler;
import com.linecorp.armeria.server.annotation.ExceptionHandlerFunction;
import com.linecorp.armeria.server.annotation.Get;
import com.linecorp.armeria.server.annotation.Head;
import com.linecorp.armeria.server.annotation.JacksonResponseConverterFunction;
import com.linecorp.armeria.server.annotation.Options;
import com.linecorp.armeria.server.annotation.Order;
import com.linecorp.armeria.server.annotation.Patch;
import com.linecorp.armeria.server.annotation.Path;
import com.linecorp.armeria.server.annotation.Post;
import com.linecorp.armeria.server.annotation.ProduceType;
import com.linecorp.armeria.server.annotation.ProduceTypes;
import com.linecorp.armeria.server.annotation.Produces;
import com.linecorp.armeria.server.annotation.ProducesGroup;
import com.linecorp.armeria.server.annotation.Put;
import com.linecorp.armeria.server.annotation.RequestConverter;
import com.linecorp.armeria.server.annotation.RequestConverterFunction;
import com.linecorp.armeria.server.annotation.RequestObject;
import com.linecorp.armeria.server.annotation.ResponseConverter;
import com.linecorp.armeria.server.annotation.ResponseConverterFunction;
import com.linecorp.armeria.server.annotation.StringResponseConverterFunction;
import com.linecorp.armeria.server.annotation.Trace;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class AnnotatedHttpServiceFactory {
    private static final Logger logger = LoggerFactory.getLogger(AnnotatedHttpServiceFactory.class);
    private static final ConcurrentMap<Class<?>, Object> instanceCache = new ConcurrentHashMap();
    private static final List<ResponseConverterFunction> defaultResponseConverters = ImmutableList.of(new JacksonResponseConverterFunction(), new StringResponseConverterFunction(), new ByteArrayResponseConverterFunction());
    private static final ExceptionHandlerFunction defaultExceptionHandler = new DefaultExceptionHandler();
    private static final Map<Class<?>, HttpMethod> HTTP_METHOD_MAP = ImmutableMap.builder().put(Options.class, HttpMethod.OPTIONS).put(Get.class, HttpMethod.GET).put(Head.class, HttpMethod.HEAD).put(Post.class, HttpMethod.POST).put(Put.class, HttpMethod.PUT).put(Patch.class, HttpMethod.PATCH).put(Delete.class, HttpMethod.DELETE).put(Trace.class, HttpMethod.TRACE).build();

    static List<AnnotatedHttpServiceElement> find(String pathPrefix, Object object, Iterable<?> exceptionHandlersAndConverters) {
        ImmutableList.Builder exceptionHandlers = null;
        ImmutableList.Builder requestConverters = null;
        ImmutableList.Builder responseConverters = null;
        for (Object o : exceptionHandlersAndConverters) {
            boolean added = false;
            if (o instanceof ExceptionHandlerFunction) {
                if (exceptionHandlers == null) {
                    exceptionHandlers = ImmutableList.builder();
                }
                exceptionHandlers.add((ExceptionHandlerFunction)o);
                added = true;
            }
            if (o instanceof RequestConverterFunction) {
                if (requestConverters == null) {
                    requestConverters = ImmutableList.builder();
                }
                requestConverters.add((RequestConverterFunction)o);
                added = true;
            }
            if (o instanceof ResponseConverterFunction) {
                if (responseConverters == null) {
                    responseConverters = ImmutableList.builder();
                }
                responseConverters.add((ResponseConverterFunction)o);
                added = true;
            }
            if (added) continue;
            throw new IllegalArgumentException(o.getClass().getName() + " is neither an exception handler nor a converter.");
        }
        ImmutableList exceptionHandlerFunctions = exceptionHandlers != null ? exceptionHandlers.build() : ImmutableList.of();
        ImmutableList requestConverterFunctions = requestConverters != null ? requestConverters.build() : ImmutableList.of();
        ImmutableList responseConverterFunctions = responseConverters != null ? responseConverters.build() : ImmutableList.of();
        List<Method> methods = AnnotatedHttpServiceFactory.requestMappingMethods(object);
        return methods.stream().map(method -> AnnotatedHttpServiceFactory.create(pathPrefix, object, method, exceptionHandlerFunctions, requestConverterFunctions, responseConverterFunctions)).collect(ImmutableList.toImmutableList());
    }

    private static AnnotatedHttpServiceElement create(String pathPrefix, Object object, Method method, List<ExceptionHandlerFunction> baseExceptionHandlers, List<RequestConverterFunction> baseRequestConverters, List<ResponseConverterFunction> baseResponseConverters) {
        List<Object> resolvers;
        Set<Annotation> methodAnnotations = AnnotatedHttpServiceFactory.httpMethodAnnotations(method);
        if (methodAnnotations.isEmpty()) {
            throw new IllegalArgumentException("HTTP Method specification is missing: " + method.getName());
        }
        Set<HttpMethod> methods = AnnotatedHttpServiceFactory.toHttpMethods(methodAnnotations);
        if (methods.isEmpty()) {
            throw new IllegalArgumentException(method.getDeclaringClass().getName() + '#' + method.getName() + " must have an HTTP method annotation.");
        }
        Class<?> clazz = object.getClass();
        HttpHeaderPathMapping pathMapping = new HttpHeaderPathMapping(AnnotatedHttpServiceFactory.pathStringMapping(pathPrefix, method, methodAnnotations), methods, AnnotatedHttpServiceFactory.consumableMediaTypes(method, clazz), AnnotatedHttpServiceFactory.producibleMediaTypes(method, clazz));
        ImmutableList<ExceptionHandlerFunction> eh = ((ImmutableList.Builder)((ImmutableList.Builder)AnnotatedHttpServiceFactory.exceptionHandlers(method, clazz).addAll(baseExceptionHandlers)).add(defaultExceptionHandler)).build();
        ImmutableList<RequestConverterFunction> req = ((ImmutableList.Builder)AnnotatedHttpServiceFactory.requestConverters(method, clazz).addAll(baseRequestConverters)).build();
        ImmutableList<ResponseConverterFunction> res = ((ImmutableList.Builder)((ImmutableList.Builder)AnnotatedHttpServiceFactory.responseConverters(method, clazz).addAll(baseResponseConverters)).addAll(defaultResponseConverters)).build();
        try {
            resolvers = AnnotatedValueResolver.ofServiceMethod(method, pathMapping.paramNames(), AnnotatedValueResolver.toRequestObjectResolvers(req));
        }
        catch (AnnotatedValueResolver.NoParameterException ignored) {
            resolvers = ImmutableList.of();
        }
        Set<String> expectedParamNames = pathMapping.paramNames();
        Set requiredParamNames = resolvers.stream().filter(AnnotatedValueResolver::isPathVariable).map(AnnotatedValueResolver::httpElementName).collect(Collectors.toSet());
        if (!expectedParamNames.containsAll(requiredParamNames)) {
            Sets.SetView missing = Sets.difference(requiredParamNames, expectedParamNames);
            throw new IllegalArgumentException("cannot find path variables: " + missing);
        }
        if (resolvers.stream().noneMatch(r -> r.annotationType() == RequestObject.class) && !requiredParamNames.containsAll(expectedParamNames)) {
            Sets.SetView<String> missing = Sets.difference(expectedParamNames, requiredParamNames);
            logger.warn("Some path variables of the method '" + method.getName() + "' of the class '" + clazz.getName() + "' do not have their corresponding parameters annotated with @Param. They would not be automatically injected: " + missing);
        }
        return new AnnotatedHttpServiceElement(pathMapping, new AnnotatedHttpService(object, method, resolvers, eh, res), AnnotatedHttpServiceFactory.decorator(method, clazz));
    }

    private static List<Method> requestMappingMethods(Object object) {
        return Arrays.stream(object.getClass().getMethods()).filter(m -> m.getAnnotation(Path.class) != null || !AnnotatedHttpServiceFactory.httpMethodAnnotations(m).isEmpty()).sorted(Comparator.comparingInt(AnnotatedHttpServiceFactory::order)).collect(ImmutableList.toImmutableList());
    }

    private static int order(Method method) {
        Order order = method.getAnnotation(Order.class);
        return order != null ? order.value() : 0;
    }

    private static Set<Annotation> httpMethodAnnotations(Method method) {
        return Arrays.stream(method.getAnnotations()).filter(annotation -> HTTP_METHOD_MAP.containsKey(annotation.annotationType())).collect(Collectors.toSet());
    }

    private static Set<HttpMethod> toHttpMethods(Set<Annotation> annotations) {
        return annotations.stream().map(annotation -> HTTP_METHOD_MAP.get(annotation.annotationType())).filter(Objects::nonNull).collect(Sets.toImmutableEnumSet());
    }

    private static List<MediaType> consumableMediaTypes(Method method, Class<?> clazz) {
        List<MediaType> mediaTypes = AnnotatedHttpServiceFactory.consumableMediaTypes(method);
        return mediaTypes.isEmpty() ? AnnotatedHttpServiceFactory.consumableMediaTypes(clazz) : mediaTypes;
    }

    private static List<MediaType> consumableMediaTypes(AnnotatedElement element) {
        ArrayList<MediaType> mediaTypes = new ArrayList<MediaType>();
        for (Annotation annotation : element.getAnnotations()) {
            if (annotation instanceof ConsumesGroup) {
                Arrays.stream(((ConsumesGroup)annotation).value()).forEach(e -> AnnotatedHttpServiceFactory.addConsumableMediaType(mediaTypes, MediaType.parse(e.value())));
                continue;
            }
            if (annotation instanceof Consumes) {
                AnnotatedHttpServiceFactory.addConsumableMediaType(mediaTypes, MediaType.parse(((Consumes)annotation).value()));
                continue;
            }
            if (annotation instanceof ConsumeTypes) {
                Arrays.stream(((ConsumeTypes)annotation).value()).forEach(e -> AnnotatedHttpServiceFactory.addConsumableMediaType(mediaTypes, MediaType.parse(e.value())));
                continue;
            }
            if (annotation instanceof ConsumeType) {
                AnnotatedHttpServiceFactory.addConsumableMediaType(mediaTypes, MediaType.parse(((ConsumeType)annotation).value()));
                continue;
            }
            Arrays.stream((Consumes[])annotation.annotationType().getAnnotationsByType(Consumes.class)).forEach(e -> AnnotatedHttpServiceFactory.addConsumableMediaType(mediaTypes, MediaType.parse(e.value())));
        }
        return mediaTypes;
    }

    private static void addConsumableMediaType(List<MediaType> mediaTypes, MediaType newMediaType) {
        AnnotatedHttpServiceFactory.addMediaType(mediaTypes, newMediaType, Consumes.class, true);
    }

    private static List<MediaType> producibleMediaTypes(Method method, Class<?> clazz) {
        List<MediaType> mediaTypes = AnnotatedHttpServiceFactory.producibleMediaTypes(method);
        return mediaTypes.isEmpty() ? AnnotatedHttpServiceFactory.producibleMediaTypes(clazz) : mediaTypes;
    }

    private static List<MediaType> producibleMediaTypes(AnnotatedElement element) {
        ArrayList<MediaType> mediaTypes = new ArrayList<MediaType>();
        for (Annotation annotation : element.getAnnotations()) {
            if (annotation instanceof ProducesGroup) {
                Arrays.stream(((ProducesGroup)annotation).value()).forEach(e -> AnnotatedHttpServiceFactory.addProducibleMediaType(mediaTypes, MediaType.parse(e.value())));
                continue;
            }
            if (annotation instanceof Produces) {
                AnnotatedHttpServiceFactory.addProducibleMediaType(mediaTypes, MediaType.parse(((Produces)annotation).value()));
                continue;
            }
            if (annotation instanceof ProduceTypes) {
                Arrays.stream(((ProduceTypes)annotation).value()).forEach(e -> AnnotatedHttpServiceFactory.addProducibleMediaType(mediaTypes, MediaType.parse(e.value())));
                continue;
            }
            if (annotation instanceof ProduceType) {
                AnnotatedHttpServiceFactory.addProducibleMediaType(mediaTypes, MediaType.parse(((ProduceType)annotation).value()));
                continue;
            }
            Arrays.stream((Produces[])annotation.annotationType().getAnnotationsByType(Produces.class)).forEach(e -> AnnotatedHttpServiceFactory.addProducibleMediaType(mediaTypes, MediaType.parse(e.value())));
        }
        return mediaTypes;
    }

    private static void addProducibleMediaType(List<MediaType> mediaTypes, MediaType newMediaType) {
        AnnotatedHttpServiceFactory.addMediaType(mediaTypes, newMediaType, Produces.class, false);
    }

    private static void addMediaType(List<MediaType> mediaTypes, MediaType newMediaType, Class<?> clazz, boolean allowWildcard) {
        if (!allowWildcard && newMediaType.hasWildcard()) {
            throw new IllegalArgumentException('@' + clazz.getSimpleName() + " must not have a wildcard: " + newMediaType);
        }
        if (mediaTypes.stream().anyMatch(e -> e.equals(newMediaType))) {
            throw new IllegalArgumentException("Duplicated media type for @" + clazz.getSimpleName() + ": " + newMediaType);
        }
        mediaTypes.add(newMediaType);
    }

    private static PathMapping pathStringMapping(String pathPrefix, Method method, Set<Annotation> methodAnnotations) {
        if (!(pathPrefix = AbstractPathMapping.ensureAbsolutePath(pathPrefix, "pathPrefix")).endsWith("/")) {
            pathPrefix = pathPrefix + '/';
        }
        String pattern = AnnotatedHttpServiceFactory.findPattern(method, methodAnnotations);
        PathMapping mapping = PathMapping.of(pattern);
        if ("/".equals(pathPrefix)) {
            return mapping;
        }
        if (pattern.startsWith("exact:")) {
            return PathMapping.ofExact(ArmeriaHttpUtil.concatPaths(pathPrefix, pattern.substring(ExactPathMapping.PREFIX_LEN)));
        }
        if (pattern.startsWith("prefix:")) {
            return PathMapping.ofPrefix(ArmeriaHttpUtil.concatPaths(pathPrefix, pattern.substring(PrefixPathMapping.PREFIX_LEN)));
        }
        if (pattern.startsWith("glob:")) {
            String glob = pattern.substring(GlobPathMapping.PREFIX_LEN);
            if (glob.startsWith("/")) {
                return PathMapping.ofGlob(ArmeriaHttpUtil.concatPaths(pathPrefix, glob));
            }
            return new PrefixAddingPathMapping(pathPrefix, mapping);
        }
        if (pattern.startsWith("regex:")) {
            return new PrefixAddingPathMapping(pathPrefix, mapping);
        }
        if (pattern.startsWith("/")) {
            return PathMapping.of(ArmeriaHttpUtil.concatPaths(pathPrefix, pattern));
        }
        throw new Error();
    }

    private static String findPattern(Method method, Set<Annotation> methodAnnotations) {
        String pattern = null;
        Path path = method.getAnnotation(Path.class);
        if (path != null) {
            pattern = method.getAnnotation(Path.class).value();
        }
        for (Annotation a : methodAnnotations) {
            String p = (String)AnnotatedHttpServiceFactory.invokeValueMethod(a);
            if (DefaultValues.isUnspecified(p)) continue;
            Preconditions.checkArgument(pattern == null, "Only one path can be specified. (" + pattern + ", " + p + ')');
            pattern = p;
        }
        if (pattern == null || pattern.isEmpty()) {
            throw new IllegalArgumentException("A path pattern should be specified by @Path or HTTP method annotations.");
        }
        return pattern;
    }

    private static Function<Service<HttpRequest, HttpResponse>, ? extends Service<HttpRequest, HttpResponse>> decorator(Method method, Class<?> clazz) {
        List<DecoratorAndOrder> decorators = AnnotatedHttpServiceFactory.collectDecorators(clazz, method);
        Function<Service<HttpRequest, HttpResponse>, ? extends Service<HttpRequest, HttpResponse>> decorator = null;
        for (int i = decorators.size() - 1; i >= 0; --i) {
            DecoratorAndOrder d = decorators.get(i);
            decorator = decorator == null ? d.decorator() : decorator.andThen(d.decorator());
        }
        return decorator == null ? Function.identity() : decorator;
    }

    static List<DecoratorAndOrder> collectDecorators(Class<?> clazz, Method method) {
        ArrayList<DecoratorAndOrder> decorators = new ArrayList<DecoratorAndOrder>();
        AnnotatedHttpServiceFactory.collectDecorators(decorators, clazz.getAnnotations());
        AnnotatedHttpServiceFactory.collectDecorators(decorators, method.getAnnotations());
        decorators.sort(Comparator.comparing(DecoratorAndOrder::order));
        return decorators;
    }

    private static void collectDecorators(List<DecoratorAndOrder> list, Annotation[] annotations) {
        if (annotations.length == 0) {
            return;
        }
        for (Annotation annotation : annotations) {
            if (annotation instanceof Decorator) {
                Decorator d = (Decorator)annotation;
                list.add(new DecoratorAndOrder(d, AnnotatedHttpServiceFactory.newDecorator(d), d.order()));
                continue;
            }
            if (annotation instanceof Decorators) {
                Decorator[] decorators;
                for (Decorator d : decorators = ((Decorators)annotation).value()) {
                    list.add(new DecoratorAndOrder(d, AnnotatedHttpServiceFactory.newDecorator(d), d.order()));
                }
                continue;
            }
            DecoratorAndOrder udd = AnnotatedHttpServiceFactory.userDefinedDecorator(annotation);
            if (udd != null) {
                list.add(udd);
                continue;
            }
            try {
                Annotation decorator;
                Annotation[] decorators;
                Annotation[] annotationArray = decorators = (Annotation[])annotation.annotationType().getMethod("value", new Class[0]).invoke((Object)annotation, new Object[0]);
                int n = annotationArray.length;
                for (int i = 0; i < n && (udd = AnnotatedHttpServiceFactory.userDefinedDecorator(decorator = annotationArray[i])) != null; ++i) {
                    list.add(udd);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @Nullable
    private static DecoratorAndOrder userDefinedDecorator(Annotation annotation) {
        DecoratorFactory d = annotation.annotationType().getAnnotation(DecoratorFactory.class);
        if (d == null) {
            return null;
        }
        DecoratorFactoryFunction factory = AnnotatedHttpServiceFactory.getInstance(d, DecoratorFactoryFunction.class);
        int order = 0;
        try {
            Object value = annotation.annotationType().getMethod("order", new Class[0]).invoke((Object)annotation, new Object[0]);
            if (value instanceof Integer) {
                order = (Integer)value;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return new DecoratorAndOrder(annotation, factory.newDecorator(annotation), order);
    }

    private static Function<Service<HttpRequest, HttpResponse>, ? extends Service<HttpRequest, HttpResponse>> newDecorator(Decorator decorator) {
        return service -> new FunctionalDecoratingService(service, AnnotatedHttpServiceFactory.getInstance(decorator, DecoratingServiceFunction.class));
    }

    private static ImmutableList.Builder<ExceptionHandlerFunction> exceptionHandlers(Method targetMethod, Class<?> targetClass) {
        return AnnotatedHttpServiceFactory.annotationValues(targetMethod, targetClass, ExceptionHandler.class, ExceptionHandlerFunction.class);
    }

    private static ImmutableList.Builder<RequestConverterFunction> requestConverters(Method targetMethod, Class<?> targetClass) {
        return AnnotatedHttpServiceFactory.annotationValues(targetMethod, targetClass, RequestConverter.class, RequestConverterFunction.class);
    }

    private static ImmutableList.Builder<ResponseConverterFunction> responseConverters(Method targetMethod, Class<?> targetClass) {
        return AnnotatedHttpServiceFactory.annotationValues(targetMethod, targetClass, ResponseConverter.class, ResponseConverterFunction.class);
    }

    private static <T extends Annotation, R> ImmutableList.Builder<R> annotationValues(Method targetMethod, Class<?> targetClass, Class<T> annotationClass, Class<R> expectedType) {
        Objects.requireNonNull(annotationClass, "annotationClass");
        Objects.requireNonNull(targetMethod, "targetMethod");
        Objects.requireNonNull(targetClass, "targetClass");
        ImmutableList.Builder builder = new ImmutableList.Builder();
        for (Annotation annotation : targetMethod.getAnnotationsByType(annotationClass)) {
            builder.add(AnnotatedHttpServiceFactory.getInstance(annotation, expectedType));
        }
        for (Annotation annotation : targetClass.getAnnotationsByType(annotationClass)) {
            builder.add(AnnotatedHttpServiceFactory.getInstance(annotation, expectedType));
        }
        return builder;
    }

    static <T> T getInstance(Annotation annotation, Class<T> expectedType) {
        try {
            Class clazz = (Class)AnnotatedHttpServiceFactory.invokeValueMethod(annotation);
            return expectedType.cast(instanceCache.computeIfAbsent(clazz, type -> {
                try {
                    Constructor constructor = clazz.getDeclaredConstructor(new Class[0]);
                    constructor.setAccessible(true);
                    return constructor.newInstance(new Object[0]);
                }
                catch (Exception e) {
                    throw new IllegalStateException("A class specified in @" + annotation.getClass().getSimpleName() + " annotation must have an accessible default constructor: " + clazz.getName(), e);
                }
            }));
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("A class specified in @" + annotation.getClass().getSimpleName() + " annotation cannot be cast to " + expectedType, e);
        }
    }

    static <T> T getInstance(Class<T> clazz) {
        return (T)instanceCache.computeIfAbsent(clazz, type -> {
            try {
                Constructor constructor = clazz.getDeclaredConstructor(new Class[0]);
                constructor.setAccessible(true);
                return constructor.newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new IllegalStateException("A class must have an accessible default constructor: " + clazz.getName(), e);
            }
        });
    }

    private static Object invokeValueMethod(Annotation a) {
        try {
            return a.getClass().getMethod("value", new Class[0]).invoke((Object)a, new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalStateException("An annotation @" + a.getClass().getSimpleName() + " must have a 'value' method", e);
        }
    }

    private AnnotatedHttpServiceFactory() {
    }

    static final class AnnotatedHttpServiceElement {
        private final PathMapping pathMapping;
        private final AnnotatedHttpService service;
        private final Function<Service<HttpRequest, HttpResponse>, ? extends Service<HttpRequest, HttpResponse>> decorator;

        private AnnotatedHttpServiceElement(PathMapping pathMapping, AnnotatedHttpService service, Function<Service<HttpRequest, HttpResponse>, ? extends Service<HttpRequest, HttpResponse>> decorator) {
            this.pathMapping = Objects.requireNonNull(pathMapping, "pathMapping");
            this.service = Objects.requireNonNull(service, "service");
            this.decorator = Objects.requireNonNull(decorator, "decorator");
        }

        PathMapping pathMapping() {
            return this.pathMapping;
        }

        AnnotatedHttpService service() {
            return this.service;
        }

        Function<Service<HttpRequest, HttpResponse>, ? extends Service<HttpRequest, HttpResponse>> decorator() {
            return this.decorator;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("pathMapping", this.pathMapping()).add("service", this.service()).add("decorator", this.decorator()).toString();
        }
    }

    static final class DecoratorAndOrder {
        private final Annotation annotation;
        private final Function<Service<HttpRequest, HttpResponse>, ? extends Service<HttpRequest, HttpResponse>> decorator;
        private final int order;

        private DecoratorAndOrder(Annotation annotation, Function<Service<HttpRequest, HttpResponse>, ? extends Service<HttpRequest, HttpResponse>> decorator, int order) {
            this.annotation = annotation;
            this.decorator = decorator;
            this.order = order;
        }

        Annotation annotation() {
            return this.annotation;
        }

        Function<Service<HttpRequest, HttpResponse>, ? extends Service<HttpRequest, HttpResponse>> decorator() {
            return this.decorator;
        }

        int order() {
            return this.order;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("annotation", this.annotation()).add("decorator", this.decorator()).add("order", this.order()).toString();
        }
    }

    static final class PrefixAddingPathMapping
    extends AbstractPathMapping {
        private final String pathPrefix;
        private final PathMapping mapping;
        private final String loggerName;
        private final String meterTag;

        PrefixAddingPathMapping(String pathPrefix, PathMapping mapping) {
            assert (mapping instanceof GlobPathMapping || mapping instanceof RegexPathMapping) : "unexpected mapping type: " + mapping.getClass().getName();
            this.pathPrefix = pathPrefix;
            this.mapping = mapping;
            this.loggerName = PrefixAddingPathMapping.loggerName(pathPrefix) + '.' + mapping.loggerName();
            this.meterTag = "prefix:" + pathPrefix + ',' + mapping.meterTag();
        }

        @Override
        protected PathMappingResult doApply(PathMappingContext mappingCtx) {
            String path = mappingCtx.path();
            if (!path.startsWith(this.pathPrefix)) {
                return PathMappingResult.empty();
            }
            PathMappingResult result = this.mapping.apply(mappingCtx.overridePath(path.substring(this.pathPrefix.length() - 1)));
            if (result.isPresent()) {
                return PathMappingResult.of(path, mappingCtx.query(), result.pathParams());
            }
            return PathMappingResult.empty();
        }

        @Override
        public Set<String> paramNames() {
            return this.mapping.paramNames();
        }

        @Override
        public String loggerName() {
            return this.loggerName;
        }

        @Override
        public String meterTag() {
            return this.meterTag;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof PrefixAddingPathMapping)) {
                return false;
            }
            PrefixAddingPathMapping that = (PrefixAddingPathMapping)o;
            return this.pathPrefix.equals(that.pathPrefix) && this.mapping.equals(that.mapping);
        }

        public int hashCode() {
            return 31 * this.pathPrefix.hashCode() + this.mapping.hashCode();
        }

        public String toString() {
            return "[prefix:" + this.pathPrefix + ", " + this.mapping + ']';
        }
    }
}

