/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server;

import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

final class AnnotatedHttpServiceTypeUtil {
    private static final Map<Class<?>, Function<String, ?>> supportedElementTypes = ImmutableMap.builder().put(Byte.TYPE, Byte::valueOf).put(Byte.class, Byte::valueOf).put(Short.TYPE, Short::valueOf).put(Short.class, Short::valueOf).put(Boolean.TYPE, Boolean::valueOf).put(Boolean.class, Boolean::valueOf).put(Integer.TYPE, Integer::valueOf).put(Integer.class, Integer::valueOf).put(Long.TYPE, Long::valueOf).put(Long.class, Long::valueOf).put(Float.TYPE, Float::valueOf).put(Float.class, Float::valueOf).put(Double.TYPE, Double::valueOf).put(Double.class, Double::valueOf).put(String.class, Function.identity()).build();

    static Class<?> normalizeContainerType(Class<?> containerType) {
        if (containerType == Iterable.class || containerType == List.class || containerType == Collection.class) {
            return ArrayList.class;
        }
        if (containerType == Set.class) {
            return LinkedHashSet.class;
        }
        if (List.class.isAssignableFrom(containerType) || Set.class.isAssignableFrom(containerType)) {
            try {
                containerType.getConstructor(new Class[0]);
                return containerType;
            }
            catch (Throwable cause) {
                throw new IllegalArgumentException("Unsupported container type: " + containerType.getName(), cause);
            }
        }
        throw new IllegalArgumentException("Unsupported container type: " + containerType.getName());
    }

    static Class<?> validateElementType(Class<?> clazz) {
        if (clazz.isEnum()) {
            return clazz;
        }
        if (supportedElementTypes.containsKey(clazz)) {
            return clazz;
        }
        throw new IllegalArgumentException("Parameter type '" + clazz.getName() + "' is not supported.");
    }

    static <T> T stringToType(String str, Class<T> clazz) {
        try {
            Function<String, ?> func = supportedElementTypes.get(clazz);
            if (func != null) {
                return (T)func.apply(str);
            }
        }
        catch (NumberFormatException e) {
            throw e;
        }
        catch (Throwable cause) {
            throw new IllegalArgumentException("Can't convert '" + str + "' to type '" + clazz.getSimpleName() + "'.", cause);
        }
        throw new IllegalArgumentException("Can't convert '" + str + "' to type '" + clazz.getSimpleName() + "'.");
    }

    private AnnotatedHttpServiceTypeUtil() {
    }
}

