/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server;

import com.linecorp.armeria.common.AggregatedHttpMessage;
import com.linecorp.armeria.common.HttpHeaderNames;
import com.linecorp.armeria.common.HttpParameters;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.common.Request;
import com.linecorp.armeria.common.RequestContext;
import com.linecorp.armeria.common.util.Exceptions;
import com.linecorp.armeria.internal.DefaultValues;
import com.linecorp.armeria.internal.FallthroughException;
import com.linecorp.armeria.internal.shaded.guava.base.Ascii;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableMap;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableSet;
import com.linecorp.armeria.internal.shaded.guava.collect.MapMaker;
import com.linecorp.armeria.server.AnnotatedBeanFactory;
import com.linecorp.armeria.server.AnnotatedElementNameUtil;
import com.linecorp.armeria.server.AnnotatedHttpServiceFactory;
import com.linecorp.armeria.server.AnnotatedHttpServiceTypeUtil;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.annotation.ByteArrayRequestConverterFunction;
import com.linecorp.armeria.server.annotation.Cookies;
import com.linecorp.armeria.server.annotation.Default;
import com.linecorp.armeria.server.annotation.Header;
import com.linecorp.armeria.server.annotation.JacksonRequestConverterFunction;
import com.linecorp.armeria.server.annotation.Param;
import com.linecorp.armeria.server.annotation.RequestConverter;
import com.linecorp.armeria.server.annotation.RequestConverterFunction;
import com.linecorp.armeria.server.annotation.RequestObject;
import com.linecorp.armeria.server.annotation.StringRequestConverterFunction;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.handler.codec.http.cookie.ServerCookieDecoder;
import io.netty.util.AsciiString;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class AnnotatedValueResolver {
    private static final Logger logger = LoggerFactory.getLogger(AnnotatedValueResolver.class);
    private static final List<RequestObjectResolver> defaultRequestConverters = ImmutableList.of((resolverContext, expectedResultType, beanFactoryId) -> AnnotatedBeanFactory.find(beanFactoryId).orElseThrow(RequestConverterFunction::fallthrough).apply(resolverContext), RequestObjectResolver.of(new JacksonRequestConverterFunction()), RequestObjectResolver.of(new StringRequestConverterFunction()), RequestObjectResolver.of(new ByteArrayRequestConverterFunction()));
    private static final Object[] emptyArguments = new Object[0];
    @Nullable
    private final Class<? extends Annotation> annotationType;
    @Nullable
    private final String httpElementName;
    private final boolean isPathVariable;
    private final boolean shouldExist;
    private final boolean shouldWrapValueAsOptional;
    @Nullable
    private final Class<?> containerType;
    private final Class<?> elementType;
    @Nullable
    private final Object defaultValue;
    private final BiFunction<AnnotatedValueResolver, ResolverContext, Object> resolver;
    @Nullable
    private final EnumConverter<?> enumConverter;
    private final AggregationStrategy aggregationStrategy;
    private static final ConcurrentMap<Class<?>, EnumConverter<?>> enumConverters = new MapMaker().makeMap();

    static Object[] toArguments(List<AnnotatedValueResolver> resolvers, ResolverContext resolverContext) {
        Objects.requireNonNull(resolvers, "resolvers");
        Objects.requireNonNull(resolverContext, "resolverContext");
        if (resolvers.isEmpty()) {
            return emptyArguments;
        }
        return resolvers.stream().map(resolver -> resolver.resolve(resolverContext)).toArray();
    }

    static List<RequestObjectResolver> toRequestObjectResolvers(List<RequestConverterFunction> converters) {
        ImmutableList.Builder builder = ImmutableList.builder();
        converters.stream().map(RequestObjectResolver::of).forEach(builder::add);
        builder.addAll(defaultRequestConverters);
        return builder.build();
    }

    static List<AnnotatedValueResolver> ofServiceMethod(Method method, Set<String> pathParams, List<RequestObjectResolver> objectResolvers) {
        return AnnotatedValueResolver.of(method, pathParams, objectResolvers, true, true);
    }

    static List<AnnotatedValueResolver> ofBeanConstructorOrMethod(Executable constructorOrMethod, Set<String> pathParams, List<RequestObjectResolver> objectResolvers) {
        return AnnotatedValueResolver.of(constructorOrMethod, pathParams, objectResolvers, false, false);
    }

    static Optional<AnnotatedValueResolver> ofBeanField(Field field, Set<String> pathParams, List<RequestObjectResolver> objectResolvers) {
        return AnnotatedValueResolver.of(field, field, field.getType(), pathParams, objectResolvers, false);
    }

    private static List<AnnotatedValueResolver> of(Executable constructorOrMethod, Set<String> pathParams, List<RequestObjectResolver> objectResolvers, boolean implicitRequestObjectAnnotation, boolean isServiceMethod) {
        Optional<AnnotatedValueResolver> resolver;
        Parameter[] parameters = constructorOrMethod.getParameters();
        if (parameters.length == 0) {
            throw new NoParameterException(constructorOrMethod.toGenericString());
        }
        if (AnnotatedValueResolver.isAnnotationPresent(constructorOrMethod)) {
            if (parameters.length != 1) {
                throw new IllegalArgumentException("Only one parameter is allowed to an annotated method: " + constructorOrMethod.toGenericString());
            }
            if (AnnotatedValueResolver.isAnnotationPresent(parameters[0])) {
                throw new IllegalArgumentException("Both a method and parameter are annotated: " + constructorOrMethod.toGenericString());
            }
            resolver = AnnotatedValueResolver.of(constructorOrMethod, parameters[0], parameters[0].getType(), pathParams, objectResolvers, implicitRequestObjectAnnotation);
        } else if (!isServiceMethod && ((RequestConverter[])constructorOrMethod.getAnnotationsByType(RequestConverter.class)).length > 0 && parameters.length == 1) {
            if (AnnotatedValueResolver.isAnnotationPresent(parameters[0])) {
                throw new IllegalArgumentException("Both a method and parameter are annotated: " + constructorOrMethod.toGenericString());
            }
            resolver = AnnotatedValueResolver.of(parameters[0], pathParams, objectResolvers, true);
        } else {
            if (constructorOrMethod.isAnnotationPresent(Default.class)) {
                throw new IllegalArgumentException('@' + Default.class.getSimpleName() + " is not supported for: " + constructorOrMethod.toGenericString());
            }
            resolver = Optional.empty();
        }
        List list = resolver.map(ImmutableList::of).orElseGet(() -> Arrays.stream(parameters).map(p -> AnnotatedValueResolver.of(p, pathParams, objectResolvers, implicitRequestObjectAnnotation)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList()));
        if (list.isEmpty()) {
            throw new NoAnnotatedParameterException(constructorOrMethod.toGenericString());
        }
        if (list.size() != parameters.length) {
            if (list.stream().anyMatch(r -> r.annotationType() != null)) {
                throw new IllegalArgumentException("Unsupported parameter exists: " + constructorOrMethod.toGenericString());
            }
            throw new NoAnnotatedParameterException("Unsupported parameter exists: " + constructorOrMethod.toGenericString());
        }
        return list;
    }

    static Optional<AnnotatedValueResolver> of(Parameter parameter, Set<String> pathParams, List<RequestObjectResolver> objectResolvers, boolean implicitRequestObjectAnnotation) {
        return AnnotatedValueResolver.of(parameter, parameter, parameter.getType(), pathParams, objectResolvers, implicitRequestObjectAnnotation);
    }

    private static Optional<AnnotatedValueResolver> of(AnnotatedElement annotatedElement, AnnotatedElement typeElement, Class<?> type, Set<String> pathParams, List<RequestObjectResolver> objectResolvers, boolean implicitRequestObjectAnnotation) {
        Objects.requireNonNull(annotatedElement, "annotatedElement");
        Objects.requireNonNull(typeElement, "typeElement");
        Objects.requireNonNull(type, "type");
        Objects.requireNonNull(pathParams, "pathParams");
        Objects.requireNonNull(objectResolvers, "objectResolvers");
        Param param = annotatedElement.getAnnotation(Param.class);
        if (param != null) {
            String name = AnnotatedElementNameUtil.findName(param, (Object)typeElement);
            if (pathParams.contains(name)) {
                return Optional.of(AnnotatedValueResolver.ofPathVariable(name, annotatedElement, typeElement, type));
            }
            return Optional.of(AnnotatedValueResolver.ofHttpParameter(name, annotatedElement, typeElement, type));
        }
        Header header = annotatedElement.getAnnotation(Header.class);
        if (header != null) {
            String name = AnnotatedElementNameUtil.findName(header, (Object)typeElement);
            return Optional.of(AnnotatedValueResolver.ofHeader(name, annotatedElement, typeElement, type));
        }
        RequestObject requestObject = annotatedElement.getAnnotation(RequestObject.class);
        if (requestObject != null) {
            RequestConverter[] converters = (RequestConverter[])typeElement.getAnnotationsByType(RequestConverter.class);
            return Optional.of(AnnotatedValueResolver.ofRequestObject(annotatedElement, type, pathParams, AnnotatedValueResolver.addToFirstIfExists(objectResolvers, converters)));
        }
        AnnotatedValueResolver resolver = AnnotatedValueResolver.ofInjectableTypes(typeElement, type);
        if (resolver != null) {
            return Optional.of(resolver);
        }
        RequestConverter[] converters = (RequestConverter[])typeElement.getAnnotationsByType(RequestConverter.class);
        if (converters.length > 0) {
            return Optional.of(AnnotatedValueResolver.ofRequestObject(annotatedElement, type, pathParams, AnnotatedValueResolver.addToFirstIfExists(objectResolvers, converters)));
        }
        if (implicitRequestObjectAnnotation) {
            return Optional.of(AnnotatedValueResolver.ofRequestObject(annotatedElement, type, pathParams, objectResolvers));
        }
        return Optional.empty();
    }

    static List<RequestObjectResolver> addToFirstIfExists(List<RequestObjectResolver> resolvers, RequestConverter[] converters) {
        if (converters.length == 0) {
            return resolvers;
        }
        ImmutableList.Builder builder = new ImmutableList.Builder();
        Arrays.stream(converters).forEach(c -> builder.add(RequestObjectResolver.of(AnnotatedHttpServiceFactory.getInstance(c.value()))));
        builder.addAll(resolvers);
        return builder.build();
    }

    private static boolean isAnnotationPresent(AnnotatedElement element) {
        return element.isAnnotationPresent(Param.class) || element.isAnnotationPresent(Header.class) || element.isAnnotationPresent(RequestObject.class);
    }

    private static AnnotatedValueResolver ofPathVariable(String name, AnnotatedElement annotatedElement, AnnotatedElement typeElement, Class<?> type) {
        return AnnotatedValueResolver.builder(annotatedElement, type).annotationType(Param.class).httpElementName(name).typeElement(typeElement).supportOptional(true).pathVariable(true).resolver(AnnotatedValueResolver.resolver(ctx -> ctx.context().pathParam(name))).build();
    }

    private static AnnotatedValueResolver ofHttpParameter(String name, AnnotatedElement annotatedElement, AnnotatedElement typeElement, Class<?> type) {
        return AnnotatedValueResolver.builder(annotatedElement, type).annotationType(Param.class).httpElementName(name).typeElement(typeElement).supportOptional(true).supportDefault(true).supportContainer(true).aggregation(AggregationStrategy.FOR_FORM_DATA).resolver(AnnotatedValueResolver.resolver((ResolverContext ctx) -> ctx.httpParameters().getAll(name), () -> "Cannot resolve a value from HTTP parameter: " + name)).build();
    }

    private static AnnotatedValueResolver ofHeader(String name, AnnotatedElement annotatedElement, AnnotatedElement typeElement, Class<?> type) {
        return AnnotatedValueResolver.builder(annotatedElement, type).annotationType(Header.class).httpElementName(name).typeElement(typeElement).supportOptional(true).supportDefault(true).supportContainer(true).resolver(AnnotatedValueResolver.resolver((ResolverContext ctx) -> ctx.request().headers().getAll(AsciiString.of((CharSequence)name)), () -> "Cannot resolve a value from HTTP header: " + name)).build();
    }

    private static AnnotatedValueResolver ofRequestObject(AnnotatedElement annotatedElement, Class<?> type, Set<String> pathParams, List<RequestObjectResolver> objectResolvers) {
        AnnotatedBeanFactory.BeanFactoryId beanFactoryId = AnnotatedBeanFactory.register(type, pathParams, objectResolvers);
        return AnnotatedValueResolver.builder(annotatedElement, type).annotationType(RequestObject.class).aggregation(AggregationStrategy.ALWAYS).resolver(AnnotatedValueResolver.resolver(objectResolvers, beanFactoryId)).build();
    }

    @Nullable
    private static AnnotatedValueResolver ofInjectableTypes(AnnotatedElement annotatedElement, Class<?> type) {
        Type actual;
        if (type == Optional.class) {
            logger.warn("Unnecessary Optional is used at '{}'", (Object)annotatedElement);
            actual = ((ParameterizedType)AnnotatedValueResolver.parameterizedTypeOf(annotatedElement)).getActualTypeArguments()[0];
        } else {
            actual = type;
        }
        if (actual == RequestContext.class || actual == ServiceRequestContext.class) {
            return AnnotatedValueResolver.builder(annotatedElement, type).supportOptional(true).resolver((unused, ctx) -> ctx.context()).build();
        }
        if (actual == Request.class || actual == HttpRequest.class) {
            return AnnotatedValueResolver.builder(annotatedElement, type).supportOptional(true).resolver((unused, ctx) -> ctx.request()).build();
        }
        if (actual == AggregatedHttpMessage.class) {
            return AnnotatedValueResolver.builder(annotatedElement, type).supportOptional(true).resolver((unused, ctx) -> ctx.message()).aggregation(AggregationStrategy.ALWAYS).build();
        }
        if (actual == HttpParameters.class) {
            return AnnotatedValueResolver.builder(annotatedElement, type).supportOptional(true).resolver((unused, ctx) -> ctx.httpParameters()).aggregation(AggregationStrategy.FOR_FORM_DATA).build();
        }
        if (actual == Cookies.class) {
            return AnnotatedValueResolver.builder(annotatedElement, type).supportOptional(true).resolver((unused, ctx) -> {
                List values = ctx.request().headers().getAll(HttpHeaderNames.COOKIE);
                if (values.isEmpty()) {
                    return Cookies.copyOf(ImmutableSet.of());
                }
                ImmutableSet.Builder cookies = ImmutableSet.builder();
                values.stream().map(arg_0 -> ((ServerCookieDecoder)ServerCookieDecoder.STRICT).decode(arg_0)).forEach(cookies::addAll);
                return Cookies.copyOf(cookies.build());
            }).build();
        }
        return null;
    }

    private static BiFunction<AnnotatedValueResolver, ResolverContext, Object> resolver(Function<ResolverContext, String> getter) {
        return (resolver, ctx) -> resolver.convert((String)getter.apply((ResolverContext)ctx));
    }

    private static BiFunction<AnnotatedValueResolver, ResolverContext, Object> resolver(Function<ResolverContext, List<String>> getter, Supplier<String> failureMessageSupplier) {
        return (resolver, ctx) -> {
            List values = (List)getter.apply((ResolverContext)ctx);
            if (!resolver.hasContainer()) {
                if (values != null && !values.isEmpty()) {
                    return resolver.convert((String)values.get(0));
                }
                return resolver.defaultOrException();
            }
            try {
                assert (resolver.containerType() != null);
                Collection resolvedValues = (Collection)resolver.containerType().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                if (values != null && !values.isEmpty()) {
                    values.stream().map(resolver::convert).forEach(resolvedValues::add);
                } else {
                    Object defaultValue = resolver.defaultOrException();
                    if (defaultValue != null) {
                        resolvedValues.add(defaultValue);
                    }
                }
                return resolvedValues;
            }
            catch (Throwable cause) {
                throw new IllegalArgumentException((String)failureMessageSupplier.get(), cause);
            }
        };
    }

    private static BiFunction<AnnotatedValueResolver, ResolverContext, Object> resolver(List<RequestObjectResolver> objectResolvers, AnnotatedBeanFactory.BeanFactoryId beanFactoryId) {
        return (resolver, ctx) -> {
            Object value = null;
            for (RequestObjectResolver objectResolver : objectResolvers) {
                try {
                    value = objectResolver.convert((ResolverContext)ctx, resolver.elementType(), beanFactoryId);
                    break;
                }
                catch (FallthroughException fallthroughException) {
                }
                catch (Throwable cause) {
                    Exceptions.throwUnsafely(cause);
                }
            }
            if (value != null) {
                return value;
            }
            throw new IllegalArgumentException("No suitable request converter found for a @" + RequestObject.class.getSimpleName() + " '" + resolver.elementType().getSimpleName() + '\'');
        };
    }

    private static Type parameterizedTypeOf(AnnotatedElement element) {
        if (element instanceof Parameter) {
            return ((Parameter)element).getParameterizedType();
        }
        if (element instanceof Field) {
            return ((Field)element).getGenericType();
        }
        throw new IllegalArgumentException("Unsupported annotated element: " + element.getClass().getSimpleName());
    }

    private AnnotatedValueResolver(@Nullable Class<? extends Annotation> annotationType, @Nullable String httpElementName, boolean isPathVariable, boolean shouldExist, boolean shouldWrapValueAsOptional, @Nullable Class<?> containerType, Class<?> elementType, @Nullable String defaultValue, BiFunction<AnnotatedValueResolver, ResolverContext, Object> resolver, AggregationStrategy aggregationStrategy) {
        this.annotationType = annotationType;
        this.httpElementName = httpElementName;
        this.isPathVariable = isPathVariable;
        this.shouldExist = shouldExist;
        this.shouldWrapValueAsOptional = shouldWrapValueAsOptional;
        this.elementType = Objects.requireNonNull(elementType, "elementType");
        this.containerType = containerType;
        this.resolver = Objects.requireNonNull(resolver, "resolver");
        this.aggregationStrategy = Objects.requireNonNull(aggregationStrategy, "aggregationStrategy");
        this.enumConverter = AnnotatedValueResolver.enumConverter(elementType);
        this.defaultValue = defaultValue != null ? AnnotatedValueResolver.convert(defaultValue, elementType, this.enumConverter) : null;
    }

    @Nullable
    private static EnumConverter<?> enumConverter(Class<?> elementType) {
        if (!elementType.isEnum()) {
            return null;
        }
        return enumConverters.computeIfAbsent(elementType, newElementType -> {
            logger.debug("Registered an Enum {}", newElementType);
            return new EnumConverter<Enum>(newElementType.asSubclass(Enum.class));
        });
    }

    @Nullable
    Class<? extends Annotation> annotationType() {
        return this.annotationType;
    }

    @Nullable
    String httpElementName() {
        return this.httpElementName;
    }

    boolean isPathVariable() {
        return this.isPathVariable;
    }

    boolean shouldExist() {
        return this.shouldExist;
    }

    boolean shouldWrapValueAsOptional() {
        return this.shouldWrapValueAsOptional;
    }

    @Nullable
    Class<?> containerType() {
        return this.containerType;
    }

    Class<?> elementType() {
        return this.elementType;
    }

    @Nullable
    Object defaultValue() {
        return this.defaultValue;
    }

    AggregationStrategy aggregationStrategy() {
        return this.aggregationStrategy;
    }

    boolean hasContainer() {
        return this.containerType != null && (List.class.isAssignableFrom(this.containerType) || Set.class.isAssignableFrom(this.containerType));
    }

    Object resolve(ResolverContext ctx) {
        Optional<Object> resolved = this.resolver.apply(this, ctx);
        return this.shouldWrapValueAsOptional ? Optional.ofNullable(resolved) : resolved;
    }

    private static Object convert(String value, Class<?> elementType, @Nullable EnumConverter<?> enumConverter) {
        return enumConverter != null ? enumConverter.toEnum(value) : AnnotatedHttpServiceTypeUtil.stringToType(value, elementType);
    }

    @Nullable
    private Object convert(@Nullable String value) {
        if (value == null) {
            return this.defaultOrException();
        }
        return AnnotatedValueResolver.convert(value, this.elementType, this.enumConverter);
    }

    @Nullable
    private Object defaultOrException() {
        if (!this.shouldExist) {
            return this.defaultValue;
        }
        throw new IllegalArgumentException("Mandatory parameter is missing: " + this.httpElementName);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("annotation", this.annotationType != null ? this.annotationType.getSimpleName() : "(none)").add("httpElementName", this.httpElementName).add("pathVariable", this.isPathVariable).add("shouldExist", this.shouldExist).add("shouldWrapValueAsOptional", this.shouldWrapValueAsOptional).add("elementType", this.elementType.getSimpleName()).add("containerType", this.containerType != null ? this.containerType.getSimpleName() : "(none)").add("defaultValue", this.defaultValue).add("defaultValueType", this.defaultValue != null ? this.defaultValue.getClass().getSimpleName() : "(none)").add("resolver", this.resolver).add("enumConverter", this.enumConverter).toString();
    }

    private static Builder builder(AnnotatedElement annotatedElement, Type type) {
        return new Builder(annotatedElement, type);
    }

    private static boolean isFormData(@Nullable MediaType contentType) {
        return contentType != null && contentType.belongsTo(MediaType.FORM_DATA);
    }

    static class NoParameterException
    extends NoAnnotatedParameterException {
        private static final long serialVersionUID = 3390292442571367102L;

        NoParameterException(String name) {
            super("No parameters found from: " + name);
        }
    }

    static class NoAnnotatedParameterException
    extends IllegalArgumentException {
        private static final long serialVersionUID = -6003890710456747277L;

        NoAnnotatedParameterException(String name) {
            super("No annotated parameters found from: " + name);
        }
    }

    @FunctionalInterface
    static interface RequestObjectResolver {
        public static RequestObjectResolver of(RequestConverterFunction function) {
            return (resolverContext, expectedResultType, beanFactoryId) -> {
                AggregatedHttpMessage message = resolverContext.message();
                if (message == null) {
                    throw new IllegalArgumentException("Cannot convert this request to an object because it is not aggregated.");
                }
                return function.convertRequest(resolverContext.context(), message, expectedResultType);
            };
        }

        @Nullable
        public Object convert(ResolverContext var1, Class<?> var2, @Nullable AnnotatedBeanFactory.BeanFactoryId var3) throws Throwable;
    }

    private static final class EnumConverter<T extends Enum<T>> {
        private final boolean isCaseSensitiveEnum;
        private final Map<String, T> enumMap;

        EnumConverter(Class<T> enumClass) {
            EnumSet<T> enumInstances = EnumSet.allOf(enumClass);
            Map lowerCaseEnumMap = enumInstances.stream().collect(ImmutableMap.toImmutableMap(e -> Ascii.toLowerCase(e.name()), Function.identity(), (e1, e2) -> e1));
            if (enumInstances.size() != lowerCaseEnumMap.size()) {
                this.enumMap = enumInstances.stream().collect(ImmutableMap.toImmutableMap(Enum::name, Function.identity()));
                this.isCaseSensitiveEnum = true;
            } else {
                this.enumMap = lowerCaseEnumMap;
                this.isCaseSensitiveEnum = false;
            }
        }

        T toEnum(String str) {
            Enum result = (Enum)this.enumMap.get(this.isCaseSensitiveEnum ? str : Ascii.toLowerCase(str));
            if (result != null) {
                return (T)result;
            }
            throw new IllegalArgumentException("unknown enum value: " + str + " (expected: " + this.enumMap.values() + ')');
        }
    }

    static class ResolverContext {
        private final ServiceRequestContext context;
        private final HttpRequest request;
        @Nullable
        private final AggregatedHttpMessage message;
        @Nullable
        private volatile HttpParameters httpParameters;

        ResolverContext(ServiceRequestContext context, HttpRequest request, @Nullable AggregatedHttpMessage message) {
            this.context = Objects.requireNonNull(context, "context");
            this.request = Objects.requireNonNull(request, "request");
            this.message = message;
        }

        ServiceRequestContext context() {
            return this.context;
        }

        HttpRequest request() {
            return this.request;
        }

        @Nullable
        AggregatedHttpMessage message() {
            return this.message;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        HttpParameters httpParameters() {
            HttpParameters result = this.httpParameters;
            if (result == null) {
                ResolverContext resolverContext = this;
                synchronized (resolverContext) {
                    result = this.httpParameters;
                    if (result == null) {
                        this.httpParameters = result = ResolverContext.httpParametersOf(this.context.query(), this.request.headers().contentType(), this.message);
                    }
                }
            }
            return result;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("context", this.context).add("request", this.request).add("message", this.message).add("httpParameters", this.httpParameters).toString();
        }

        private static HttpParameters httpParametersOf(@Nullable String query, @Nullable MediaType contentType, @Nullable AggregatedHttpMessage message) {
            try {
                String body;
                Map parameters = null;
                if (query != null) {
                    parameters = new QueryStringDecoder(query, false).parameters();
                }
                if (message != null && AnnotatedValueResolver.isFormData(contentType) && !(body = message.content().toString(contentType.charset().orElse(StandardCharsets.US_ASCII))).isEmpty()) {
                    Map p = new QueryStringDecoder(body, false).parameters();
                    if (parameters == null) {
                        parameters = p;
                    } else if (p != null) {
                        parameters.putAll(p);
                    }
                }
                if (parameters == null || parameters.isEmpty()) {
                    return HttpParameters.EMPTY_PARAMETERS;
                }
                return HttpParameters.copyOf(parameters);
            }
            catch (Exception e) {
                logger.debug("Failed to decode query string: {}", (Object)query, (Object)e);
                return HttpParameters.EMPTY_PARAMETERS;
            }
        }
    }

    static enum AggregationStrategy {
        NONE,
        ALWAYS,
        FOR_FORM_DATA;


        static boolean aggregationRequired(AggregationStrategy strategy, HttpRequest req) {
            Objects.requireNonNull(strategy, "strategy");
            switch (strategy) {
                case ALWAYS: {
                    return true;
                }
                case FOR_FORM_DATA: {
                    return AnnotatedValueResolver.isFormData(req.headers().contentType());
                }
            }
            return false;
        }

        static AggregationStrategy from(List<AnnotatedValueResolver> resolvers) {
            AggregationStrategy strategy = NONE;
            for (AnnotatedValueResolver r : resolvers) {
                switch (r.aggregationStrategy()) {
                    case ALWAYS: {
                        return ALWAYS;
                    }
                    case FOR_FORM_DATA: {
                        strategy = FOR_FORM_DATA;
                    }
                }
            }
            return strategy;
        }
    }

    private static final class Builder {
        private final AnnotatedElement annotatedElement;
        private final Type type;
        private AnnotatedElement typeElement;
        @Nullable
        private Class<? extends Annotation> annotationType;
        @Nullable
        private String httpElementName;
        private boolean pathVariable;
        private boolean supportContainer;
        private boolean supportOptional;
        private boolean supportDefault;
        @Nullable
        private BiFunction<AnnotatedValueResolver, ResolverContext, Object> resolver;
        private AggregationStrategy aggregation = AggregationStrategy.NONE;

        private Builder(AnnotatedElement annotatedElement, Type type) {
            this.annotatedElement = Objects.requireNonNull(annotatedElement, "annotatedElement");
            this.type = Objects.requireNonNull(type, "type");
            this.typeElement = annotatedElement;
        }

        private Builder annotationType(Class<? extends Annotation> annotationType) {
            assert (annotationType == Param.class || annotationType == Header.class || annotationType == RequestObject.class) : annotationType.getSimpleName();
            this.annotationType = annotationType;
            return this;
        }

        private Builder httpElementName(String httpElementName) {
            this.httpElementName = httpElementName;
            return this;
        }

        private Builder pathVariable(boolean pathVariable) {
            this.pathVariable = pathVariable;
            return this;
        }

        private Builder supportContainer(boolean supportContainer) {
            this.supportContainer = supportContainer;
            return this;
        }

        private Builder supportOptional(boolean supportOptional) {
            this.supportOptional = supportOptional;
            return this;
        }

        private Builder supportDefault(boolean supportDefault) {
            this.supportDefault = supportDefault;
            return this;
        }

        private Builder typeElement(AnnotatedElement typeElement) {
            this.typeElement = typeElement;
            return this;
        }

        private Builder resolver(BiFunction<AnnotatedValueResolver, ResolverContext, Object> resolver) {
            this.resolver = resolver;
            return this;
        }

        private Builder aggregation(AggregationStrategy aggregation) {
            this.aggregation = aggregation;
            return this;
        }

        private static Map.Entry<Class<?>, Class<?>> resolveTypes(Type parameterizedType, Type type, boolean unwrapOptionalType) {
            Class<?> containerType;
            Class elementType;
            if (unwrapOptionalType) {
                assert (parameterizedType instanceof ParameterizedType) : String.valueOf(parameterizedType);
                parameterizedType = ((ParameterizedType)parameterizedType).getActualTypeArguments()[0];
            }
            if (parameterizedType instanceof ParameterizedType) {
                try {
                    elementType = (Class)((ParameterizedType)parameterizedType).getActualTypeArguments()[0];
                }
                catch (Throwable cause) {
                    throw new IllegalArgumentException("Invalid parameter type: " + parameterizedType, cause);
                }
                containerType = AnnotatedHttpServiceTypeUtil.normalizeContainerType((Class)((ParameterizedType)parameterizedType).getRawType());
            } else {
                elementType = unwrapOptionalType ? (Class)parameterizedType : (Class)type;
                containerType = null;
            }
            return new AbstractMap.SimpleImmutableEntry(containerType, AnnotatedHttpServiceTypeUtil.validateElementType(elementType));
        }

        private AnnotatedValueResolver build() {
            Map.Entry<Class<?>, Class<?>> types;
            String defaultValue;
            boolean shouldExist;
            boolean shouldWrapValueAsOptional;
            Preconditions.checkArgument(this.resolver != null, "'resolver' should be specified");
            boolean bl = shouldWrapValueAsOptional = this.type == Optional.class && this.annotationType != RequestObject.class;
            if (!this.supportOptional && shouldWrapValueAsOptional) {
                throw new IllegalArgumentException('@' + Optional.class.getSimpleName() + " is not supported for: " + (this.annotationType != null ? this.annotationType.getSimpleName() : this.type.getTypeName()));
            }
            Default aDefault = this.annotatedElement.getAnnotation(Default.class);
            if (aDefault != null) {
                if (this.supportDefault) {
                    if (shouldWrapValueAsOptional) {
                        logger.warn("@{} was used with '{}'. Optional is redundant because the value is always present.", (Object)Default.class.getSimpleName(), (Object)this.annotatedElement);
                    }
                    shouldExist = false;
                    defaultValue = DefaultValues.getSpecifiedValue(aDefault.value()).get();
                } else {
                    StringBuilder msg = new StringBuilder();
                    msg.append('@');
                    msg.append(Default.class.getSimpleName());
                    msg.append(" is redundant for ");
                    if (this.pathVariable) {
                        msg.append("path variable '").append(this.httpElementName).append('\'');
                    } else if (this.annotationType != null) {
                        msg.append("annotation @").append(this.annotationType.getSimpleName());
                    } else {
                        msg.append("type '").append(this.type.getTypeName()).append('\'');
                    }
                    msg.append(" because the value is always present.");
                    logger.warn(msg.toString());
                    shouldExist = !shouldWrapValueAsOptional;
                    defaultValue = null;
                }
            } else {
                shouldExist = !shouldWrapValueAsOptional;
                defaultValue = null;
            }
            if (this.pathVariable && !shouldExist) {
                logger.warn("Optional is redundant for path variable '{}' because the value is always present.", (Object)this.httpElementName);
            }
            if (this.annotationType == Param.class || this.annotationType == Header.class) {
                assert (this.httpElementName != null);
                Type parameterizedType = AnnotatedValueResolver.parameterizedTypeOf(this.typeElement);
                types = Builder.resolveTypes(parameterizedType, this.type, shouldWrapValueAsOptional);
                if (!this.supportContainer && types.getKey() != null) {
                    throw new IllegalArgumentException("Unsupported collection type: " + parameterizedType);
                }
            } else {
                assert (this.type.getClass() == Class.class) : String.valueOf(this.type);
                types = new AbstractMap.SimpleImmutableEntry<Object, Class>(null, (Class)this.type);
            }
            return new AnnotatedValueResolver(this.annotationType, this.httpElementName, this.pathVariable, shouldExist, shouldWrapValueAsOptional, types.getKey(), types.getValue(), defaultValue, this.resolver, this.aggregation);
        }
    }
}

