/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server;

import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableSet;
import com.linecorp.armeria.server.AbstractPathMapping;
import com.linecorp.armeria.server.PathMappingContext;
import com.linecorp.armeria.server.PathMappingResult;
import java.util.Optional;
import java.util.Set;

final class CatchAllPathMapping
extends AbstractPathMapping {
    static final CatchAllPathMapping INSTANCE = new CatchAllPathMapping();
    private static final Optional<String> PREFIX_PATH_OPT = Optional.of("/");
    private static final Optional<String> TRIE_PATH_OPT = Optional.of("/*");
    private static final String LOGGER_NAME = CatchAllPathMapping.loggerName("/");

    private CatchAllPathMapping() {
    }

    @Override
    protected PathMappingResult doApply(PathMappingContext mappingCtx) {
        return PathMappingResult.of(mappingCtx.path(), mappingCtx.query());
    }

    @Override
    public Set<String> paramNames() {
        return ImmutableSet.of();
    }

    @Override
    public String loggerName() {
        return LOGGER_NAME;
    }

    @Override
    public String meterTag() {
        return "catch-all";
    }

    @Override
    public Optional<String> prefix() {
        return PREFIX_PATH_OPT;
    }

    @Override
    public Optional<String> triePath() {
        return TRIE_PATH_OPT;
    }

    public String toString() {
        return "catchAll";
    }
}

