/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server;

import com.linecorp.armeria.common.metric.MeterIdPrefix;
import com.linecorp.armeria.common.util.Exceptions;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.server.PathMapped;
import com.linecorp.armeria.server.PathMappingContext;
import com.linecorp.armeria.server.Router;
import io.micrometer.core.instrument.MeterRegistry;
import java.io.OutputStream;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

final class CompositeRouter<I, O>
implements Router<O> {
    private final List<Router<I>> delegates;
    private final Function<PathMapped<I>, PathMapped<O>> resultMapper;

    CompositeRouter(Router<I> delegate, Function<PathMapped<I>, PathMapped<O>> resultMapper) {
        this(ImmutableList.of(Objects.requireNonNull(delegate, "delegate")), resultMapper);
    }

    CompositeRouter(List<Router<I>> delegates, Function<PathMapped<I>, PathMapped<O>> resultMapper) {
        this.delegates = Objects.requireNonNull(delegates, "delegates");
        this.resultMapper = Objects.requireNonNull(resultMapper, "resultMapper");
    }

    @Override
    public PathMapped<O> find(PathMappingContext mappingCtx) {
        for (Router<I> delegate : this.delegates) {
            PathMapped<I> result = delegate.find(mappingCtx);
            if (!result.isPresent()) continue;
            return this.resultMapper.apply(result);
        }
        mappingCtx.delayedThrowable().ifPresent(Exceptions::throwUnsafely);
        return PathMapped.empty();
    }

    @Override
    public boolean registerMetrics(MeterRegistry registry, MeterIdPrefix idPrefix) {
        int numDelegates = this.delegates.size();
        switch (numDelegates) {
            case 0: {
                return false;
            }
            case 1: {
                return this.delegates.get(0).registerMetrics(registry, idPrefix);
            }
        }
        boolean registered = false;
        for (int i = 0; i < numDelegates; ++i) {
            MeterIdPrefix delegateIdPrefix = idPrefix.withTags("index", String.valueOf(i));
            if (!this.delegates.get(i).registerMetrics(registry, delegateIdPrefix)) continue;
            registered = true;
        }
        return registered;
    }

    @Override
    public void dump(OutputStream output) {
        this.delegates.forEach(delegate -> delegate.dump(output));
    }
}

