/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server;

import com.linecorp.armeria.common.DefaultHttpRequest;
import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.HttpObject;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.internal.InboundTrafficController;
import com.linecorp.armeria.server.ServiceRequestContext;
import io.netty.channel.EventLoop;
import javax.annotation.Nullable;

final class DecodedHttpRequest
extends DefaultHttpRequest {
    private final EventLoop eventLoop;
    private final int id;
    private final int streamId;
    private final boolean keepAlive;
    private final InboundTrafficController inboundTrafficController;
    private final long defaultMaxRequestLength;
    @Nullable
    private ServiceRequestContext ctx;
    private long transferredBytes;
    @Nullable
    private HttpResponse response;
    private boolean isResponseAborted;

    DecodedHttpRequest(EventLoop eventLoop, int id, int streamId, HttpHeaders headers, boolean keepAlive, InboundTrafficController inboundTrafficController, long defaultMaxRequestLength) {
        super(headers);
        this.eventLoop = eventLoop;
        this.id = id;
        this.streamId = streamId;
        this.keepAlive = keepAlive;
        this.inboundTrafficController = inboundTrafficController;
        this.defaultMaxRequestLength = defaultMaxRequestLength;
    }

    void init(ServiceRequestContext ctx) {
        this.ctx = ctx;
        ctx.logBuilder().requestHeaders(this.headers());
    }

    int id() {
        return this.id;
    }

    int streamId() {
        return this.streamId;
    }

    boolean isKeepAlive() {
        return this.keepAlive;
    }

    long maxRequestLength() {
        return this.ctx != null ? this.ctx.maxRequestLength() : this.defaultMaxRequestLength;
    }

    long transferredBytes() {
        return this.transferredBytes;
    }

    void increaseTransferredBytes(long delta) {
        this.transferredBytes = this.transferredBytes > Long.MAX_VALUE - delta ? Long.MAX_VALUE : (this.transferredBytes += delta);
    }

    protected EventLoop defaultSubscriberExecutor() {
        return this.eventLoop;
    }

    @Override
    public boolean tryWrite(HttpObject obj) {
        boolean published = super.tryWrite(obj);
        if (published && obj instanceof HttpData) {
            int length = ((HttpData)obj).length();
            this.inboundTrafficController.inc(length);
            assert (this.ctx != null) : "uninitialized DecodedHttpRequest must be aborted.";
            this.ctx.logBuilder().requestLength(this.transferredBytes);
        }
        return published;
    }

    @Override
    protected void onRemoval(HttpObject obj) {
        if (obj instanceof HttpData) {
            int length = ((HttpData)obj).length();
            this.inboundTrafficController.dec(length);
        }
    }

    void setResponse(HttpResponse response) {
        if (this.isResponseAborted) {
            if (!response.isComplete()) {
                response.abort();
            }
        } else {
            this.response = response;
        }
    }

    void abortResponse(Throwable cause) {
        this.isResponseAborted = true;
        if (!this.tryClose(cause) && this.response != null && !this.response.isComplete()) {
            this.response.abort();
        }
    }
}

