/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server;

import com.linecorp.armeria.common.Request;
import com.linecorp.armeria.common.Response;
import com.linecorp.armeria.server.PathMapping;
import com.linecorp.armeria.server.Service;
import com.linecorp.armeria.server.ServiceCallbackInvoker;
import com.linecorp.armeria.server.ServiceConfig;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

public abstract class DecoratingService<T_I extends Request, T_O extends Response, R_I extends Request, R_O extends Response>
implements Service<R_I, R_O> {
    private final Service<T_I, T_O> delegate;

    protected DecoratingService(Service<T_I, T_O> delegate) {
        this.delegate = Objects.requireNonNull(delegate, "delegate");
    }

    protected final <T extends Service<T_I, T_O>> T delegate() {
        return (T)this.delegate;
    }

    @Override
    public void serviceAdded(ServiceConfig cfg) throws Exception {
        ServiceCallbackInvoker.invokeServiceAdded(cfg, this.delegate);
    }

    @Override
    public final <T> Optional<T> as(Class<T> serviceType) {
        Optional<T> result = Service.super.as(serviceType);
        return result.isPresent() ? result : this.delegate.as(serviceType);
    }

    @Override
    public boolean shouldCachePath(String path, @Nullable String query, PathMapping pathMapping) {
        return this.delegate.shouldCachePath(path, query, pathMapping);
    }

    public String toString() {
        String simpleName = this.getClass().getSimpleName();
        String name = simpleName.isEmpty() ? this.getClass().getName() : simpleName;
        return name + '(' + this.delegate + ')';
    }
}

