/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server;

import com.linecorp.armeria.common.Flags;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.RequestContext;
import com.linecorp.armeria.server.HttpResponseException;
import com.linecorp.armeria.server.HttpStatusException;
import com.linecorp.armeria.server.annotation.ExceptionHandlerFunction;
import com.linecorp.armeria.server.annotation.ExceptionVerbosity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DefaultExceptionHandler
implements ExceptionHandlerFunction {
    private static final Logger logger = LoggerFactory.getLogger(DefaultExceptionHandler.class);

    DefaultExceptionHandler() {
    }

    @Override
    public HttpResponse handleException(RequestContext ctx, HttpRequest req, Throwable cause) {
        if (cause instanceof IllegalArgumentException) {
            return HttpResponse.of(HttpStatus.BAD_REQUEST);
        }
        if (cause instanceof HttpStatusException) {
            return HttpResponse.of(((HttpStatusException)cause).httpStatus());
        }
        if (cause instanceof HttpResponseException) {
            return ((HttpResponseException)cause).httpResponse();
        }
        if (Flags.annotatedServiceExceptionVerbosity() == ExceptionVerbosity.UNHANDLED && logger.isWarnEnabled()) {
            logger.warn("{} Unhandled exception from an annotated service:", (Object)ctx, (Object)cause);
        }
        return HttpResponse.of(HttpStatus.INTERNAL_SERVER_ERROR);
    }
}

