/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server;

import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableSet;
import com.linecorp.armeria.server.AbstractPathMapping;
import com.linecorp.armeria.server.PathMappingContext;
import com.linecorp.armeria.server.PathMappingResult;
import com.linecorp.armeria.server.PathMappingResultBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

final class DefaultPathMapping
extends AbstractPathMapping {
    private static final Pattern VALID_PATTERN = Pattern.compile("(/[^/{}:]+|/:[^/{}]+|/\\{[^/{}]+})+/?");
    private static final String[] EMPTY_NAMES = new String[0];
    private final String pathPattern;
    private final Pattern pattern;
    private final Optional<String> skeleton;
    private final String[] paramNameArray;
    private final Set<String> paramNames;
    private final String loggerName;

    DefaultPathMapping(String pathPattern) {
        Objects.requireNonNull(pathPattern, "pathPattern");
        if (!pathPattern.startsWith("/")) {
            throw new IllegalArgumentException("pathPattern: " + pathPattern + " (must start with '/')");
        }
        if (!VALID_PATTERN.matcher(pathPattern).matches()) {
            throw new IllegalArgumentException("pathPattern: " + pathPattern + " (invalid pattern)");
        }
        StringJoiner patternJoiner = new StringJoiner("/");
        StringJoiner skeletonJoiner = new StringJoiner("/");
        ArrayList<String> paramNames = new ArrayList<String>();
        for (String token : pathPattern.split("/")) {
            String paramName = DefaultPathMapping.paramName(token);
            if (paramName == null) {
                patternJoiner.add(token);
                skeletonJoiner.add(token);
                continue;
            }
            int paramNameIdx = paramNames.indexOf(paramName);
            if (paramNameIdx < 0) {
                paramNames.add(paramName);
                patternJoiner.add("([^/]+)");
            } else {
                patternJoiner.add("\\" + (paramNameIdx + 1));
            }
            skeletonJoiner.add(":");
        }
        this.pathPattern = pathPattern;
        this.pattern = Pattern.compile(patternJoiner.toString());
        this.skeleton = Optional.of(skeletonJoiner.toString());
        this.paramNameArray = paramNames.toArray(EMPTY_NAMES);
        this.paramNames = ImmutableSet.copyOf(paramNames);
        this.loggerName = DefaultPathMapping.loggerName(pathPattern);
    }

    @Nullable
    private static String paramName(String token) {
        if (token.startsWith("{") && token.endsWith("}")) {
            return token.substring(1, token.length() - 1);
        }
        if (token.startsWith(":")) {
            return token.substring(1);
        }
        return null;
    }

    String skeleton() {
        return this.skeleton.get();
    }

    @Override
    public Set<String> paramNames() {
        return this.paramNames;
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    @Override
    public String meterTag() {
        return this.pathPattern;
    }

    @Override
    public Optional<String> triePath() {
        return this.skeleton;
    }

    @Override
    protected PathMappingResult doApply(PathMappingContext mappingCtx) {
        Matcher matcher = this.pattern.matcher(mappingCtx.path());
        if (!matcher.matches()) {
            return PathMappingResult.empty();
        }
        if (this.paramNameArray.length == 0) {
            return PathMappingResult.of(mappingCtx.path(), mappingCtx.query());
        }
        PathMappingResultBuilder builder = new PathMappingResultBuilder(mappingCtx.path(), mappingCtx.query());
        for (int i = 0; i < this.paramNameArray.length; ++i) {
            builder.rawParam(this.paramNameArray[i], matcher.group(i + 1));
        }
        return builder.build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultPathMapping that = (DefaultPathMapping)o;
        return this.skeleton.equals(that.skeleton) && Arrays.equals(this.paramNameArray, that.paramNameArray);
    }

    public int hashCode() {
        return this.skeleton.hashCode() * 31 + Arrays.hashCode(this.paramNameArray);
    }

    public String toString() {
        return this.pathPattern;
    }
}

