/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server;

import com.linecorp.armeria.common.HttpHeaderNames;
import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.HttpMethod;
import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.common.MediaTypeSet;
import com.linecorp.armeria.internal.shaded.guava.base.Splitter;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.server.PathMappingContext;
import com.linecorp.armeria.server.VirtualHost;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DefaultPathMappingContext
implements PathMappingContext {
    private static final Logger logger = LoggerFactory.getLogger(DefaultPathMappingContext.class);
    static final List<MediaType> ANY_TYPE = ImmutableList.of(MediaType.ANY_TYPE);
    private static final Splitter ACCEPT_SPLITTER = Splitter.on(',').trimResults();
    private final VirtualHost virtualHost;
    private final String hostname;
    private final HttpMethod method;
    private final String path;
    @Nullable
    private final String query;
    @Nullable
    private final MediaType consumeType;
    @Nullable
    private final List<MediaType> produceTypes;
    private final List<Object> summary;
    @Nullable
    private Throwable delayedCause;

    DefaultPathMappingContext(VirtualHost virtualHost, String hostname, HttpMethod method, String path, @Nullable String query, @Nullable MediaType consumeType, @Nullable List<MediaType> produceTypes) {
        this.virtualHost = Objects.requireNonNull(virtualHost, "virtualHost");
        this.hostname = Objects.requireNonNull(hostname, "hostname");
        this.method = Objects.requireNonNull(method, "method");
        this.path = Objects.requireNonNull(path, "path");
        this.query = query;
        this.consumeType = consumeType;
        this.produceTypes = produceTypes;
        this.summary = DefaultPathMappingContext.generateSummary(this);
    }

    @Override
    public VirtualHost virtualHost() {
        return this.virtualHost;
    }

    @Override
    public String hostname() {
        return this.hostname;
    }

    @Override
    public HttpMethod method() {
        return this.method;
    }

    @Override
    public String path() {
        return this.path;
    }

    @Override
    @Nullable
    public String query() {
        return this.query;
    }

    @Override
    @Nullable
    public MediaType consumeType() {
        return this.consumeType;
    }

    @Override
    @Nullable
    public List<MediaType> produceTypes() {
        return this.produceTypes;
    }

    @Override
    public List<Object> summary() {
        return this.summary;
    }

    @Override
    public void delayThrowable(Throwable delayedCause) {
        this.delayedCause = Objects.requireNonNull(delayedCause, "delayedCause");
    }

    @Override
    public Optional<Throwable> delayedThrowable() {
        return Optional.ofNullable(this.delayedCause);
    }

    public int hashCode() {
        return this.summary().hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof DefaultPathMappingContext && (this == obj || this.summary().equals(((DefaultPathMappingContext)obj).summary()));
    }

    public String toString() {
        return this.summary().toString();
    }

    static PathMappingContext of(VirtualHost virtualHost, String hostname, String path, @Nullable String query, HttpHeaders headers, @Nullable MediaTypeSet producibleMediaTypes) {
        MediaType consumeType = DefaultPathMappingContext.resolveConsumeType(headers);
        List<MediaType> produceTypes = DefaultPathMappingContext.resolveProduceTypes(headers, producibleMediaTypes);
        return new DefaultPathMappingContext(virtualHost, hostname, headers.method(), path, query, consumeType, produceTypes);
    }

    @Nullable
    static MediaType resolveConsumeType(HttpHeaders headers) {
        MediaType contentType = headers.contentType();
        if (contentType != null) {
            return contentType;
        }
        return null;
    }

    @Nullable
    static List<MediaType> resolveProduceTypes(HttpHeaders headers, @Nullable MediaTypeSet producibleMediaTypes) {
        if (producibleMediaTypes == null || producibleMediaTypes.isEmpty()) {
            return null;
        }
        List acceptHeaders = headers.getAll(HttpHeaderNames.ACCEPT);
        if (acceptHeaders == null || acceptHeaders.isEmpty()) {
            return ANY_TYPE;
        }
        ArrayList<MediaType> selectedTypes = new ArrayList<MediaType>(4);
        for (String acceptHeader : acceptHeaders) {
            for (String value : ACCEPT_SPLITTER.split(acceptHeader)) {
                try {
                    MediaType type = MediaType.parse(value);
                    for (MediaType producibleMediaType : producibleMediaTypes) {
                        if (!producibleMediaType.belongsTo(type)) continue;
                        selectedTypes.add(type);
                    }
                }
                catch (IllegalArgumentException e) {
                    logger.debug("Failed to parse the media type in 'accept' header: {}", (Object)value, (Object)e);
                }
            }
        }
        if (selectedTypes.size() > 1) {
            selectedTypes.sort(DefaultPathMappingContext::compareMediaType);
        }
        return selectedTypes;
    }

    static int compareMediaType(MediaType m1, MediaType m2) {
        int qCompare = Float.compare(m2.qualityFactor(), m1.qualityFactor());
        if (qCompare != 0) {
            return qCompare;
        }
        int wildcardCompare = Integer.compare(m1.numWildcards(), m2.numWildcards());
        if (wildcardCompare != 0) {
            return wildcardCompare;
        }
        return m1.type().compareTo(m2.type());
    }

    static List<Object> generateSummary(PathMappingContext mappingCtx) {
        Objects.requireNonNull(mappingCtx, "mappingCtx");
        ArrayList<Object> summary = new ArrayList<Object>(8);
        summary.add(mappingCtx.virtualHost());
        summary.add((Object)mappingCtx.method());
        summary.add(mappingCtx.path());
        summary.add(mappingCtx.consumeType());
        List<MediaType> produceTypes = mappingCtx.produceTypes();
        if (produceTypes != null) {
            summary.addAll(produceTypes);
        }
        return summary;
    }
}

