/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server;

import com.linecorp.armeria.common.DefaultHttpHeaders;
import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.common.NonWrappingRequestContext;
import com.linecorp.armeria.common.Request;
import com.linecorp.armeria.common.SessionProtocol;
import com.linecorp.armeria.common.logging.DefaultRequestLog;
import com.linecorp.armeria.common.logging.RequestLog;
import com.linecorp.armeria.common.logging.RequestLogBuilder;
import com.linecorp.armeria.server.PathMapping;
import com.linecorp.armeria.server.PathMappingContext;
import com.linecorp.armeria.server.PathMappingResult;
import com.linecorp.armeria.server.ProxiedAddresses;
import com.linecorp.armeria.server.RequestContextAwareLogger;
import com.linecorp.armeria.server.RequestTimeoutChangeListener;
import com.linecorp.armeria.server.Server;
import com.linecorp.armeria.server.ServerConfig;
import com.linecorp.armeria.server.Service;
import com.linecorp.armeria.server.ServiceConfig;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.VirtualHost;
import io.micrometer.core.instrument.MeterRegistry;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.EventLoop;
import io.netty.handler.codec.Headers;
import io.netty.util.AsciiString;
import io.netty.util.Attribute;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.time.Duration;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.net.ssl.SSLSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultServiceRequestContext
extends NonWrappingRequestContext
implements ServiceRequestContext {
    private final Channel ch;
    private final ServiceConfig cfg;
    private final PathMappingContext pathMappingContext;
    private final PathMappingResult pathMappingResult;
    @Nullable
    private final SSLSession sslSession;
    @Nullable
    private final ProxiedAddresses proxiedAddresses;
    private final DefaultRequestLog log;
    private final Logger logger;
    @Nullable
    private ExecutorService blockingTaskExecutor;
    private long requestTimeoutMillis;
    @Nullable
    private Runnable requestTimeoutHandler;
    private long maxRequestLength;
    @Nullable
    private volatile RequestTimeoutChangeListener requestTimeoutChangeListener;
    @Nullable
    private volatile HttpHeaders additionalResponseHeaders;
    @Nullable
    private String strVal;

    public DefaultServiceRequestContext(ServiceConfig cfg, Channel ch, MeterRegistry meterRegistry, SessionProtocol sessionProtocol, PathMappingContext pathMappingContext, PathMappingResult pathMappingResult, Request request, @Nullable SSLSession sslSession, @Nullable ProxiedAddresses proxiedAddresses) {
        super(meterRegistry, sessionProtocol, Objects.requireNonNull(pathMappingContext, "pathMappingContext").method(), pathMappingContext.path(), Objects.requireNonNull(pathMappingResult, "pathMappingResult").query(), request);
        this.ch = Objects.requireNonNull(ch, "ch");
        this.cfg = Objects.requireNonNull(cfg, "cfg");
        this.pathMappingContext = pathMappingContext;
        this.pathMappingResult = pathMappingResult;
        this.sslSession = sslSession;
        this.proxiedAddresses = proxiedAddresses;
        this.log = new DefaultRequestLog(this);
        this.log.startRequest(ch, sessionProtocol);
        this.logger = this.newLogger(cfg);
        ServerConfig serverCfg = cfg.server().config();
        this.requestTimeoutMillis = serverCfg.defaultRequestTimeoutMillis();
        this.maxRequestLength = serverCfg.defaultMaxRequestLength();
    }

    private RequestContextAwareLogger newLogger(ServiceConfig cfg) {
        String loggerName = cfg.loggerName().orElse(null);
        if (loggerName == null) {
            loggerName = cfg.pathMapping().loggerName();
        }
        return new RequestContextAwareLogger(this, LoggerFactory.getLogger((String)(cfg.server().config().serviceLoggerPrefix() + '.' + loggerName)));
    }

    @Override
    @Nonnull
    public <A extends SocketAddress> A remoteAddress() {
        Channel ch = this.channel();
        assert (ch != null);
        SocketAddress addr = ch.remoteAddress();
        return (A)addr;
    }

    @Override
    @Nonnull
    public <A extends SocketAddress> A localAddress() {
        Channel ch = this.channel();
        assert (ch != null);
        SocketAddress addr = ch.localAddress();
        return (A)addr;
    }

    @Override
    public ServiceRequestContext newDerivedContext() {
        return this.newDerivedContext((Request)this.request());
    }

    @Override
    public ServiceRequestContext newDerivedContext(Request request) {
        DefaultServiceRequestContext ctx = new DefaultServiceRequestContext(this.cfg, this.ch, this.meterRegistry(), this.sessionProtocol(), this.pathMappingContext, this.pathMappingResult, request, this.sslSession(), this.proxiedAddresses());
        HttpHeaders additionalHeaders = this.additionalResponseHeaders();
        if (!additionalHeaders.isEmpty()) {
            ctx.setAdditionalResponseHeaders(additionalHeaders);
        }
        Iterator<Attribute<?>> i = this.attrs();
        while (i.hasNext()) {
            ctx.addAttr(i.next());
        }
        return ctx;
    }

    private HttpHeaders createAdditionalHeadersIfAbsent() {
        HttpHeaders additionalResponseHeaders = this.additionalResponseHeaders;
        if (additionalResponseHeaders == null) {
            DefaultHttpHeaders newHeaders = new DefaultHttpHeaders();
            this.additionalResponseHeaders = newHeaders;
            return newHeaders;
        }
        return additionalResponseHeaders;
    }

    private <T> void addAttr(Attribute<?> attribute) {
        Attribute<?> a = attribute;
        this.attr(a.key()).set(a.get());
    }

    @Override
    protected Channel channel() {
        return this.ch;
    }

    @Override
    public Server server() {
        return this.cfg.server();
    }

    @Override
    public VirtualHost virtualHost() {
        return this.cfg.virtualHost();
    }

    @Override
    public PathMapping pathMapping() {
        return this.cfg.pathMapping();
    }

    @Override
    public PathMappingContext pathMappingContext() {
        return this.pathMappingContext;
    }

    @Override
    public Map<String, String> pathParams() {
        return this.pathMappingResult.pathParams();
    }

    @Override
    public <T extends Service<HttpRequest, HttpResponse>> T service() {
        return this.cfg.service();
    }

    @Override
    public ExecutorService blockingTaskExecutor() {
        if (this.blockingTaskExecutor != null) {
            return this.blockingTaskExecutor;
        }
        this.blockingTaskExecutor = this.makeContextAware(this.server().config().blockingTaskExecutor());
        return this.blockingTaskExecutor;
    }

    @Override
    public String mappedPath() {
        return this.pathMappingResult.path();
    }

    @Override
    public String decodedMappedPath() {
        return this.pathMappingResult.decodedPath();
    }

    @Override
    @Nullable
    public MediaType negotiatedResponseMediaType() {
        return this.pathMappingResult.negotiatedResponseMediaType();
    }

    @Override
    public EventLoop eventLoop() {
        return this.ch.eventLoop();
    }

    @Override
    public Logger logger() {
        return this.logger;
    }

    @Override
    @Nullable
    public SSLSession sslSession() {
        return this.sslSession;
    }

    @Override
    public long requestTimeoutMillis() {
        return this.requestTimeoutMillis;
    }

    @Override
    public void setRequestTimeoutMillis(long requestTimeoutMillis) {
        if (requestTimeoutMillis < 0L) {
            throw new IllegalArgumentException("requestTimeoutMillis: " + requestTimeoutMillis + " (expected: >= 0)");
        }
        if (this.requestTimeoutMillis != requestTimeoutMillis) {
            this.requestTimeoutMillis = requestTimeoutMillis;
            RequestTimeoutChangeListener listener = this.requestTimeoutChangeListener;
            if (listener != null) {
                if (this.ch.eventLoop().inEventLoop()) {
                    listener.onRequestTimeoutChange(requestTimeoutMillis);
                } else {
                    this.ch.eventLoop().execute(() -> listener.onRequestTimeoutChange(requestTimeoutMillis));
                }
            }
        }
    }

    @Override
    public void setRequestTimeout(Duration requestTimeout) {
        this.setRequestTimeoutMillis(Objects.requireNonNull(requestTimeout, "requestTimeout").toMillis());
    }

    @Nullable
    public Runnable requestTimeoutHandler() {
        return this.requestTimeoutHandler;
    }

    @Override
    public void setRequestTimeoutHandler(Runnable requestTimeoutHandler) {
        this.requestTimeoutHandler = Objects.requireNonNull(requestTimeoutHandler, "requestTimeoutHandler");
    }

    @Override
    public long maxRequestLength() {
        return this.maxRequestLength;
    }

    @Override
    public void setMaxRequestLength(long maxRequestLength) {
        if (maxRequestLength < 0L) {
            throw new IllegalArgumentException("maxRequestLength: " + maxRequestLength + " (expected: >= 0)");
        }
        this.maxRequestLength = maxRequestLength;
    }

    @Override
    public HttpHeaders additionalResponseHeaders() {
        HttpHeaders additionalResponseHeaders = this.additionalResponseHeaders;
        if (additionalResponseHeaders == null) {
            return HttpHeaders.EMPTY_HEADERS;
        }
        return additionalResponseHeaders.asImmutable();
    }

    @Override
    public void setAdditionalResponseHeader(AsciiString name, String value) {
        Objects.requireNonNull(name, "name");
        Objects.requireNonNull(value, "value");
        this.createAdditionalHeadersIfAbsent().set(name, value);
    }

    @Override
    public void setAdditionalResponseHeaders(Headers<? extends AsciiString, ? extends String, ?> headers) {
        Objects.requireNonNull(headers, "headers");
        this.createAdditionalHeadersIfAbsent().set(headers);
    }

    @Override
    public void addAdditionalResponseHeader(AsciiString name, String value) {
        Objects.requireNonNull(name, "name");
        Objects.requireNonNull(value, "value");
        this.createAdditionalHeadersIfAbsent().add(name, value);
    }

    @Override
    public void addAdditionalResponseHeaders(Headers<? extends AsciiString, ? extends String, ?> headers) {
        Objects.requireNonNull(headers, "headers");
        this.createAdditionalHeadersIfAbsent().add(headers);
    }

    @Override
    public boolean removeAdditionalResponseHeader(AsciiString name) {
        Objects.requireNonNull(name, "name");
        HttpHeaders additionalResponseHeaders = this.additionalResponseHeaders;
        if (additionalResponseHeaders == null) {
            return false;
        }
        return additionalResponseHeaders.remove(name);
    }

    @Override
    @Nullable
    public ProxiedAddresses proxiedAddresses() {
        return this.proxiedAddresses;
    }

    @Override
    public RequestLog log() {
        return this.log;
    }

    @Override
    public RequestLogBuilder logBuilder() {
        return this.log;
    }

    @Override
    public ByteBufAllocator alloc() {
        return this.ch.alloc();
    }

    public void setRequestTimeoutChangeListener(RequestTimeoutChangeListener listener) {
        Objects.requireNonNull(listener, "listener");
        if (this.requestTimeoutChangeListener != null) {
            throw new IllegalStateException("requestTimeoutChangeListener is set already.");
        }
        this.requestTimeoutChangeListener = listener;
    }

    public String toString() {
        boolean hasChannel;
        String strVal = this.strVal;
        if (strVal != null) {
            return strVal;
        }
        StringBuilder buf = new StringBuilder(96);
        Channel ch = this.channel();
        boolean bl = hasChannel = ch != null;
        if (hasChannel) {
            buf.append(ch);
        }
        buf.append('[').append(this.sessionProtocol().uriText()).append("://").append(this.virtualHost().defaultHostname());
        InetSocketAddress laddr = (InetSocketAddress)this.localAddress();
        if (laddr != null) {
            buf.append(':').append(laddr.getPort());
        } else {
            buf.append(":-1");
        }
        buf.append(this.path()).append('#').append((Object)this.method()).append(']');
        strVal = buf.toString();
        if (hasChannel) {
            this.strVal = strVal;
        }
        return strVal;
    }
}

