/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server;

import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableSet;
import com.linecorp.armeria.server.AbstractPathMapping;
import com.linecorp.armeria.server.PathMappingContext;
import com.linecorp.armeria.server.PathMappingResult;
import java.util.Optional;
import java.util.Set;

final class ExactPathMapping
extends AbstractPathMapping {
    static final String PREFIX = "exact:";
    static final int PREFIX_LEN = "exact:".length();
    private final String exactPath;
    private final String loggerName;
    private final String meterTag;
    private final Optional<String> exactPathOpt;

    ExactPathMapping(String exactPath) {
        this.exactPath = ExactPathMapping.ensureAbsolutePath(exactPath, "exactPath");
        this.exactPathOpt = Optional.of(exactPath);
        this.loggerName = ExactPathMapping.loggerName(exactPath);
        this.meterTag = PREFIX + exactPath;
    }

    @Override
    protected PathMappingResult doApply(PathMappingContext mappingCtx) {
        return this.exactPath.equals(mappingCtx.path()) ? PathMappingResult.of(mappingCtx.path(), mappingCtx.query()) : PathMappingResult.empty();
    }

    @Override
    public Set<String> paramNames() {
        return ImmutableSet.of();
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    @Override
    public String meterTag() {
        return this.meterTag;
    }

    @Override
    public Optional<String> exactPath() {
        return this.exactPathOpt;
    }

    @Override
    public Optional<String> triePath() {
        return this.exactPathOpt;
    }

    public int hashCode() {
        return this.meterTag.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof ExactPathMapping && (this == obj || this.exactPath.equals(((ExactPathMapping)obj).exactPath));
    }

    public String toString() {
        return this.meterTag;
    }
}

