/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server;

import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableSet;
import com.linecorp.armeria.server.AbstractPathMapping;
import com.linecorp.armeria.server.PathMappingContext;
import com.linecorp.armeria.server.PathMappingResult;
import com.linecorp.armeria.server.PathMappingResultBuilder;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class GlobPathMapping
extends AbstractPathMapping {
    static final String PREFIX = "glob:";
    static final int PREFIX_LEN = "glob:".length();
    private static final String[] INT_TO_STRING = new String[64];
    private final String glob;
    private final Pattern pattern;
    private final int numParams;
    private final Set<String> paramNames;
    private final String loggerName;
    private final String meterTag;
    private final String strVal;

    private static String int2str(int value) {
        if (value < INT_TO_STRING.length) {
            return INT_TO_STRING[value];
        }
        return Integer.toString(value);
    }

    GlobPathMapping(String glob) {
        PatternAndParamCount patternAndParamCount = GlobPathMapping.globToRegex(glob);
        this.glob = glob;
        this.pattern = patternAndParamCount.pattern;
        this.numParams = patternAndParamCount.numParams;
        ImmutableSet.Builder paramNames = ImmutableSet.builder();
        for (int i = 0; i < this.numParams; ++i) {
            paramNames.add(GlobPathMapping.int2str(i));
        }
        this.paramNames = paramNames.build();
        this.strVal = PREFIX + glob;
        String aGlob = glob.startsWith("/") ? glob : "/**/" + glob;
        this.loggerName = GlobPathMapping.loggerName(aGlob);
        this.meterTag = PREFIX + aGlob;
    }

    @Override
    protected PathMappingResult doApply(PathMappingContext mappingCtx) {
        Matcher m = this.pattern.matcher(mappingCtx.path());
        if (!m.matches()) {
            return PathMappingResult.empty();
        }
        if (this.numParams == 0) {
            return PathMappingResult.of(mappingCtx.path(), mappingCtx.query());
        }
        PathMappingResultBuilder builder = new PathMappingResultBuilder(mappingCtx.path(), mappingCtx.query());
        for (int i = 1; i <= this.numParams; ++i) {
            String value = MoreObjects.firstNonNull(m.group(i), "");
            builder.rawParam(GlobPathMapping.int2str(i - 1), value);
        }
        return builder.build();
    }

    @Override
    public Set<String> paramNames() {
        return this.paramNames;
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    @Override
    public String meterTag() {
        return this.meterTag;
    }

    Pattern asRegex() {
        return this.pattern;
    }

    public int hashCode() {
        return this.strVal.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof GlobPathMapping && (this == obj || this.glob.equals(((GlobPathMapping)obj).glob));
    }

    public String toString() {
        return this.strVal;
    }

    /*
     * Enabled aggressive block sorting
     */
    static PatternAndParamCount globToRegex(String glob) {
        boolean createGroup;
        int numGroups = 0;
        if (glob.charAt(0) != '/') {
            glob = "/**/" + glob;
            createGroup = false;
        } else {
            createGroup = true;
        }
        int pathPatternLen = glob.length();
        StringBuilder buf = new StringBuilder(pathPatternLen).append("^/");
        int asterisks = 0;
        int beforeAsterisk = 47;
        block11: for (int i = 1; i < pathPatternLen; ++i) {
            char c = glob.charAt(i);
            if (c == '*') {
                if (++asterisks <= 2) continue;
                throw new IllegalArgumentException("contains a path pattern with invalid wildcard characters: " + glob + " (only * and ** are allowed)");
            }
            switch (asterisks) {
                case 1: {
                    if (createGroup) {
                        buf.append('(');
                        ++numGroups;
                    }
                    if (beforeAsterisk == 47 && c == '/') {
                        buf.append("[^/]+");
                    } else {
                        buf.append("[^/]*");
                    }
                    if (createGroup) {
                        buf.append(')');
                        break;
                    }
                    createGroup = true;
                    break;
                }
                case 2: {
                    if (beforeAsterisk == 47 && c == '/') {
                        buf.append("(?:");
                        if (createGroup) {
                            buf.append('(');
                            ++numGroups;
                        }
                        buf.append(".+");
                        if (createGroup) {
                            buf.append(')');
                        } else {
                            createGroup = false;
                        }
                        buf.append("/)?");
                        asterisks = 0;
                        continue block11;
                    }
                    if (createGroup) {
                        buf.append('(');
                        ++numGroups;
                    }
                    buf.append(".*");
                    if (createGroup) {
                        buf.append(')');
                        break;
                    }
                    createGroup = false;
                }
            }
            asterisks = 0;
            beforeAsterisk = c;
            switch (c) {
                case '$': 
                case '(': 
                case ')': 
                case '+': 
                case '.': 
                case '?': 
                case '[': 
                case '\\': 
                case ']': 
                case '^': 
                case '{': 
                case '|': 
                case '}': {
                    buf.append('\\');
                    buf.append(c);
                    continue block11;
                }
                default: {
                    buf.append(c);
                }
            }
        }
        switch (asterisks) {
            case 1: {
                if (createGroup) {
                    buf.append('(');
                    ++numGroups;
                }
                if (beforeAsterisk == 47) {
                    buf.append("[^/]+");
                } else {
                    buf.append("[^/]*");
                }
                if (!createGroup) return new PatternAndParamCount(Pattern.compile(buf.append('$').toString()), numGroups);
                buf.append(')');
                return new PatternAndParamCount(Pattern.compile(buf.append('$').toString()), numGroups);
            }
            case 2: {
                if (createGroup) {
                    buf.append('(');
                    ++numGroups;
                }
                buf.append(".*");
                if (!createGroup) return new PatternAndParamCount(Pattern.compile(buf.append('$').toString()), numGroups);
                buf.append(')');
                return new PatternAndParamCount(Pattern.compile(buf.append('$').toString()), numGroups);
            }
        }
        return new PatternAndParamCount(Pattern.compile(buf.append('$').toString()), numGroups);
    }

    static {
        for (int i = 0; i < INT_TO_STRING.length; ++i) {
            GlobPathMapping.INT_TO_STRING[i] = String.valueOf(i);
        }
    }

    private static final class PatternAndParamCount {
        final Pattern pattern;
        final int numParams;

        PatternAndParamCount(Pattern pattern, int numParams) {
            this.pattern = pattern;
            this.numParams = numParams;
        }
    }
}

