/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server;

import com.linecorp.armeria.internal.shaded.guava.base.Ticker;
import java.time.Duration;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicInteger;

abstract class GracefulShutdownSupport {
    GracefulShutdownSupport() {
    }

    static GracefulShutdownSupport create(Duration quietPeriod, Executor blockingTaskExecutor) {
        return GracefulShutdownSupport.create(quietPeriod, blockingTaskExecutor, Ticker.systemTicker());
    }

    static GracefulShutdownSupport create(Duration quietPeriod, Executor blockingTaskExecutor, Ticker ticker) {
        return new DefaultGracefulShutdownSupport(quietPeriod, blockingTaskExecutor, ticker);
    }

    static GracefulShutdownSupport createDisabled() {
        return new DisabledGracefulShutdownSupport();
    }

    abstract void inc();

    abstract void dec();

    abstract int pendingResponses();

    abstract boolean isShuttingDown();

    abstract boolean completedQuietPeriod();

    private static final class DefaultGracefulShutdownSupport
    extends GracefulShutdownSupport {
        private final long quietPeriodNanos;
        private final Ticker ticker;
        private final Executor blockingTaskExecutor;
        private final AtomicInteger pendingResponses = new AtomicInteger();
        private boolean updatedLastResTimeNanos;
        private long lastResTimeNanos;
        private boolean setShutdownStartTimeNanos;
        private long shutdownStartTimeNanos;

        DefaultGracefulShutdownSupport(Duration quietPeriod, Executor blockingTaskExecutor, Ticker ticker) {
            this.quietPeriodNanos = quietPeriod.toNanos();
            this.blockingTaskExecutor = blockingTaskExecutor;
            this.ticker = ticker;
        }

        @Override
        void inc() {
            this.pendingResponses.incrementAndGet();
        }

        @Override
        void dec() {
            this.lastResTimeNanos = this.ticker.read();
            this.updatedLastResTimeNanos = true;
            this.pendingResponses.decrementAndGet();
        }

        @Override
        int pendingResponses() {
            return this.pendingResponses.get();
        }

        @Override
        boolean isShuttingDown() {
            return this.setShutdownStartTimeNanos;
        }

        @Override
        boolean completedQuietPeriod() {
            if (!this.setShutdownStartTimeNanos) {
                this.shutdownStartTimeNanos = this.ticker.read();
                this.setShutdownStartTimeNanos = true;
            }
            if (this.pendingResponses.get() != 0 || !this.completedBlockingTasks()) {
                return false;
            }
            long shutdownStartTimeNanos = this.shutdownStartTimeNanos;
            long currentTimeNanos = this.ticker.read();
            long duration = this.updatedLastResTimeNanos ? Math.min(currentTimeNanos - shutdownStartTimeNanos, currentTimeNanos - this.lastResTimeNanos) : currentTimeNanos - shutdownStartTimeNanos;
            return duration >= this.quietPeriodNanos;
        }

        private boolean completedBlockingTasks() {
            if (!(this.blockingTaskExecutor instanceof ThreadPoolExecutor)) {
                return true;
            }
            ThreadPoolExecutor threadPool = (ThreadPoolExecutor)this.blockingTaskExecutor;
            return threadPool.getQueue().isEmpty() && threadPool.getActiveCount() == 0;
        }
    }

    private static final class DisabledGracefulShutdownSupport
    extends GracefulShutdownSupport {
        private volatile boolean shuttingDown;

        private DisabledGracefulShutdownSupport() {
        }

        @Override
        void inc() {
        }

        @Override
        void dec() {
        }

        @Override
        int pendingResponses() {
            return 0;
        }

        @Override
        boolean isShuttingDown() {
            return this.shuttingDown;
        }

        @Override
        boolean completedQuietPeriod() {
            this.shuttingDown = true;
            return true;
        }
    }
}

