/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server;

import com.linecorp.armeria.common.ClosedSessionException;
import com.linecorp.armeria.common.ContentTooLargeException;
import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.HttpMethod;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.common.ProtocolViolationException;
import com.linecorp.armeria.internal.ArmeriaHttpUtil;
import com.linecorp.armeria.internal.Http1ObjectEncoder;
import com.linecorp.armeria.internal.InboundTrafficController;
import com.linecorp.armeria.internal.shaded.guava.base.Ascii;
import com.linecorp.armeria.server.DecodedHttpRequest;
import com.linecorp.armeria.server.ServerConfig;
import com.linecorp.armeria.unsafe.ByteBufHttpData;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.DecoderResult;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpExpectationFailedEvent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpServerUpgradeHandler;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http2.Http2CodecUtil;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.codec.http2.HttpConversionUtil;
import io.netty.util.AsciiString;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.URISyntaxException;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class Http1RequestDecoder
extends ChannelDuplexHandler {
    private static final Logger logger = LoggerFactory.getLogger(Http1RequestDecoder.class);
    private static final Http2Settings DEFAULT_HTTP2_SETTINGS = new Http2Settings();
    private static final HttpHeaders CONTINUE_RESPONSE = HttpHeaders.of(HttpStatus.CONTINUE);
    private final ServerConfig cfg;
    private final AsciiString scheme;
    private final InboundTrafficController inboundTrafficController;
    private final Http1ObjectEncoder writer;
    @Nullable
    private DecodedHttpRequest req;
    private int receivedRequests;
    private boolean discarding;

    Http1RequestDecoder(ServerConfig cfg, Channel channel, AsciiString scheme, Http1ObjectEncoder writer) {
        this.cfg = cfg;
        this.scheme = scheme;
        this.inboundTrafficController = new InboundTrafficController(channel);
        this.writer = writer;
    }

    public void channelUnregistered(ChannelHandlerContext ctx) throws Exception {
        super.channelUnregistered(ctx);
        if (this.req != null) {
            this.req.close(ClosedSessionException.get());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (!(msg instanceof HttpObject)) {
            ctx.fireChannelRead(msg);
            return;
        }
        DecodedHttpRequest req = this.req;
        int id = req != null ? req.id() : (this.receivedRequests = this.receivedRequests + 1);
        try {
            if (this.discarding) {
                return;
            }
            if (req == null) {
                if (msg instanceof HttpRequest) {
                    boolean contentEmpty;
                    HttpRequest nettyReq = (HttpRequest)msg;
                    if (!nettyReq.decoderResult().isSuccess()) {
                        this.fail(id, HttpResponseStatus.BAD_REQUEST);
                        return;
                    }
                    io.netty.handler.codec.http.HttpHeaders nettyHeaders = nettyReq.headers();
                    if (!HttpMethod.isSupported(nettyReq.method().name())) {
                        this.fail(id, HttpResponseStatus.METHOD_NOT_ALLOWED);
                        return;
                    }
                    String contentLengthStr = nettyHeaders.get((CharSequence)HttpHeaderNames.CONTENT_LENGTH);
                    if (contentLengthStr != null) {
                        long contentLength;
                        try {
                            contentLength = Long.parseLong(contentLengthStr);
                        }
                        catch (NumberFormatException ignored) {
                            this.fail(id, HttpResponseStatus.BAD_REQUEST);
                            ReferenceCountUtil.release((Object)msg);
                            return;
                        }
                        if (contentLength < 0L) {
                            this.fail(id, HttpResponseStatus.BAD_REQUEST);
                            return;
                        }
                        contentEmpty = contentLength == 0L;
                    } else {
                        contentEmpty = true;
                    }
                    if (!this.handle100Continue(id, nettyReq, nettyHeaders)) {
                        ctx.pipeline().fireUserEventTriggered((Object)HttpExpectationFailedEvent.INSTANCE);
                        this.fail(id, HttpResponseStatus.EXPECTATION_FAILED);
                        return;
                    }
                    nettyHeaders.set((CharSequence)HttpConversionUtil.ExtensionHeaderNames.SCHEME.text(), (Object)this.scheme);
                    this.req = req = new DecodedHttpRequest(ctx.channel().eventLoop(), id, 1, ArmeriaHttpUtil.toArmeria(nettyReq), HttpUtil.isKeepAlive((HttpMessage)nettyReq), this.inboundTrafficController, this.cfg.defaultMaxRequestLength());
                    if (contentEmpty && !HttpUtil.isTransferEncodingChunked((HttpMessage)nettyReq)) {
                        req.close();
                    }
                    ctx.fireChannelRead((Object)req);
                } else {
                    this.fail(id, HttpResponseStatus.BAD_REQUEST);
                    return;
                }
            }
            if (req != null && msg instanceof HttpContent) {
                HttpContent content = (HttpContent)msg;
                DecoderResult decoderResult = content.decoderResult();
                if (!decoderResult.isSuccess()) {
                    this.fail(id, HttpResponseStatus.BAD_REQUEST);
                    req.close(new ProtocolViolationException(decoderResult.cause()));
                    return;
                }
                ByteBuf data = content.content();
                int dataLength = data.readableBytes();
                if (dataLength != 0) {
                    req.increaseTransferredBytes(dataLength);
                    long maxContentLength = req.maxRequestLength();
                    if (maxContentLength > 0L && req.transferredBytes() > maxContentLength) {
                        this.fail(id, HttpResponseStatus.REQUEST_ENTITY_TOO_LARGE);
                        req.close(ContentTooLargeException.get());
                        return;
                    }
                    if (req.isOpen()) {
                        req.write(new ByteBufHttpData(data.retain(), false));
                    }
                }
                if (msg instanceof LastHttpContent) {
                    io.netty.handler.codec.http.HttpHeaders trailingHeaders = ((LastHttpContent)msg).trailingHeaders();
                    if (!trailingHeaders.isEmpty()) {
                        req.write(ArmeriaHttpUtil.toArmeria(trailingHeaders));
                    }
                    req.close();
                    req = null;
                    this.req = null;
                }
            }
        }
        catch (URISyntaxException e) {
            this.fail(id, HttpResponseStatus.BAD_REQUEST);
            if (req != null) {
                req.close(e);
            }
        }
        catch (Throwable t) {
            this.fail(id, HttpResponseStatus.INTERNAL_SERVER_ERROR);
            if (req != null) {
                req.close(t);
            } else {
                logger.warn("Unexpected exception:", t);
            }
        }
        finally {
            ReferenceCountUtil.release((Object)msg);
        }
    }

    private boolean handle100Continue(int id, HttpRequest nettyReq, io.netty.handler.codec.http.HttpHeaders nettyHeaders) {
        if (nettyReq.protocolVersion().compareTo(HttpVersion.HTTP_1_1) < 0) {
            return true;
        }
        String expectValue = nettyHeaders.get((CharSequence)HttpHeaderNames.EXPECT);
        if (expectValue == null) {
            return true;
        }
        if (!Ascii.equalsIgnoreCase("100-continue", expectValue)) {
            return false;
        }
        this.writer.writeHeaders(id, 1, CONTINUE_RESPONSE, false);
        nettyHeaders.remove((CharSequence)HttpHeaderNames.EXPECT);
        return true;
    }

    private void fail(int id, HttpResponseStatus status) {
        this.discarding = true;
        this.req = null;
        HttpData data = HttpData.ofUtf8(status.toString());
        HttpHeaders headers = HttpHeaders.of(status.code());
        headers.set(HttpHeaderNames.CONNECTION, "close");
        headers.setObject(HttpHeaderNames.CONTENT_TYPE, MediaType.PLAIN_TEXT_UTF_8);
        headers.setInt(HttpHeaderNames.CONTENT_LENGTH, data.length());
        this.writer.writeHeaders(id, 1, headers, false);
        this.writer.writeData(id, 1, data, true).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof HttpServerUpgradeHandler.UpgradeEvent) {
            ctx.fireChannelRead((Object)DEFAULT_HTTP2_SETTINGS);
            FullHttpRequest nettyReq = ((HttpServerUpgradeHandler.UpgradeEvent)evt).upgradeRequest();
            nettyReq.headers().remove((CharSequence)HttpHeaderNames.CONNECTION);
            nettyReq.headers().remove((CharSequence)HttpHeaderNames.UPGRADE);
            nettyReq.headers().remove(Http2CodecUtil.HTTP_UPGRADE_SETTINGS_HEADER);
            if (logger.isDebugEnabled()) {
                logger.debug("{} Handling the pre-upgrade request ({}): {} {} {} ({}B)", new Object[]{ctx.channel(), ((HttpServerUpgradeHandler.UpgradeEvent)evt).protocol(), nettyReq.method(), nettyReq.uri(), nettyReq.protocolVersion(), nettyReq.content().readableBytes()});
            }
            this.channelRead(ctx, nettyReq);
            this.channelReadComplete(ctx);
            return;
        }
        ctx.fireUserEventTriggered(evt);
    }
}

