/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server;

import com.linecorp.armeria.common.ClosedSessionException;
import com.linecorp.armeria.common.ContentTooLargeException;
import com.linecorp.armeria.common.HttpHeaderNames;
import com.linecorp.armeria.common.HttpMethod;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.internal.ArmeriaHttpUtil;
import com.linecorp.armeria.internal.Http2GoAwayHandler;
import com.linecorp.armeria.internal.InboundTrafficController;
import com.linecorp.armeria.server.DecodedHttpRequest;
import com.linecorp.armeria.server.ServerConfig;
import com.linecorp.armeria.unsafe.ByteBufHttpData;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http2.DefaultHttp2Headers;
import io.netty.handler.codec.http2.Http2ConnectionEncoder;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2EventAdapter;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.codec.http2.Http2Stream;
import io.netty.util.AsciiString;
import io.netty.util.collection.IntObjectHashMap;
import io.netty.util.collection.IntObjectMap;
import java.nio.charset.StandardCharsets;

final class Http2RequestDecoder
extends Http2EventAdapter {
    private final ServerConfig cfg;
    private final Channel channel;
    private final Http2ConnectionEncoder writer;
    private final InboundTrafficController inboundTrafficController;
    private final Http2GoAwayHandler goAwayHandler;
    private final IntObjectMap<DecodedHttpRequest> requests = new IntObjectHashMap();
    private int nextId;

    Http2RequestDecoder(ServerConfig cfg, Channel channel, Http2ConnectionEncoder writer) {
        this.cfg = cfg;
        this.channel = channel;
        this.writer = writer;
        this.inboundTrafficController = new InboundTrafficController(channel);
        this.goAwayHandler = new Http2GoAwayHandler();
    }

    Http2GoAwayHandler goAwayHandler() {
        return this.goAwayHandler;
    }

    public void onSettingsRead(ChannelHandlerContext ctx, Http2Settings settings) {
        ctx.fireChannelRead((Object)settings);
    }

    public void onHeadersRead(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int padding, boolean endOfStream) throws Http2Exception {
        DecodedHttpRequest req = (DecodedHttpRequest)this.requests.get(streamId);
        if (req == null) {
            boolean contentEmpty;
            CharSequence method = headers.method();
            if (method == null) {
                this.writeErrorResponse(ctx, streamId, HttpResponseStatus.BAD_REQUEST);
                return;
            }
            if (!HttpMethod.isSupported(method.toString())) {
                this.writeErrorResponse(ctx, streamId, HttpResponseStatus.METHOD_NOT_ALLOWED);
                return;
            }
            if (headers.contains((Object)HttpHeaderNames.CONTENT_LENGTH)) {
                long contentLength = headers.getLong((Object)HttpHeaderNames.CONTENT_LENGTH, -1L);
                if (contentLength < 0L) {
                    this.writeErrorResponse(ctx, streamId, HttpResponseStatus.BAD_REQUEST);
                    return;
                }
                contentEmpty = contentLength == 0L;
            } else {
                contentEmpty = true;
            }
            if (!this.handle100Continue(ctx, streamId, headers)) {
                this.writeErrorResponse(ctx, streamId, HttpResponseStatus.EXPECTATION_FAILED);
                return;
            }
            req = new DecodedHttpRequest(ctx.channel().eventLoop(), ++this.nextId, streamId, ArmeriaHttpUtil.toArmeria(headers, endOfStream), true, this.inboundTrafficController, this.cfg.defaultMaxRequestLength());
            if (contentEmpty && endOfStream) {
                req.close();
            }
            this.requests.put(streamId, (Object)req);
            ctx.fireChannelRead((Object)req);
        } else {
            try {
                req.write(ArmeriaHttpUtil.toArmeria(headers, endOfStream));
            }
            catch (Throwable t) {
                req.close(t);
                throw Http2Exception.connectionError((Http2Error)Http2Error.INTERNAL_ERROR, (Throwable)t, (String)"failed to consume a HEADERS frame", (Object[])new Object[0]);
            }
        }
        if (endOfStream) {
            req.close();
        }
    }

    public void onHeadersRead(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int streamDependency, short weight, boolean exclusive, int padding, boolean endOfStream) throws Http2Exception {
        this.onHeadersRead(ctx, streamId, headers, padding, endOfStream);
    }

    private boolean handle100Continue(ChannelHandlerContext ctx, int streamId, Http2Headers headers) {
        CharSequence expectValue = (CharSequence)headers.get((Object)HttpHeaderNames.EXPECT);
        if (expectValue == null) {
            return true;
        }
        if (!AsciiString.contentEqualsIgnoreCase((CharSequence)HttpHeaderValues.CONTINUE, (CharSequence)expectValue)) {
            return false;
        }
        this.writer.writeHeaders(ctx, streamId, new DefaultHttp2Headers(false).status((CharSequence)HttpStatus.CONTINUE.codeAsText()), 0, false, ctx.voidPromise());
        headers.remove((Object)HttpHeaderNames.EXPECT);
        return true;
    }

    public void onStreamClosed(Http2Stream stream) {
        this.goAwayHandler.onStreamClosed(this.channel, stream);
        DecodedHttpRequest req = (DecodedHttpRequest)this.requests.remove(stream.id());
        if (req != null) {
            req.close(ClosedSessionException.get());
        }
    }

    public int onDataRead(ChannelHandlerContext ctx, int streamId, ByteBuf data, int padding, boolean endOfStream) throws Http2Exception {
        DecodedHttpRequest req = (DecodedHttpRequest)this.requests.get(streamId);
        if (req == null) {
            throw Http2Exception.connectionError((Http2Error)Http2Error.PROTOCOL_ERROR, (String)"received a DATA Frame for an unknown stream: %d", (Object[])new Object[]{streamId});
        }
        int dataLength = data.readableBytes();
        if (dataLength == 0) {
            if (endOfStream) {
                req.close();
            }
            return padding;
        }
        req.increaseTransferredBytes(dataLength);
        long maxContentLength = req.maxRequestLength();
        if (maxContentLength > 0L && req.transferredBytes() > maxContentLength) {
            Http2Stream stream = this.writer.connection().stream(streamId);
            if (Http2RequestDecoder.isWritable(stream)) {
                this.writeErrorResponse(ctx, streamId, HttpResponseStatus.REQUEST_ENTITY_TOO_LARGE);
                this.writer.writeRstStream(ctx, streamId, Http2Error.CANCEL.code(), ctx.voidPromise());
                if (req.isOpen()) {
                    req.close(ContentTooLargeException.get());
                }
            } else {
                req.abort();
            }
        } else if (req.isOpen()) {
            try {
                req.write(new ByteBufHttpData(data.retain(), endOfStream));
            }
            catch (Throwable t) {
                req.close(t);
                throw Http2Exception.connectionError((Http2Error)Http2Error.INTERNAL_ERROR, (Throwable)t, (String)"failed to consume a DATA frame", (Object[])new Object[0]);
            }
            if (endOfStream) {
                req.close();
            }
        }
        return dataLength + padding;
    }

    private static boolean isWritable(Http2Stream stream) {
        switch (stream.state()) {
            case OPEN: 
            case HALF_CLOSED_REMOTE: {
                return !stream.isHeadersSent();
            }
        }
        return false;
    }

    private void writeErrorResponse(ChannelHandlerContext ctx, int streamId, HttpResponseStatus status) throws Http2Exception {
        byte[] content = status.toString().getBytes(StandardCharsets.UTF_8);
        this.writer.writeHeaders(ctx, streamId, (Http2Headers)((Http2Headers)new DefaultHttp2Headers(false).status((CharSequence)status.codeAsText()).set((Object)HttpHeaderNames.CONTENT_TYPE, (Object)MediaType.PLAIN_TEXT_UTF_8.toString())).setInt((Object)HttpHeaderNames.CONTENT_LENGTH, content.length), 0, false, ctx.voidPromise());
        this.writer.writeData(ctx, streamId, Unpooled.wrappedBuffer((byte[])content), 0, true, ctx.voidPromise());
        Http2Stream stream = this.writer.connection().stream(streamId);
        if (stream != null && this.writer.flowController().hasFlowControlled(stream)) {
            this.writer.flowController().writePendingBytes();
        }
    }

    public void onRstStreamRead(ChannelHandlerContext ctx, int streamId, long errorCode) throws Http2Exception {
        DecodedHttpRequest req = (DecodedHttpRequest)this.requests.get(streamId);
        if (req == null) {
            throw Http2Exception.connectionError((Http2Error)Http2Error.PROTOCOL_ERROR, (String)"received a RST_STREAM frame for an unknown stream: %d", (Object[])new Object[]{streamId});
        }
        req.abortResponse((Throwable)Http2Exception.streamError((int)streamId, (Http2Error)Http2Error.valueOf((long)errorCode), (String)"received a RST_STREAM frame", (Object[])new Object[0]));
    }

    public void onPushPromiseRead(ChannelHandlerContext ctx, int streamId, int promisedStreamId, Http2Headers headers, int padding) throws Http2Exception {
        throw Http2Exception.connectionError((Http2Error)Http2Error.PROTOCOL_ERROR, (String)"received a PUSH_PROMISE frame which only a server can send", (Object[])new Object[0]);
    }

    public void onGoAwaySent(int lastStreamId, long errorCode, ByteBuf debugData) {
        this.goAwayHandler.onGoAwaySent(this.channel, lastStreamId, errorCode, debugData);
    }

    public void onGoAwayReceived(int lastStreamId, long errorCode, ByteBuf debugData) {
        this.goAwayHandler.onGoAwayReceived(this.channel, lastStreamId, errorCode, debugData);
    }
}

