/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server;

import com.linecorp.armeria.internal.AbstractHttp2ConnectionHandler;
import com.linecorp.armeria.server.GracefulShutdownSupport;
import com.linecorp.armeria.server.Http2RequestDecoder;
import com.linecorp.armeria.server.ServerConfig;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2ConnectionDecoder;
import io.netty.handler.codec.http2.Http2ConnectionEncoder;
import io.netty.handler.codec.http2.Http2FrameListener;
import io.netty.handler.codec.http2.Http2Settings;

final class Http2ServerConnectionHandler
extends AbstractHttp2ConnectionHandler {
    private final GracefulShutdownSupport gracefulShutdownSupport;
    private final Http2RequestDecoder requestDecoder;

    Http2ServerConnectionHandler(Http2ConnectionDecoder decoder, Http2ConnectionEncoder encoder, Http2Settings initialSettings, Channel channel, ServerConfig config, GracefulShutdownSupport gracefulShutdownSupport) {
        super(decoder, encoder, initialSettings);
        this.gracefulShutdownSupport = gracefulShutdownSupport;
        this.requestDecoder = new Http2RequestDecoder(config, channel, this.encoder());
        this.connection().addListener((Http2Connection.Listener)this.requestDecoder);
        this.decoder().frameListener((Http2FrameListener)this.requestDecoder);
        long timeout = config.idleTimeoutMillis();
        if (timeout > 0L) {
            this.gracefulShutdownTimeoutMillis(timeout);
        } else {
            this.gracefulShutdownTimeoutMillis(-1L);
        }
    }

    @Override
    protected void onCloseRequest(ChannelHandlerContext ctx) throws Exception {
    }

    @Override
    protected boolean needsImmediateDisconnection() {
        return this.gracefulShutdownSupport.isShuttingDown() || this.requestDecoder.goAwayHandler().receivedErrorGoAway();
    }
}

