/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server;

import com.linecorp.armeria.common.HttpMethod;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.internal.shaded.guava.base.Joiner;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.server.HttpStatusException;
import com.linecorp.armeria.server.PathMapping;
import com.linecorp.armeria.server.PathMappingContext;
import com.linecorp.armeria.server.PathMappingResult;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;

final class HttpHeaderPathMapping
implements PathMapping {
    private static final List<MediaType> ANY_TYPE = ImmutableList.of(MediaType.ANY_TYPE);
    private static final Joiner loggerNameJoiner = Joiner.on('_');
    private static final Joiner meterTagJoiner = Joiner.on(',');
    private final PathMapping pathStringMapping;
    private final Set<HttpMethod> supportedMethods;
    private final List<MediaType> consumeTypes;
    private final List<MediaType> produceTypes;
    private final String loggerName;
    private final String meterTag;
    private final int complexity;

    HttpHeaderPathMapping(PathMapping pathStringMapping, Set<HttpMethod> supportedMethods, List<MediaType> consumeTypes, List<MediaType> produceTypes) {
        this.pathStringMapping = Objects.requireNonNull(pathStringMapping, "pathStringMapping");
        this.supportedMethods = Objects.requireNonNull(supportedMethods, "supportedMethods");
        this.consumeTypes = Objects.requireNonNull(consumeTypes, "consumeTypes");
        this.produceTypes = Objects.requireNonNull(produceTypes, "produceTypes");
        this.loggerName = HttpHeaderPathMapping.generateLoggerName(pathStringMapping.loggerName(), supportedMethods, consumeTypes, produceTypes);
        this.meterTag = HttpHeaderPathMapping.generateMeterTag(pathStringMapping.meterTag(), supportedMethods, consumeTypes, produceTypes);
        int complexity = 1;
        if (!consumeTypes.isEmpty()) {
            complexity += 2;
        }
        if (!produceTypes.isEmpty()) {
            complexity += 4;
        }
        this.complexity = complexity;
    }

    @Override
    public PathMappingResult apply(PathMappingContext mappingCtx) {
        List<MediaType> types;
        PathMappingResult result = this.pathStringMapping.apply(mappingCtx);
        if (!result.isPresent()) {
            return PathMappingResult.empty();
        }
        if (!this.supportedMethods.contains((Object)mappingCtx.method())) {
            if (!mappingCtx.delayedThrowable().isPresent()) {
                mappingCtx.delayThrowable(HttpStatusException.of(HttpStatus.METHOD_NOT_ALLOWED));
            }
            return PathMappingResult.empty();
        }
        if (!this.consumeTypes.isEmpty()) {
            MediaType type = mappingCtx.consumeType();
            boolean found = false;
            if (type != null) {
                MediaType mediaType;
                Iterator<MediaType> iterator = this.consumeTypes.iterator();
                while (iterator.hasNext() && !(found = type.belongsTo(mediaType = iterator.next()))) {
                }
            }
            if (!found) {
                mappingCtx.delayThrowable(HttpStatusException.of(HttpStatus.UNSUPPORTED_MEDIA_TYPE));
                return PathMappingResult.empty();
            }
        }
        if ((types = mappingCtx.produceTypes()) == null) {
            return result;
        }
        List<MediaType> producibleTypes = this.produceTypes.isEmpty() ? ANY_TYPE : this.produceTypes;
        for (MediaType produceType : producibleTypes) {
            for (int i = 0; i < types.size(); ++i) {
                if (!produceType.belongsTo(types.get(i))) continue;
                result.setScore(i == 0 ? Integer.MAX_VALUE : -1 * i);
                if (!this.produceTypes.isEmpty()) {
                    result.setNegotiatedResponseMediaType(produceType);
                }
                return result;
            }
        }
        mappingCtx.delayThrowable(HttpStatusException.of(HttpStatus.NOT_ACCEPTABLE));
        return PathMappingResult.empty();
    }

    @Override
    public Set<String> paramNames() {
        return this.pathStringMapping.paramNames();
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    @Override
    public String meterTag() {
        return this.meterTag;
    }

    @Override
    public Optional<String> exactPath() {
        return this.pathStringMapping.exactPath();
    }

    @Override
    public Optional<String> prefix() {
        return this.pathStringMapping.prefix();
    }

    @Override
    public Optional<String> triePath() {
        return this.pathStringMapping.triePath();
    }

    @Override
    public int complexity() {
        return this.complexity;
    }

    public Set<HttpMethod> supportedMethods() {
        return this.supportedMethods;
    }

    public List<MediaType> consumeTypes() {
        return this.consumeTypes;
    }

    public List<MediaType> produceTypes() {
        return this.produceTypes;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append('[');
        buf.append(this.pathStringMapping);
        buf.append(", ");
        buf.append(MoreObjects.toStringHelper("").add("supportedMethods", this.supportedMethods).add("consumeTypes", this.consumeTypes).add("produceTypes", this.produceTypes));
        buf.append(']');
        return buf.toString();
    }

    private static String generateLoggerName(String prefix, Set<HttpMethod> supportedMethods, List<MediaType> consumeTypes, List<MediaType> produceTypes) {
        StringJoiner name = new StringJoiner(".");
        name.add(prefix);
        name.add(loggerNameJoiner.join(supportedMethods.stream().sorted().iterator()));
        if (!consumeTypes.isEmpty()) {
            name.add("consumes");
            consumeTypes.forEach(e -> name.add(e.type() + '_' + e.subtype()));
        }
        if (!produceTypes.isEmpty()) {
            name.add("produces");
            produceTypes.forEach(e -> name.add(e.type() + '_' + e.subtype()));
        }
        return name.toString();
    }

    private static String generateMeterTag(String parentTag, Set<HttpMethod> supportedMethods, List<MediaType> consumeTypes, List<MediaType> produceTypes) {
        StringJoiner name = new StringJoiner(",");
        name.add(parentTag);
        name.add("methods:" + meterTagJoiner.join(supportedMethods.stream().sorted().iterator()));
        HttpHeaderPathMapping.addMediaTypes(name, "consumes", consumeTypes);
        HttpHeaderPathMapping.addMediaTypes(name, "produces", produceTypes);
        return name.toString();
    }

    private static void addMediaTypes(StringJoiner builder, String prefix, List<MediaType> mediaTypes) {
        if (!mediaTypes.isEmpty()) {
            StringBuilder buf = new StringBuilder();
            buf.append(prefix).append(':');
            for (MediaType t : mediaTypes) {
                buf.append(t.type());
                buf.append('/');
                buf.append(t.subtype());
                buf.append(',');
            }
            buf.setLength(buf.length() - 1);
            builder.add(buf.toString());
        }
    }
}

