/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server;

import com.linecorp.armeria.common.AggregatedHttpMessage;
import com.linecorp.armeria.common.Flags;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpStatus;
import java.util.Objects;

public class HttpResponseException
extends RuntimeException {
    private static final long serialVersionUID = 3487991462085151316L;
    private final HttpResponse httpResponse;

    public static HttpResponseException of(int statusCode) {
        return HttpResponseException.of(HttpStatus.valueOf(statusCode));
    }

    public static HttpResponseException of(HttpStatus httpStatus) {
        Objects.requireNonNull(httpStatus, "httpStatus");
        return new HttpResponseException(HttpResponse.of(httpStatus));
    }

    public static HttpResponseException of(AggregatedHttpMessage httpMessage) {
        return HttpResponseException.of(HttpResponse.of(Objects.requireNonNull(httpMessage, "httpMessage")));
    }

    public static HttpResponseException of(HttpResponse httpResponse) {
        return new HttpResponseException(httpResponse);
    }

    protected HttpResponseException(HttpResponse httpResponse) {
        this.httpResponse = Objects.requireNonNull(httpResponse, "httpResponse");
    }

    public HttpResponse httpResponse() {
        return this.httpResponse;
    }

    @Override
    public Throwable fillInStackTrace() {
        if (Flags.verboseExceptions()) {
            return super.fillInStackTrace();
        }
        return this;
    }
}

