/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server;

import com.linecorp.armeria.common.AggregatedHttpMessage;
import com.linecorp.armeria.common.ClosedSessionException;
import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.HttpHeaderNames;
import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.HttpMethod;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.common.NonWrappingRequestContext;
import com.linecorp.armeria.common.Request;
import com.linecorp.armeria.common.RequestContext;
import com.linecorp.armeria.common.SessionProtocol;
import com.linecorp.armeria.common.logging.DefaultRequestLog;
import com.linecorp.armeria.common.logging.RequestLog;
import com.linecorp.armeria.common.logging.RequestLogAvailability;
import com.linecorp.armeria.common.logging.RequestLogBuilder;
import com.linecorp.armeria.common.metric.NoopMeterRegistry;
import com.linecorp.armeria.common.stream.ClosedPublisherException;
import com.linecorp.armeria.common.util.CompletionActions;
import com.linecorp.armeria.common.util.Exceptions;
import com.linecorp.armeria.common.util.Functions;
import com.linecorp.armeria.common.util.SafeCloseable;
import com.linecorp.armeria.internal.AbstractHttp2ConnectionHandler;
import com.linecorp.armeria.internal.ArmeriaHttpUtil;
import com.linecorp.armeria.internal.Http1ObjectEncoder;
import com.linecorp.armeria.internal.Http2ObjectEncoder;
import com.linecorp.armeria.internal.HttpObjectEncoder;
import com.linecorp.armeria.internal.PathAndQuery;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableSet;
import com.linecorp.armeria.server.DecodedHttpRequest;
import com.linecorp.armeria.server.DefaultPathMappingContext;
import com.linecorp.armeria.server.DefaultServiceRequestContext;
import com.linecorp.armeria.server.GracefulShutdownSupport;
import com.linecorp.armeria.server.Http2ServerConnectionHandler;
import com.linecorp.armeria.server.HttpResponseException;
import com.linecorp.armeria.server.HttpResponseSubscriber;
import com.linecorp.armeria.server.HttpServer;
import com.linecorp.armeria.server.HttpStatusException;
import com.linecorp.armeria.server.PathMapped;
import com.linecorp.armeria.server.PathMappingContext;
import com.linecorp.armeria.server.PathMappingResult;
import com.linecorp.armeria.server.ProxiedAddresses;
import com.linecorp.armeria.server.ServerConfig;
import com.linecorp.armeria.server.ServiceConfig;
import com.linecorp.armeria.server.TransientService;
import com.linecorp.armeria.server.VirtualHost;
import com.linecorp.armeria.server.logging.AccessLogWriter;
import io.micrometer.core.instrument.MeterRegistry;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoop;
import io.netty.channel.socket.ChannelInputShutdownReadComplete;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2ConnectionHandler;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2LocalFlowController;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.ssl.SslCloseCompletionEvent;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.EnumSet;
import java.util.IdentityHashMap;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.net.ssl.SSLSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class HttpServerHandler
extends ChannelInboundHandlerAdapter
implements HttpServer {
    private static final Logger logger = LoggerFactory.getLogger(HttpServerHandler.class);
    private static final MediaType ERROR_CONTENT_TYPE = MediaType.PLAIN_TEXT_UTF_8;
    private static final Set<HttpMethod> ALLOWED_METHODS = Collections.unmodifiableSet(EnumSet.of(HttpMethod.OPTIONS, new HttpMethod[]{HttpMethod.GET, HttpMethod.HEAD, HttpMethod.POST, HttpMethod.PUT, HttpMethod.PATCH, HttpMethod.DELETE, HttpMethod.TRACE}));
    private static final Set<String> ALLOWED_METHOD_NAMES = ALLOWED_METHODS.stream().map(Enum::name).collect(ImmutableSet.toImmutableSet());
    private static final String ALLOWED_METHODS_STRING = ALLOWED_METHODS.stream().map(Enum::name).collect(Collectors.joining(","));
    private static final ChannelFutureListener CLOSE = future -> {
        Throwable cause = future.cause();
        Channel ch = future.channel();
        if (cause != null) {
            HttpServerHandler.logException(ch, cause);
        }
        HttpServerHandler.safeClose(ch);
    };
    static final ChannelFutureListener CLOSE_ON_FAILURE = future -> {
        Throwable cause = future.cause();
        if (cause != null && !(cause instanceof ClosedPublisherException)) {
            Channel ch = future.channel();
            HttpServerHandler.logException(ch, cause);
            HttpServerHandler.safeClose(ch);
        }
    };
    private final ServerConfig config;
    private final GracefulShutdownSupport gracefulShutdownSupport;
    private SessionProtocol protocol;
    @Nullable
    private HttpObjectEncoder responseEncoder;
    @Nullable
    private final ProxiedAddresses proxiedAddresses;
    private final IdentityHashMap<DecodedHttpRequest, HttpResponse> unfinishedRequests;
    private boolean isReading;
    private boolean handledLastRequest;
    private final AccessLogWriter accessLogWriter;

    private static void logException(Channel ch, Throwable cause) {
        HttpServer server = HttpServer.get(ch);
        if (server != null) {
            Exceptions.logIfUnexpected(logger, ch, server.protocol(), cause);
        } else {
            Exceptions.logIfUnexpected(logger, ch, cause);
        }
    }

    static void safeClose(Channel ch) {
        if (!ch.isActive()) {
            return;
        }
        AbstractHttp2ConnectionHandler h2handler = (AbstractHttp2ConnectionHandler)ch.pipeline().get(AbstractHttp2ConnectionHandler.class);
        if (h2handler == null || !h2handler.isClosing()) {
            ch.close();
        }
    }

    HttpServerHandler(ServerConfig config, GracefulShutdownSupport gracefulShutdownSupport, @Nullable HttpObjectEncoder responseEncoder, SessionProtocol protocol, @Nullable ProxiedAddresses proxiedAddresses) {
        assert (protocol == SessionProtocol.H1 || protocol == SessionProtocol.H1C || protocol == SessionProtocol.H2);
        this.config = Objects.requireNonNull(config, "config");
        this.gracefulShutdownSupport = Objects.requireNonNull(gracefulShutdownSupport, "gracefulShutdownSupport");
        this.protocol = Objects.requireNonNull(protocol, "protocol");
        this.responseEncoder = responseEncoder;
        this.proxiedAddresses = proxiedAddresses;
        this.unfinishedRequests = new IdentityHashMap();
        this.accessLogWriter = config.accessLogWriter();
    }

    @Override
    public SessionProtocol protocol() {
        return this.protocol;
    }

    @Override
    public int unfinishedRequests() {
        return this.unfinishedRequests.size();
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        switch (this.protocol) {
            case H1C: 
            case H1: {
                ctx.channel().eventLoop().schedule(this::cleanup, 1L, TimeUnit.SECONDS);
                break;
            }
            default: {
                this.cleanup();
            }
        }
    }

    private void cleanup() {
        if (this.responseEncoder != null) {
            this.responseEncoder.close();
        }
        this.unfinishedRequests.forEach((req, res) -> {
            req.close(ClosedSessionException.get());
            res.abort();
        });
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        this.isReading = true;
        if (msg instanceof Http2Settings) {
            this.handleHttp2Settings(ctx, (Http2Settings)msg);
        } else {
            this.handleRequest(ctx, (DecodedHttpRequest)msg);
        }
    }

    private void handleHttp2Settings(ChannelHandlerContext ctx, Http2Settings h2settings) {
        if (h2settings.isEmpty()) {
            logger.trace("{} HTTP/2 settings: <empty>", (Object)ctx.channel());
        } else {
            logger.debug("{} HTTP/2 settings: {}", (Object)ctx.channel(), (Object)h2settings);
        }
        if (this.protocol == SessionProtocol.H1) {
            this.protocol = SessionProtocol.H2;
        } else if (this.protocol == SessionProtocol.H1C) {
            this.protocol = SessionProtocol.H2C;
        }
        ChannelPipeline pipeline = ctx.pipeline();
        Http2ConnectionHandler handler = (Http2ConnectionHandler)pipeline.get(Http2ConnectionHandler.class);
        if (this.responseEncoder == null) {
            this.responseEncoder = new Http2ObjectEncoder(ctx, handler.encoder());
        } else if (this.responseEncoder instanceof Http1ObjectEncoder) {
            this.responseEncoder.close();
            this.responseEncoder = new Http2ObjectEncoder(ctx, handler.encoder());
        }
        int initialWindow = this.config.http2InitialConnectionWindowSize();
        if (initialWindow > 65535) {
            HttpServerHandler.incrementLocalWindowSize(pipeline, initialWindow - 65535);
        }
    }

    private static void incrementLocalWindowSize(ChannelPipeline pipeline, int delta) {
        try {
            Http2Connection connection = ((Http2ServerConnectionHandler)pipeline.get(Http2ServerConnectionHandler.class)).connection();
            ((Http2LocalFlowController)connection.local().flowController()).incrementWindowSize(connection.connectionStream(), delta);
        }
        catch (Http2Exception e) {
            logger.warn("Failed to increment local flowController window size: {}", (Object)delta, (Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleRequest(ChannelHandlerContext ctx, DecodedHttpRequest req) throws Exception {
        PathMapped<ServiceConfig> mapped;
        HttpHeaders headers;
        String methodName;
        if (this.handledLastRequest) {
            return;
        }
        if (!req.isKeepAlive()) {
            this.handledLastRequest = true;
        }
        if ((methodName = (String)(headers = req.headers()).get(HttpHeaderNames.METHOD)) == null) {
            this.respond(ctx, req, HttpStatus.BAD_REQUEST, new IllegalArgumentException("Method is missing."));
            return;
        }
        if (!ALLOWED_METHOD_NAMES.contains(methodName)) {
            this.respond(ctx, req, HttpStatus.METHOD_NOT_ALLOWED, new IllegalArgumentException("Request method is not allowed: " + methodName));
            return;
        }
        String originalPath = headers.path();
        if (originalPath == null) {
            this.respond(ctx, req, HttpStatus.BAD_REQUEST, new IllegalArgumentException("Request path is missing."));
            return;
        }
        if (originalPath.isEmpty() || originalPath.charAt(0) != '/') {
            if (headers.method() == HttpMethod.OPTIONS && "*".equals(originalPath)) {
                this.handleOptions(ctx, req);
            } else {
                this.respond(ctx, req, HttpStatus.BAD_REQUEST, new IllegalArgumentException("Request path is invalid: " + originalPath));
            }
            return;
        }
        PathAndQuery pathAndQuery = PathAndQuery.parse(originalPath);
        if (pathAndQuery == null) {
            this.respond(ctx, req, HttpStatus.NOT_FOUND, new IllegalArgumentException("Request path is invalid: " + originalPath));
            return;
        }
        this.fillSchemeIfMissing(headers);
        String hostname = this.hostname(ctx, headers);
        VirtualHost host = this.config.findVirtualHost(hostname);
        PathMappingContext mappingCtx = DefaultPathMappingContext.of(host, hostname, pathAndQuery.path(), pathAndQuery.query(), headers, host.producibleMediaTypes());
        try {
            mapped = host.findServiceConfig(mappingCtx);
        }
        catch (HttpStatusException cause2) {
            this.respond(ctx, req, pathAndQuery, cause2.httpStatus(), (Throwable)cause2);
            return;
        }
        catch (Throwable cause3) {
            logger.warn("{} Unexpected exception: {}", new Object[]{ctx.channel(), req, cause3});
            this.respond(ctx, req, pathAndQuery, HttpStatus.INTERNAL_SERVER_ERROR, cause3);
            return;
        }
        if (!mapped.isPresent()) {
            this.handleNonExistentMapping(ctx, req, host, pathAndQuery, mappingCtx);
            return;
        }
        PathMappingResult mappingResult = mapped.mappingResult();
        ServiceConfig serviceCfg = mapped.value();
        TransientService service = serviceCfg.service();
        Channel channel = ctx.channel();
        DefaultServiceRequestContext reqCtx = new DefaultServiceRequestContext(serviceCfg, channel, serviceCfg.server().meterRegistry(), this.protocol, mappingCtx, mappingResult, req, HttpServerHandler.getSSLSession(channel), this.proxiedAddresses);
        try (SafeCloseable ignored = reqCtx.push();){
            HttpResponse serviceResponse;
            RequestLogBuilder logBuilder = reqCtx.logBuilder();
            try {
                req.init(reqCtx);
                serviceResponse = (HttpResponse)service.serve(reqCtx, (DecodedHttpRequest)req);
            }
            catch (HttpResponseException cause4) {
                serviceResponse = cause4.httpResponse();
            }
            catch (Throwable cause5) {
                try {
                    if (cause5 instanceof HttpStatusException) {
                        this.respond(ctx, req, ((HttpStatusException)cause5).httpStatus(), (RequestContext)reqCtx, cause5);
                    } else {
                        logger.warn("{} Unexpected exception: {}, {}", new Object[]{reqCtx, service, req, cause5});
                        this.respond(ctx, req, HttpStatus.INTERNAL_SERVER_ERROR, (RequestContext)reqCtx, cause5);
                    }
                }
                finally {
                    logBuilder.endRequest(cause5);
                    logBuilder.endResponse(cause5);
                }
                if (ignored != null) {
                    if (var17_19 != null) {
                        try {
                            ignored.close();
                        }
                        catch (Throwable throwable) {
                            var17_19.addSuppressed(throwable);
                        }
                    } else {
                        ignored.close();
                    }
                }
                return;
            }
            HttpResponse res = serviceResponse;
            EventLoop eventLoop = channel.eventLoop();
            boolean isTransient = service.as(TransientService.class).isPresent();
            if (!isTransient) {
                this.gracefulShutdownSupport.inc();
            }
            this.unfinishedRequests.put(req, res);
            if (service.shouldCachePath(pathAndQuery.path(), pathAndQuery.query(), mapped.mapping())) {
                reqCtx.log().addListener(log -> {
                    HttpStatus status = log.responseHeaders().status();
                    if (status != null && status.code() >= 200 && status.code() < 400) {
                        pathAndQuery.storeInCache(originalPath);
                    }
                }, RequestLogAvailability.COMPLETE);
            }
            ((CompletableFuture)req.completionFuture().handle(Functions.voidFunction((ret, cause) -> {
                if (cause == null) {
                    logBuilder.endRequest();
                } else {
                    logBuilder.endRequest((Throwable)cause);
                }
            }))).exceptionally(CompletionActions::log);
            ((CompletableFuture)res.completionFuture().handleAsync(Functions.voidFunction((ret, cause) -> {
                req.abort();
                if (!isTransient) {
                    this.gracefulShutdownSupport.dec();
                }
                this.unfinishedRequests.remove(req);
                if (this.unfinishedRequests.isEmpty() && this.handledLastRequest) {
                    ctx.writeAndFlush((Object)Unpooled.EMPTY_BUFFER).addListener((GenericFutureListener)CLOSE);
                }
            }), (Executor)eventLoop)).exceptionally(CompletionActions::log);
            req.setResponse(res);
            assert (this.responseEncoder != null);
            HttpResponseSubscriber resSubscriber = new HttpResponseSubscriber(ctx, this.responseEncoder, reqCtx, req, this.accessLogWriter);
            reqCtx.setRequestTimeoutChangeListener(resSubscriber);
            res.subscribe(resSubscriber, (EventExecutor)eventLoop, true);
        }
    }

    private void handleOptions(ChannelHandlerContext ctx, DecodedHttpRequest req) {
        this.respond(ctx, req, AggregatedHttpMessage.of((HttpHeaders)HttpHeaders.of(HttpStatus.OK).set(HttpHeaderNames.ALLOW, ALLOWED_METHODS_STRING)), (RequestContext)this.newEarlyRespondingRequestContext(ctx, req, req.path(), null), null);
    }

    private void handleNonExistentMapping(ChannelHandlerContext ctx, DecodedHttpRequest req, VirtualHost host, PathAndQuery pathAndQuery, PathMappingContext mappingCtx) {
        String pathWithSlash;
        String path = mappingCtx.path();
        if (path.charAt(path.length() - 1) != '/' && host.findServiceConfig(mappingCtx.overridePath(pathWithSlash = path + '/')).isPresent()) {
            String originalPath = req.path();
            String location = path.length() == originalPath.length() ? pathWithSlash : pathWithSlash + originalPath.substring(path.length());
            this.redirect(ctx, req, pathAndQuery, location);
            return;
        }
        this.respond(ctx, req, HttpStatus.NOT_FOUND, null);
    }

    private void fillSchemeIfMissing(HttpHeaders headers) {
        if (headers.scheme() == null) {
            headers.scheme(this.protocol.isTls() ? "https" : "http");
        }
    }

    private String hostname(ChannelHandlerContext ctx, HttpHeaders headers) {
        String hostname = headers.authority();
        if (hostname == null) {
            String defaultHostname = this.config.defaultVirtualHost().defaultHostname();
            int port = ((InetSocketAddress)ctx.channel().localAddress()).getPort();
            headers.authority(defaultHostname + ':' + port);
            return defaultHostname;
        }
        int hostnameColonIdx = hostname.lastIndexOf(58);
        if (hostnameColonIdx < 0) {
            return hostname;
        }
        return hostname.substring(0, hostnameColonIdx);
    }

    private void redirect(ChannelHandlerContext ctx, DecodedHttpRequest req, PathAndQuery pathAndQuery, String location) {
        this.respond(ctx, req, AggregatedHttpMessage.of((HttpHeaders)HttpHeaders.of(HttpStatus.TEMPORARY_REDIRECT).set(HttpHeaderNames.LOCATION, location)), (RequestContext)this.newEarlyRespondingRequestContext(ctx, req, pathAndQuery.path(), pathAndQuery.query()), null);
    }

    private void respond(ChannelHandlerContext ctx, DecodedHttpRequest req, HttpStatus status, @Nullable Throwable cause) {
        this.respond(ctx, req, status, (RequestContext)this.newEarlyRespondingRequestContext(ctx, req, req.path(), null), cause);
    }

    private void respond(ChannelHandlerContext ctx, DecodedHttpRequest req, PathAndQuery pathAndQuery, HttpStatus status, @Nullable Throwable cause) {
        this.respond(ctx, req, status, (RequestContext)this.newEarlyRespondingRequestContext(ctx, req, pathAndQuery.path(), pathAndQuery.query()), cause);
    }

    private void respond(ChannelHandlerContext ctx, DecodedHttpRequest req, HttpStatus status, RequestContext reqCtx, @Nullable Throwable cause) {
        if (status.code() < 400) {
            this.respond(ctx, req, AggregatedHttpMessage.of(HttpHeaders.of(status)), reqCtx, cause);
            return;
        }
        HttpData content = req.method() == HttpMethod.HEAD || ArmeriaHttpUtil.isContentAlwaysEmpty(status) ? HttpData.EMPTY_DATA : status.toHttpData();
        this.respond(ctx, req, AggregatedHttpMessage.of(HttpHeaders.of(status).contentType(ERROR_CONTENT_TYPE), content), reqCtx, cause);
    }

    private void respond(ChannelHandlerContext ctx, DecodedHttpRequest req, AggregatedHttpMessage res, RequestContext reqCtx, @Nullable Throwable cause) {
        if (!this.handledLastRequest) {
            this.addKeepAliveHeaders(req, res);
            this.respond0(ctx, req, res, reqCtx, cause).addListener((GenericFutureListener)CLOSE_ON_FAILURE);
        } else {
            HttpServerHandler.setContentLength(req, res);
            this.respond0(ctx, req, res, reqCtx, cause).addListener((GenericFutureListener)CLOSE);
        }
        if (!this.isReading) {
            ctx.flush();
        }
    }

    private ChannelFuture respond0(ChannelHandlerContext ctx, DecodedHttpRequest req, AggregatedHttpMessage res, RequestContext reqCtx, @Nullable Throwable cause) {
        req.close();
        boolean trailingHeadersEmpty = res.trailingHeaders().isEmpty();
        boolean contentAndTrailingHeadersEmpty = res.content().isEmpty() && trailingHeadersEmpty;
        RequestLogBuilder logBuilder = reqCtx.logBuilder();
        logBuilder.startResponse();
        assert (this.responseEncoder != null);
        ChannelFuture future = this.responseEncoder.writeHeaders(req.id(), req.streamId(), res.headers(), contentAndTrailingHeadersEmpty);
        logBuilder.responseHeaders(res.headers());
        if (!contentAndTrailingHeadersEmpty) {
            future = this.responseEncoder.writeData(req.id(), req.streamId(), res.content(), trailingHeadersEmpty);
            logBuilder.increaseResponseLength(res.content().length());
            if (!trailingHeadersEmpty) {
                future = this.responseEncoder.writeHeaders(req.id(), req.streamId(), res.trailingHeaders(), true);
            }
        }
        future.addListener(f -> {
            if (cause == null && f.isSuccess()) {
                logBuilder.endResponse();
            } else {
                logBuilder.endResponse(MoreObjects.firstNonNull(cause, f.cause()));
            }
            reqCtx.log().addListener(this.accessLogWriter::log, RequestLogAvailability.COMPLETE);
        });
        return future;
    }

    private void addKeepAliveHeaders(HttpRequest req, AggregatedHttpMessage res) {
        if (this.protocol == SessionProtocol.H1 || this.protocol == SessionProtocol.H1C) {
            res.headers().set(HttpHeaderNames.CONNECTION, "keep-alive");
        }
        HttpServerHandler.setContentLength(req, res);
    }

    private static void setContentLength(HttpRequest req, AggregatedHttpMessage res) {
        if (req.method() == HttpMethod.HEAD || ArmeriaHttpUtil.isContentAlwaysEmpty(res.status())) {
            return;
        }
        res.headers().setInt(HttpHeaderNames.CONTENT_LENGTH, res.content().length());
    }

    @Nullable
    private static SSLSession getSSLSession(Channel channel) {
        SslHandler sslHandler = (SslHandler)channel.pipeline().get(SslHandler.class);
        return sslHandler != null ? sslHandler.engine().getSession() : null;
    }

    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        this.isReading = false;
        ctx.flush();
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof SslCloseCompletionEvent || evt instanceof ChannelInputShutdownReadComplete) {
            return;
        }
        logger.warn("{} Unexpected user event: {}", (Object)ctx.channel(), evt);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        Exceptions.logIfUnexpected(logger, ctx.channel(), this.protocol, cause);
        if (ctx.channel().isActive()) {
            ctx.close();
        }
    }

    private EarlyRespondingRequestContext newEarlyRespondingRequestContext(ChannelHandlerContext ctx, DecodedHttpRequest req, String path, @Nullable String query) {
        Channel channel = ctx.channel();
        EarlyRespondingRequestContext reqCtx = new EarlyRespondingRequestContext(channel, NoopMeterRegistry.get(), this.protocol(), req.method(), path, query, req);
        RequestLogBuilder logBuilder = reqCtx.logBuilder();
        logBuilder.startRequest(channel, this.protocol());
        logBuilder.requestHeaders(req.headers());
        return reqCtx;
    }

    private static final class EarlyRespondingRequestContext
    extends NonWrappingRequestContext {
        private final Channel channel;
        private final DefaultRequestLog requestLog;

        EarlyRespondingRequestContext(Channel channel, MeterRegistry meterRegistry, SessionProtocol sessionProtocol, HttpMethod method, String path, @Nullable String query, Request request) {
            super(meterRegistry, sessionProtocol, method, path, query, request);
            this.channel = Objects.requireNonNull(channel, "channel");
            this.requestLog = new DefaultRequestLog(this);
        }

        @Override
        public RequestContext newDerivedContext() {
            return this.newDerivedContext((Request)this.request());
        }

        @Override
        public RequestContext newDerivedContext(Request request) {
            return new EarlyRespondingRequestContext(this.channel, this.meterRegistry(), this.sessionProtocol(), this.method(), this.path(), this.query(), request);
        }

        @Override
        protected Channel channel() {
            return this.channel;
        }

        @Override
        public RequestLog log() {
            return this.requestLog;
        }

        @Override
        public RequestLogBuilder logBuilder() {
            return this.requestLog;
        }

        @Override
        public EventLoop eventLoop() {
            return this.channel.eventLoop();
        }
    }
}

