/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server;

import com.linecorp.armeria.common.SessionProtocol;
import com.linecorp.armeria.common.util.Exceptions;
import com.linecorp.armeria.internal.Http1ObjectEncoder;
import com.linecorp.armeria.internal.ReadSuppressingHandler;
import com.linecorp.armeria.internal.TrafficLoggingHandler;
import com.linecorp.armeria.internal.shaded.guava.collect.Iterables;
import com.linecorp.armeria.server.GracefulShutdownSupport;
import com.linecorp.armeria.server.Http1RequestDecoder;
import com.linecorp.armeria.server.Http2ServerConnectionHandler;
import com.linecorp.armeria.server.HttpServerHandler;
import com.linecorp.armeria.server.HttpServerIdleTimeoutHandler;
import com.linecorp.armeria.server.ProxiedAddresses;
import com.linecorp.armeria.server.ServerConfig;
import com.linecorp.armeria.server.ServerPort;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.MessageToMessageDecoder;
import io.netty.handler.codec.haproxy.HAProxyMessage;
import io.netty.handler.codec.haproxy.HAProxyMessageDecoder;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.HttpServerUpgradeHandler;
import io.netty.handler.codec.http2.DefaultHttp2Connection;
import io.netty.handler.codec.http2.DefaultHttp2ConnectionDecoder;
import io.netty.handler.codec.http2.DefaultHttp2ConnectionEncoder;
import io.netty.handler.codec.http2.DefaultHttp2FrameReader;
import io.netty.handler.codec.http2.DefaultHttp2FrameWriter;
import io.netty.handler.codec.http2.Http2CodecUtil;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2ConnectionDecoder;
import io.netty.handler.codec.http2.Http2ConnectionEncoder;
import io.netty.handler.codec.http2.Http2ConnectionHandler;
import io.netty.handler.codec.http2.Http2FrameReader;
import io.netty.handler.codec.http2.Http2FrameWriter;
import io.netty.handler.codec.http2.Http2ServerUpgradeCodec;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.flush.FlushConsolidationHandler;
import io.netty.handler.ssl.ApplicationProtocolNegotiationHandler;
import io.netty.handler.ssl.SniHandler;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.AsciiString;
import io.netty.util.DomainNameMapping;
import java.net.InetSocketAddress;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import javax.net.ssl.SSLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class HttpServerPipelineConfigurator
extends ChannelInitializer<Channel> {
    private static final Logger logger = LoggerFactory.getLogger(HttpServerPipelineConfigurator.class);
    private static final int SSL_RECORD_HEADER_LENGTH = 5;
    private static final AsciiString SCHEME_HTTP = AsciiString.of((CharSequence)"http");
    private static final AsciiString SCHEME_HTTPS = AsciiString.of((CharSequence)"https");
    private static final int UPGRADE_REQUEST_MAX_LENGTH = 16384;
    private static final byte[] PROXY_V1_MAGIC_BYTES = new byte[]{80, 82, 79, 88, 89};
    private static final byte[] PROXY_V2_MAGIC_BYTES = new byte[]{13, 10, 13, 10, 0, 13, 10, 81, 85, 73, 84, 10};
    private final ServerConfig config;
    private final ServerPort port;
    @Nullable
    private final DomainNameMapping<SslContext> sslContexts;
    private final GracefulShutdownSupport gracefulShutdownSupport;

    HttpServerPipelineConfigurator(ServerConfig config, ServerPort port, @Nullable DomainNameMapping<SslContext> sslContexts, GracefulShutdownSupport gracefulShutdownSupport) {
        this.config = Objects.requireNonNull(config, "config");
        this.port = Objects.requireNonNull(port, "port");
        this.sslContexts = sslContexts;
        this.gracefulShutdownSupport = Objects.requireNonNull(gracefulShutdownSupport, "gracefulShutdownSupport");
    }

    protected void initChannel(Channel ch) throws Exception {
        ChannelPipeline p = ch.pipeline();
        p.addLast(new ChannelHandler[]{new FlushConsolidationHandler()});
        p.addLast(new ChannelHandler[]{ReadSuppressingHandler.INSTANCE});
        this.configurePipeline(p, this.port.protocols(), null);
    }

    private void configurePipeline(ChannelPipeline p, Set<SessionProtocol> protocols, @Nullable ProxiedAddresses proxiedAddresses) {
        if (protocols.size() == 1) {
            switch ((SessionProtocol)Iterables.getFirst(protocols, null)) {
                case HTTP: {
                    this.configureHttp(p, proxiedAddresses);
                    break;
                }
                case HTTPS: {
                    this.configureHttps(p, proxiedAddresses);
                    break;
                }
                default: {
                    throw new Error();
                }
            }
            return;
        }
        p.addLast(new ChannelHandler[]{new ProtocolDetectionHandler(protocols, proxiedAddresses)});
    }

    private void configureHttp(ChannelPipeline p, @Nullable ProxiedAddresses proxiedAddresses) {
        Http1ObjectEncoder responseEncoder = new Http1ObjectEncoder(p.channel(), true, false);
        p.addLast(new ChannelHandler[]{TrafficLoggingHandler.SERVER});
        p.addLast(new ChannelHandler[]{new Http2PrefaceOrHttpHandler(responseEncoder)});
        this.configureIdleTimeoutHandler(p);
        p.addLast(new ChannelHandler[]{new HttpServerHandler(this.config, this.gracefulShutdownSupport, responseEncoder, SessionProtocol.H1C, proxiedAddresses)});
    }

    private void configureIdleTimeoutHandler(ChannelPipeline p) {
        if (this.config.idleTimeoutMillis() > 0L) {
            p.addFirst(new ChannelHandler[]{new HttpServerIdleTimeoutHandler(this.config.idleTimeoutMillis())});
        }
    }

    private void configureHttps(ChannelPipeline p, @Nullable ProxiedAddresses proxiedAddresses) {
        assert (this.sslContexts != null);
        p.addLast(new ChannelHandler[]{new SniHandler(this.sslContexts)});
        p.addLast(new ChannelHandler[]{TrafficLoggingHandler.SERVER});
        p.addLast(new ChannelHandler[]{new Http2OrHttpHandler(proxiedAddresses)});
    }

    private Http2ConnectionHandler newHttp2ConnectionHandler(ChannelPipeline pipeline) {
        DefaultHttp2Connection conn = new DefaultHttp2Connection(true);
        DefaultHttp2FrameReader reader = new DefaultHttp2FrameReader(true);
        DefaultHttp2FrameWriter writer = new DefaultHttp2FrameWriter();
        DefaultHttp2ConnectionEncoder encoder = new DefaultHttp2ConnectionEncoder((Http2Connection)conn, (Http2FrameWriter)writer);
        DefaultHttp2ConnectionDecoder decoder = new DefaultHttp2ConnectionDecoder((Http2Connection)conn, (Http2ConnectionEncoder)encoder, (Http2FrameReader)reader);
        return new Http2ServerConnectionHandler((Http2ConnectionDecoder)decoder, (Http2ConnectionEncoder)encoder, this.http2Settings(), pipeline.channel(), this.config, this.gracefulShutdownSupport);
    }

    private Http2Settings http2Settings() {
        int maxFrameSize;
        Http2Settings settings = new Http2Settings();
        int initialWindowSize = this.config.http2InitialStreamWindowSize();
        if (initialWindowSize != 65535) {
            settings.initialWindowSize(initialWindowSize);
        }
        if ((maxFrameSize = this.config.http2MaxFrameSize()) != 16384) {
            settings.maxFrameSize(maxFrameSize);
        }
        settings.maxConcurrentStreams(Math.min(this.config.http2MaxStreamsPerConnection(), Integer.MAX_VALUE));
        settings.maxHeaderListSize(this.config.http2MaxHeaderListSize());
        return settings;
    }

    private final class Http2PrefaceOrHttpHandler
    extends ByteToMessageDecoder {
        private final Http1ObjectEncoder responseEncoder;
        @Nullable
        private String name;

        Http2PrefaceOrHttpHandler(Http1ObjectEncoder responseEncoder) {
            this.responseEncoder = responseEncoder;
        }

        public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
            super.handlerAdded(ctx);
            this.name = ctx.name();
        }

        protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
            if (in.readableBytes() < 4) {
                return;
            }
            if (in.getInt(in.readerIndex()) == 1347569952) {
                this.configureHttp2(ctx);
            } else {
                this.configureHttp1WithUpgrade(ctx);
            }
            ctx.pipeline().remove((ChannelHandler)this);
        }

        private void configureHttp1WithUpgrade(ChannelHandlerContext ctx) {
            ChannelPipeline p = ctx.pipeline();
            HttpServerCodec http1codec = new HttpServerCodec(HttpServerPipelineConfigurator.this.config.http1MaxInitialLineLength(), HttpServerPipelineConfigurator.this.config.http1MaxHeaderSize(), HttpServerPipelineConfigurator.this.config.http1MaxChunkSize());
            String baseName = this.name;
            assert (baseName != null);
            baseName = this.addAfter(p, baseName, (ChannelHandler)http1codec);
            baseName = this.addAfter(p, baseName, (ChannelHandler)new HttpServerUpgradeHandler((HttpServerUpgradeHandler.SourceCodec)http1codec, protocol -> {
                if (!AsciiString.contentEquals((CharSequence)Http2CodecUtil.HTTP_UPGRADE_PROTOCOL_NAME, (CharSequence)protocol)) {
                    return null;
                }
                return new Http2ServerUpgradeCodec(HttpServerPipelineConfigurator.this.newHttp2ConnectionHandler(p));
            }, 16384));
            this.addAfter(p, baseName, (ChannelHandler)new Http1RequestDecoder(HttpServerPipelineConfigurator.this.config, ctx.channel(), SCHEME_HTTP, this.responseEncoder));
        }

        private void configureHttp2(ChannelHandlerContext ctx) {
            ChannelPipeline p = ctx.pipeline();
            assert (this.name != null);
            this.addAfter(p, this.name, (ChannelHandler)HttpServerPipelineConfigurator.this.newHttp2ConnectionHandler(p));
        }

        private String addAfter(ChannelPipeline p, String baseName, ChannelHandler handler) {
            p.addAfter(baseName, null, handler);
            return p.context(handler).name();
        }
    }

    private final class Http2OrHttpHandler
    extends ApplicationProtocolNegotiationHandler {
        @Nullable
        private final ProxiedAddresses proxiedAddresses;

        Http2OrHttpHandler(@Nullable ProxiedAddresses proxiedAddresses) {
            super("http/1.1");
            this.proxiedAddresses = proxiedAddresses;
        }

        protected void configurePipeline(ChannelHandlerContext ctx, String protocol) throws Exception {
            if ("h2".equals(protocol)) {
                this.addHttp2Handlers(ctx);
                return;
            }
            if ("http/1.1".equals(protocol)) {
                this.addHttpHandlers(ctx);
                return;
            }
            throw new IllegalStateException("unknown protocol: " + protocol);
        }

        private void addHttp2Handlers(ChannelHandlerContext ctx) {
            ChannelPipeline p = ctx.pipeline();
            p.addLast(new ChannelHandler[]{HttpServerPipelineConfigurator.this.newHttp2ConnectionHandler(p)});
            HttpServerPipelineConfigurator.this.configureIdleTimeoutHandler(p);
            p.addLast(new ChannelHandler[]{new HttpServerHandler(HttpServerPipelineConfigurator.this.config, HttpServerPipelineConfigurator.this.gracefulShutdownSupport, null, SessionProtocol.H2, this.proxiedAddresses)});
        }

        private void addHttpHandlers(ChannelHandlerContext ctx) {
            Channel ch = ctx.channel();
            ChannelPipeline p = ctx.pipeline();
            Http1ObjectEncoder writer = new Http1ObjectEncoder(ch, true, true);
            p.addLast(new ChannelHandler[]{new HttpServerCodec(HttpServerPipelineConfigurator.this.config.http1MaxInitialLineLength(), HttpServerPipelineConfigurator.this.config.http1MaxHeaderSize(), HttpServerPipelineConfigurator.this.config.http1MaxChunkSize())});
            p.addLast(new ChannelHandler[]{new Http1RequestDecoder(HttpServerPipelineConfigurator.this.config, ch, SCHEME_HTTPS, writer)});
            HttpServerPipelineConfigurator.this.configureIdleTimeoutHandler(p);
            p.addLast(new ChannelHandler[]{new HttpServerHandler(HttpServerPipelineConfigurator.this.config, HttpServerPipelineConfigurator.this.gracefulShutdownSupport, writer, SessionProtocol.H1, this.proxiedAddresses)});
        }

        protected void handshakeFailure(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            logger.warn("{} TLS handshake failed:", (Object)ctx.channel(), (Object)cause);
            ctx.close();
            ctx.pipeline().addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

                public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
                    if (cause instanceof DecoderException && cause.getCause() instanceof SSLException) {
                        return;
                    }
                    Exceptions.logIfUnexpected(logger, ctx.channel(), cause);
                }
            }});
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            Exceptions.logIfUnexpected(logger, ctx.channel(), cause);
            ctx.close();
        }
    }

    private final class ProxiedPipelineConfigurator
    extends MessageToMessageDecoder<HAProxyMessage> {
        private final EnumSet<SessionProtocol> proxiedCandidates;

        ProxiedPipelineConfigurator(EnumSet<SessionProtocol> proxiedCandidates) {
            this.proxiedCandidates = proxiedCandidates;
        }

        protected void decode(ChannelHandlerContext ctx, HAProxyMessage msg, List<Object> out) throws Exception {
            if (logger.isDebugEnabled()) {
                logger.debug("PROXY message {}: {}:{} -> {}:{} (next: {})", new Object[]{msg.protocolVersion().name(), msg.sourceAddress(), msg.sourcePort(), msg.destinationAddress(), msg.destinationPort(), this.proxiedCandidates});
            }
            ChannelPipeline p = ctx.pipeline();
            ProxiedAddresses proxiedAddresses = ProxiedAddresses.of(InetSocketAddress.createUnresolved(msg.sourceAddress(), msg.sourcePort()), InetSocketAddress.createUnresolved(msg.destinationAddress(), msg.destinationPort()));
            HttpServerPipelineConfigurator.this.configurePipeline(p, this.proxiedCandidates, proxiedAddresses);
            p.remove((ChannelHandler)this);
        }
    }

    private final class ProtocolDetectionHandler
    extends ByteToMessageDecoder {
        private final EnumSet<SessionProtocol> candidates;
        @Nullable
        private final EnumSet<SessionProtocol> proxiedCandidates;
        @Nullable
        private final ProxiedAddresses proxiedAddresses;

        ProtocolDetectionHandler(Set<SessionProtocol> protocols, @Nullable ProxiedAddresses proxiedAddresses) {
            this.candidates = EnumSet.copyOf(protocols);
            if (protocols.contains((Object)SessionProtocol.PROXY)) {
                this.proxiedCandidates = EnumSet.copyOf(this.candidates);
                this.proxiedCandidates.remove((Object)SessionProtocol.PROXY);
            } else {
                this.proxiedCandidates = null;
            }
            this.proxiedAddresses = proxiedAddresses;
        }

        protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
            int readableBytes = in.readableBytes();
            Enum detected = null;
            Iterator i = this.candidates.iterator();
            while (i.hasNext()) {
                SessionProtocol protocol = (SessionProtocol)((Object)i.next());
                switch (protocol) {
                    case HTTPS: {
                        if (readableBytes < 5) break;
                        if (SslHandler.isEncrypted((ByteBuf)in)) {
                            detected = SessionProtocol.HTTPS;
                            break;
                        }
                        i.remove();
                        break;
                    }
                    case PROXY: {
                        assert (PROXY_V1_MAGIC_BYTES.length < PROXY_V2_MAGIC_BYTES.length);
                        if (readableBytes < PROXY_V1_MAGIC_BYTES.length) break;
                        if (this.match(PROXY_V1_MAGIC_BYTES, in)) {
                            detected = SessionProtocol.PROXY;
                            break;
                        }
                        if (readableBytes < PROXY_V2_MAGIC_BYTES.length) break;
                        if (this.match(PROXY_V2_MAGIC_BYTES, in)) {
                            detected = SessionProtocol.PROXY;
                            break;
                        }
                        i.remove();
                    }
                }
            }
            if (detected == null) {
                if (this.candidates.size() == 1) {
                    detected = SessionProtocol.HTTP;
                } else {
                    return;
                }
            }
            ChannelPipeline p = ctx.pipeline();
            switch (1.$SwitchMap$com$linecorp$armeria$common$SessionProtocol[detected.ordinal()]) {
                case 1: {
                    HttpServerPipelineConfigurator.this.configureHttp(p, this.proxiedAddresses);
                    break;
                }
                case 2: {
                    HttpServerPipelineConfigurator.this.configureHttps(p, this.proxiedAddresses);
                    break;
                }
                case 3: {
                    assert (this.proxiedCandidates != null);
                    p.addLast(new ChannelHandler[]{new HAProxyMessageDecoder(HttpServerPipelineConfigurator.this.config.proxyProtocolMaxTlvSize())});
                    p.addLast(new ChannelHandler[]{new ProxiedPipelineConfigurator(this.proxiedCandidates)});
                    break;
                }
                default: {
                    throw new Error();
                }
            }
            p.remove((ChannelHandler)this);
        }

        private boolean match(byte[] prefix, ByteBuf buffer) {
            int idx = buffer.readerIndex();
            for (int i = 0; i < prefix.length; ++i) {
                byte b = buffer.getByte(idx + i);
                if (b == prefix[i]) continue;
                return false;
            }
            return true;
        }
    }
}

