/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server;

import com.linecorp.armeria.common.Flags;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.util.Exceptions;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

public final class HttpStatusException
extends RuntimeException {
    private static final Map<Integer, HttpStatusException> EXCEPTIONS = new ConcurrentHashMap<Integer, HttpStatusException>();
    private static final long serialVersionUID = 3341744805097308847L;
    private final HttpStatus httpStatus;

    public static HttpStatusException of(int statusCode) {
        return HttpStatusException.of(HttpStatus.valueOf(statusCode));
    }

    public static HttpStatusException of(HttpStatus httpStatus) {
        Objects.requireNonNull(httpStatus, "httpStatus");
        if (Flags.verboseExceptions()) {
            return new HttpStatusException(httpStatus);
        }
        int statusCode = httpStatus.code();
        return EXCEPTIONS.computeIfAbsent(statusCode, code -> Exceptions.clearTrace(new HttpStatusException(HttpStatus.valueOf(code))));
    }

    private HttpStatusException(HttpStatus httpStatus) {
        super(Objects.requireNonNull(httpStatus, "httpStatus").toString());
        this.httpStatus = httpStatus;
    }

    public HttpStatus httpStatus() {
        return this.httpStatus;
    }

    @Override
    public Throwable fillInStackTrace() {
        if (Flags.verboseExceptions()) {
            return super.fillInStackTrace();
        }
        return this;
    }
}

